/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ins.remote.InsAreaPersonByPersonRemote;
import com.zkteco.zkbiosecurity.ins.service.InsAreaPersonByAreaService;
import com.zkteco.zkbiosecurity.ins.service.InsAreaPersonByPersonService;
import com.zkteco.zkbiosecurity.ins.vo.InsAreaInPersonItem;
import com.zkteco.zkbiosecurity.ins.vo.InsAreaPersonByPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsAreaPersonByPersonController
extends BaseController
implements InsAreaPersonByPersonRemote {
    @Autowired
    private InsAreaPersonByPersonService insAreaPersonByPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private InsAreaPersonByAreaService insAreaPersonByAreaService;
    private final Logger logger = LoggerFactory.getLogger(InsAreaPersonByPersonController.class);

    @RequiresPermissions(value={"ins:areaPersonByPerson"})
    public ModelAndView index() {
        return new ModelAndView("ins/areaPerson/insAreaPersonByPerson");
    }

    @RequiresPermissions(value={"ins:areaPersonByPerson:refresh"})
    public DxGrid list(InsAreaPersonByPersonItem condition) {
        Pager pager = this.insAreaPersonByPersonService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ins:areaPersonByPerson:refresh"})
    public DxGrid getPersonAreaList(InsAreaInPersonItem condition) {
        Pager pager = this.insAreaPersonByPersonService.loadAreaPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ins:areaPersonByPerson:addArea"})
    @LogRequest(module="ins_module", object="common_setByPerson", opType="common_level_addPersonArea", requestParams={"personPin", "areaNames"}, opContent="base_area_name")
    public ZKResultMsg addArea(@RequestParam(value="areaIds") String areaIds, @RequestParam(value="personId") String personId) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)areaIds)) {
            try {
                List areaArrayIds = this.insAreaPersonByAreaService.splitPersonIds(areaIds, 200);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{areaArrayIds.size()};
                areaArrayIds.parallelStream().forEach(areaArrayId -> {
                    this.insAreaPersonByPersonService.addAreaByPersonIds(personId, areaArrayId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error("addPerson with area error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

