/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.remote.InsAdMediaDeviceRemote;
import com.zkteco.zkbiosecurity.ins.service.InsAdMediaDeviceService;
import com.zkteco.zkbiosecurity.ins.service.InsAdMediaService;
import com.zkteco.zkbiosecurity.ins.service.InsDeviceService;
import com.zkteco.zkbiosecurity.ins.vo.InsAdMediaDeviceItem;
import com.zkteco.zkbiosecurity.ins.vo.InsAdMediaExtItem;
import com.zkteco.zkbiosecurity.ins.vo.InsAdMediaSelectItem;
import com.zkteco.zkbiosecurity.ins.vo.InsDeviceExtItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsAdMediaDeviceController
extends BaseController
implements InsAdMediaDeviceRemote {
    @Autowired
    private InsAdMediaDeviceService insAdMediaDeviceService;
    @Autowired
    private InsDeviceService insDeviceService;
    @Autowired
    private InsAdMediaService insAdMediaService;

    @RequiresPermissions(value={"ins:adMediaDevice"})
    public ModelAndView index() {
        return new ModelAndView("ins/adMediaDevice/insAdMediaDevice");
    }

    public DxGrid leftDeviceList(InsDeviceExtItem condition) {
        Pager pager = this.insDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid rightAdMediaList(InsAdMediaExtItem condition) {
        Pager pager = this.insAdMediaService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAdMediaList(InsAdMediaSelectItem condition) {
        Pager pager = this.insAdMediaDeviceService.selectAdMediaList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, InsAdMediaSelectItem.class);
    }

    @RequiresPermissions(value={"ins:adMediaDevice:add"})
    @LogRequest(module="ins_module", object="ins_ad_media_adMediaSet", opType="ins_ad_media_addAdMedia", requestParams={"devName", "mediaName"}, opContent="ins_ad_media_media_name")
    public ZKResultMsg save(String deviceId, String adMediaId) {
        String[] split = StringUtils.split((String)adMediaId, (String)",");
        List<String> adMedias = Arrays.asList(split);
        adMedias.forEach(media -> {
            InsAdMediaDeviceItem insAdMediaDeviceItem = new InsAdMediaDeviceItem();
            insAdMediaDeviceItem.setDevId(deviceId);
            insAdMediaDeviceItem.setAdMediaId(media);
            try {
                this.insAdMediaDeviceService.saveItem(insAdMediaDeviceItem, "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:adMediaDevice:del"})
    @LogRequest(module="ins_module", object="ins_ad_media_adMediaSet", opType="common_op_del", requestParams={"devName", "mediaName"}, opContent="ins_ad_media_media_name")
    public ZKResultMsg delete(String ids, String deviceId) {
        String[] split = StringUtils.split((String)ids, (String)",");
        List<String> adMedias = Arrays.asList(split);
        adMedias.forEach(media -> this.insAdMediaDeviceService.deleteByDeviceIdAndAdMediaId(deviceId, media));
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

