/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.remote.InsAdMediaRemote;
import com.zkteco.zkbiosecurity.ins.service.InsAdMediaDeviceService;
import com.zkteco.zkbiosecurity.ins.service.InsAdMediaService;
import com.zkteco.zkbiosecurity.ins.vo.InsAdMediaItem;
import com.zkteco.zkbiosecurity.ins.vo.InsAdMediaSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsAdMediaController
extends BaseController
implements InsAdMediaRemote {
    @Autowired
    private InsAdMediaService insAdMediaService;
    @Autowired
    private InsAdMediaDeviceService insAdMediaDeviceService;

    @RequiresPermissions(value={"ins:admedia"})
    public ModelAndView index() {
        return new ModelAndView("ins/admedia/insAdMedia");
    }

    @RequiresPermissions(value={"ins:admedia:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            InsAdMediaItem adMedia = this.insAdMediaService.getItemById(id);
            String path = adMedia.getMediaPath().substring(adMedia.getMediaPath().lastIndexOf("/") + 1);
            this.request.setAttribute("fileName", (Object)path);
            this.request.setAttribute("item", (Object)adMedia);
        }
        return new ModelAndView("ins/admedia/editInsAdMedia");
    }

    @LogChangeRequest(module="ins_module", object="ins_ad_media_adMediaResource", opType="common_op_add", vo=InsAdMediaItem.class, service=InsAdMediaService.class)
    @RequiresPermissions(value={"ins:admedia:edit"})
    public ZKResultMsg save(InsAdMediaItem item, @RequestParam(value="mediaFile", required=false) MultipartFile file) {
        ZKResultMsg res = new ZKResultMsg();
        String oldMediaSuffix = "";
        if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            oldMediaSuffix = this.request.getParameter("oldMediaSuffix");
        }
        String mediaSuffix = "";
        String allowType = "jpg,png,gif,wmv,mp4";
        if (Objects.nonNull(file) && !file.isEmpty()) {
            mediaSuffix = file.getOriginalFilename();
            if (!allowType.contains((mediaSuffix = mediaSuffix.substring(mediaSuffix.lastIndexOf(".") + 1)).toLowerCase())) {
                res.setRet("fail");
                res.setMsg("ins_media_type_nonsupport");
                return I18nUtil.i18nMsg((ZKResultMsg)res);
            }
            item.setMediaSuffix(mediaSuffix);
            String fileName = System.currentTimeMillis() + "." + mediaSuffix;
            String photoPath = FileUtil.saveFileToServer((String)"ins", (String)"adpic", (String)fileName, (MultipartFile)file);
            item.setMediaPath(photoPath);
        }
        if ("2".equals(item.getMediaResType()) && item.getMediaPath().lastIndexOf(".") > 0) {
            String outMediaPath = item.getMediaPath();
            String outSuffix = outMediaPath.substring(outMediaPath.lastIndexOf(".") + 1);
            item.setMediaSuffix(outSuffix);
        }
        this.insAdMediaService.saveItem(item, oldMediaSuffix);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:admedia:refresh"})
    public DxGrid list(InsAdMediaItem codition) {
        Pager pager = this.insAdMediaService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"ins:admedia:del"})
    @LogRequest(module="ins_module", object="ins_ad_media_adMediaResource", opType="common_op_del", requestParams={"names"}, opContent="ins_ad_media_media_name")
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.insAdMediaService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public DxGrid selectAdMediaList(InsAdMediaSelectItem condition) {
        Pager pager = null;
        if (condition.getType().equals("noSelected")) {
            if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
                condition.setSelectId("-1");
            }
            pager = this.insAdMediaService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        } else {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getFileNameSuffix(String url) {
        ZKResultMsg res = new ZKResultMsg();
        String fileSuffix = null;
        File file = new File(url);
        if (StringUtils.isNotEmpty((CharSequence)file.getName()) && file.getName().lastIndexOf(".") > 0) {
            String suffix;
            fileSuffix = suffix = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        }
        res.setData(fileSuffix);
        return res;
    }

    public boolean isMediaNameExit(String mediaName) {
        return this.insAdMediaService.isMediaNameExit(mediaName);
    }
}

