/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.api.vo.InsApiDeviceItem;
import com.zkteco.zkbiosecurity.ins.service.InsDeviceService;
import com.zkteco.zkbiosecurity.ins.vo.InsDeviceItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/device"})
@Api(tags={"InsDevice"}, description="ins device")
public class InsApiV2DeviceController {
    private static final Logger log = LoggerFactory.getLogger(InsApiV2DeviceController.class);
    @Autowired
    private InsDeviceService insDeviceService;

    @ResponseBody
    @ApiOperation(value="Get Ins Devices", notes="Return Ins Devices List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getDeviceList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="Page Index", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="One Page Size", required=true, dataType="int", paramType="query")})
    public ApiResultMessage getDeviceList(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        ApiResultMessage rs = new ApiResultMessage();
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        Pager pager = this.insDeviceService.getItemsByPage((BaseItem)new InsDeviceItem(), pageNo - 1, pageSize.intValue());
        ArrayList<InsApiDeviceItem> insApiDeviceItemList = new ArrayList<InsApiDeviceItem>();
        List insDeviceItemList = pager.getData();
        if (!insDeviceItemList.isEmpty()) {
            for (InsDeviceItem insDeviceItem : insDeviceItemList) {
                InsApiDeviceItem insApiDeviceItem = InsApiDeviceItem.createApiDevice((InsDeviceItem)insDeviceItem);
                if (insApiDeviceItem == null) continue;
                insApiDeviceItemList.add(insApiDeviceItem);
            }
        }
        pager.setData(insApiDeviceItemList);
        rs.setData((Object)pager);
        return rs;
    }
}

