/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.service.InsApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/insAreaPerson"})
@Api(tags={"InsAreaPerson"}, description="ins area person")
public class InsApiV2AreaPersonController {
    private static final Logger log = LoggerFactory.getLogger(InsApiV2AreaPersonController.class);
    @Autowired
    private InsApiService insApiService;

    @ApiOperation(value="Get Area List", notes="Return Area List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getAreaList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getAreaList(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        return this.insApiService.getAreaPage(pageNo, pageSize);
    }
}

