/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.api.vo.InsApiPersonItem;
import com.zkteco.zkbiosecurity.ins.service.InsApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/insPerson"})
@Api(tags={"InsPerson"}, description="ins person")
public class InsApiPersonController {
    private static final Logger log = LoggerFactory.getLogger(InsApiPersonController.class);
    @Autowired
    private InsApiService insApiService;

    @ResponseBody
    @RequestMapping(value={"/editInsPerson"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Edit InsPerson", notes="Edit InsPerson", response=ApiResultMessage.class)
    public ApiResultMessage editInsPerson(@RequestBody InsApiPersonItem insApiPersonItem) {
        if (StringUtils.isBlank((CharSequence)insApiPersonItem.getPersonPin())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"ins_api_notNull", (Object[])new Object[]{"personPin"}));
        }
        if (StringUtils.isBlank((CharSequence)insApiPersonItem.getCategory())) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"ins_api_notNull", (Object[])new Object[]{"category"}));
        }
        if (insApiPersonItem.getPerDevAuth() == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"ins_api_notNull", (Object[])new Object[]{"perDevAuth"}));
        }
        return this.insApiService.editInsPerson(insApiPersonItem);
    }
}

