/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sms.modem.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=325)
public class SmsModemInit
implements CommandLineRunner {
    @Autowired(required=false)
    private AuthPermissionService authPermissionService;
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("SmsModemInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initSmsModemParams();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("SmsModemInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem subMenuItem1;
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("System");
        if (systemItem == null) {
            systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        if ((subMenuItem1 = this.authPermissionService.getItemByCode("ThirdPartyDocking")) == null) {
            subMenuItem1 = new AuthPermissionItem("ThirdPartyDocking", "base_leftMenu_thirdParty", "third:party:docking", "menu", "true", Integer.valueOf(4));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_extendManage.png");
            subMenuItem1.setImgHover("base_extendManage_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        }
        AuthPermissionItem subMenuItem = new AuthPermissionItem("SmsModemMessage", "smsModem_message_management", "smsModem:message", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("smsModemMessage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("SmsModemMessageRefresh", "common_op_refresh", "smsModem:message:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("SmsModemMessageDel", "common_op_del", "smsModem:message:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("SmsModemMessageParamSetting", "smsModem_message_paramSetting", "smsModem:message:paramSetting", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    private void initSmsModemParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.port", "", "\u7aef\u53e3"));
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.phoneNumber", "", "\u624b\u673a\u53f7\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.smsc", "", "\u77ed\u4fe1\u670d\u52a1\u4e2d\u5fc3\u53f7\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.smsType", "0", "\u77ed\u4fe1\u670d\u52a1\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.smsAccessKey", "", "SMS ACCESS_KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.smsSecretKey", "", "SMS SECRET_KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("smsModem.smsEnable", "", "SMS Enable"));
        this.baseSysParamService.initData(new BaseSysParamItem("gsmgprsmodem.version", "true", "\u77ed\u4fe1\u732b\u8bb8\u53ef", Boolean.valueOf(true)));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"sms-modem");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("SmsModemUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("SmsModemUpgradeVersion", curVersion, "sms-modem Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

