/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="IAS_POINT t LEFT JOIN IAS_DEVICE d ON d.ID = t.DEVICE_ID LEFT JOIN IAS_PARTITION_POINT pp ON pp.POINT_ID = t.ID LEFT JOIN IAS_PARTITION iap ON iap.ID = pp.PARTITION_ID")
@OrderBy(after="t.DEVICE_ID, t.CODE ASC")
@GridConfig(operate=true, idField="id", winHeight=230, winWidth=450, minWidth="140", operates={@GridOperate(type="edit", permission="ias:point:edit", url="/iasPoint.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="ias:point:bypass", url="/iasPoint.do?bypass", click="iasOperate", label="ias_point_bypass"), @GridOperate(type="custom", permission="ias:point:unBypass", url="/iasPoint.do?unBypass", click="iasOperate", label="ias_point_unbypass")})
public class IasPointItem
extends BaseItem
implements Serializable {
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0, sort="na")
    private String id;
    @Column(name="t.CODE")
    @GridColumn(label="ias_point_code", width="100")
    private Integer code;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="ias_point_name", width="140", editPermission="ias:point:edit", editUrl="/iasPoint.do?edit")
    private String name;
    @GridColumn(label="ias_point_ownedPartitionName", width="200")
    private String partitionNames;
    private String partitionCodes;
    @Column(name="d.ID")
    private String deviceId;
    @Column(name="d.IP")
    private String deviceIp;
    @Column(name="d.NAME")
    @GridColumn(label="common_dev_name", width="140")
    private String deviceName;
    @Column(name="d.MANUFACTURER")
    private String manufacturer;
    @Column(name="t.ARM_TYPE")
    private Short armType;
    private String status;
    @GridColumn(label="ias_point_bypassStatus", width="100", convert="convertToBypassStatus", columnType="custom", sort="na")
    private String bypassStatus;
    private String alarmStatus;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="160")
    private String remark;
    @Condition(value="d.ID IN (%s)", formatType="quote")
    private String devIdIn;
    @Condition(value="pp.PARTITION_ID IN (%s)", formatType="quote")
    private String partitionIdIn;
    @Column(name="iap.AREA_ID")
    private String areaId;
    private String areaName;
    @Condition(value="iap.AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public IasPointItem() {
    }

    public IasPointItem(Boolean equals) {
        super(equals);
    }

    public IasPointItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getPartitionNames() {
        return this.partitionNames;
    }

    public String getPartitionCodes() {
        return this.partitionCodes;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public Short getArmType() {
        return this.armType;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBypassStatus() {
        return this.bypassStatus;
    }

    public String getAlarmStatus() {
        return this.alarmStatus;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getDevIdIn() {
        return this.devIdIn;
    }

    public String getPartitionIdIn() {
        return this.partitionIdIn;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getUserId() {
        return this.userId;
    }

    public IasPointItem setId(String id) {
        this.id = id;
        return this;
    }

    public IasPointItem setCode(Integer code) {
        this.code = code;
        return this;
    }

    public IasPointItem setName(String name) {
        this.name = name;
        return this;
    }

    public IasPointItem setPartitionNames(String partitionNames) {
        this.partitionNames = partitionNames;
        return this;
    }

    public IasPointItem setPartitionCodes(String partitionCodes) {
        this.partitionCodes = partitionCodes;
        return this;
    }

    public IasPointItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public IasPointItem setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    public IasPointItem setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public IasPointItem setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    public IasPointItem setArmType(Short armType) {
        this.armType = armType;
        return this;
    }

    public IasPointItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IasPointItem setBypassStatus(String bypassStatus) {
        this.bypassStatus = bypassStatus;
        return this;
    }

    public IasPointItem setAlarmStatus(String alarmStatus) {
        this.alarmStatus = alarmStatus;
        return this;
    }

    public IasPointItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public IasPointItem setDevIdIn(String devIdIn) {
        this.devIdIn = devIdIn;
        return this;
    }

    public IasPointItem setPartitionIdIn(String partitionIdIn) {
        this.partitionIdIn = partitionIdIn;
        return this;
    }

    public IasPointItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public IasPointItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public IasPointItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

