/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="IAS_PARTITION t LEFT JOIN IAS_DEVICE d ON d.ID = t.DEVICE_ID LEFT JOIN AUTH_AREA area ON t.AREA_ID = area.id")
@OrderBy(after="t.DEVICE_ID, t.CODE ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=450, minWidth="140", operates={@GridOperate(type="edit", permission="ias:partition:edit", url="/iasPartition.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="ias:partition:arm", click="iasPartitionArm", url="/iasPartition.do?arm", label="ias_partitionArm"), @GridOperate(type="custom", permission="ias:partition:disarm", url="/iasPartition.do?disarm", click="iasUserVerifyOperateItem", label="ias_partition_disarm"), @GridOperate(type="custom", permission="ias:partition:silenceBells", url="/iasPartition.do?silenceBells", showConvertor="showOperateByManufacturer", click="iasOperate", label="ias_partition_silenceBells")})
public class IasPartitionItem
extends BaseItem
implements Serializable {
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0, sort="na")
    private String id;
    @Column(name="t.CODE")
    @GridColumn(label="ias_partition_code", width="100")
    private Integer code;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="ias_partition_name", width="140", editPermission="ias:partition:edit", editUrl="/iasPartition.do?edit")
    private String name;
    @Column(name="t.DEVICE_ID")
    private String deviceId;
    @Column(name="d.IP")
    private String deviceIp;
    @Column(name="d.NAME")
    @GridColumn(label="common_dev_name", width="140")
    private String deviceName;
    @Column(name="d.MANUFACTURER")
    @GridColumn(label="ias_device_manufacturer")
    private String manufacturer;
    @GridColumn(label="ias_partition_armStatus", width="180", sort="na")
    private String status;
    private String alarmStatus;
    @Column(name="t.AREA_ID")
    private String areaId;
    @Column(name="area.NAME")
    @GridColumn(label="base_area_name", width="120", sort="na")
    private String areaName;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="160")
    private String remark;
    @Condition(value="t.DEVICE_ID IN (%s)", formatType="quote")
    private String deviceIdIn;
    @Condition(value="t.ID", equalTag="not in")
    private String idNotIn;
    @Condition(value="t.ID", equalTag="in")
    private String idIn;
    @Condition(value="t.AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public IasPartitionItem() {
    }

    public IasPartitionItem(Boolean equals) {
        super(equals);
    }

    public IasPartitionItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public boolean showOperateByManufacturer() {
        String manufacturer = this.manufacturer;
        if (manufacturer != null && !"".equals(manufacturer)) {
            return "BOSCH".equals(manufacturer);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getStatus() {
        return this.status;
    }

    public String getAlarmStatus() {
        return this.alarmStatus;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getDeviceIdIn() {
        return this.deviceIdIn;
    }

    public String getIdNotIn() {
        return this.idNotIn;
    }

    public String getIdIn() {
        return this.idIn;
    }

    public String getUserId() {
        return this.userId;
    }

    public IasPartitionItem setId(String id) {
        this.id = id;
        return this;
    }

    public IasPartitionItem setCode(Integer code) {
        this.code = code;
        return this;
    }

    public IasPartitionItem setName(String name) {
        this.name = name;
        return this;
    }

    public IasPartitionItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public IasPartitionItem setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    public IasPartitionItem setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public IasPartitionItem setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    public IasPartitionItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IasPartitionItem setAlarmStatus(String alarmStatus) {
        this.alarmStatus = alarmStatus;
        return this;
    }

    public IasPartitionItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public IasPartitionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public IasPartitionItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public IasPartitionItem setDeviceIdIn(String deviceIdIn) {
        this.deviceIdIn = deviceIdIn;
        return this;
    }

    public IasPartitionItem setIdNotIn(String idNotIn) {
        this.idNotIn = idNotIn;
        return this;
    }

    public IasPartitionItem setIdIn(String idIn) {
        this.idIn = idIn;
        return this;
    }

    public IasPartitionItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

