/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.EncrypAESUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=310)
public class IVideoInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("IVideoInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initIVideoParams();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("IVideoInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem subMenuItem1;
        Object topMenuItem = null;
        AuthPermissionItem subMenuItem = null;
        AuthPermissionItem subButtonItem = null;
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("System");
        if (systemItem == null) {
            systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        if ((subMenuItem1 = this.authPermissionService.getItemByCode("ThirdPartyDocking")) == null) {
            subMenuItem1 = new AuthPermissionItem("ThirdPartyDocking", "base_leftMenu_thirdParty", "third:party:docking", "menu", "true", Integer.valueOf(4));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_extendManage.png");
            subMenuItem1.setImgHover("base_extendManage_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        }
        subMenuItem = new AuthPermissionItem("IVideoConnector", "docking_leftMenu_connector", "iVideo:connector", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("iVideoConnector.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorRefresh", "common_op_refresh", "iVideo:connector:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorAdd", "common_op_new", "iVideo:connector:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorEdit", "common_op_edit", "iVideo:connector:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorDel", "common_op_del", "iVideo:connector:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorAddDoor", "docking_connector_addDoor", "iVideo:connector:addDoor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorAddAuxIn", "docking_connector_addAuxIn", "iVideo:connector:addAuxIn", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoConnectorAddAuxOut", "docking_connector_addAuxOut", "iVideo:connector:addAuxOut", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityRefresh", "common_op_refresh", "iVideo:controlEntity:refresh", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityEdit", "docking_controlEntity_edit", "iVideo:controlEntity:edit", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityDel", "docking_controlEntity_delete", "iVideo:controlEntity:del", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityBindChannel", "docking_channel_bindOrUnbindChannel", "iVideo:controlEntity:bindChannel", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoParamRefresh", "common_op_refresh", "iVideo:param:refresh", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoParamEdit", "common_op_edit", "iVideo:param:edit", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IVideoChannel", "docking_leftMenu_vidChannel", "iVideo:channel", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("iVideoChannel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IVideoChannelRefresh", "common_op_refresh", "iVideo:channel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoChannelAdd", "common_op_new", "iVideo:channel:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoChannelEdit", "common_op_edit", "iVideo:channel:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoChannelDel", "common_op_del", "iVideo:channel:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IVideoDigifortCamera", "docking_leftMenu_digifortCamera", "iVideo:digifortCamera", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("iVideoDigifortCamera.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraRefresh", "common_op_refresh", "iVideo:digifortCamera:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraAdd", "common_op_new", "iVideo:digifortCamera:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraEdit", "common_op_edit", "iVideo:digifortCamera:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraDel", "common_op_del", "iVideo:digifortCamera:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraAddDoor", "docking_connector_addDoor", "iVideo:digifortCamera:addDoor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraAddAuxIn", "docking_connector_addAuxIn", "iVideo:digifortCamera:addAuxIn", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortCameraAddAuxOut", "docking_connector_addAuxOut", "iVideo:digifortCamera:addAuxOut", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityRefresh", "common_op_refresh", "iVideo:controlEntity:refresh", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityEdit", "docking_controlEntity_edit", "iVideo:controlEntity:edit", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityDel", "docking_controlEntity_delete", "iVideo:controlEntity:del", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoControlEntityBindChannel", "docking_channel_bindOrUnbindChannel", "iVideo:controlEntity:bindChannel", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortLiveView", "docking_digifort_liveView", "iVideo:digifort:liveView", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoDigifortBookmarkSet", "docking_digifort_bookmarkSet", "iVideo:digifort:bookmarkSet", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoParamRefresh", "common_op_refresh", "iVideo:param:refresh", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IVideoParamEdit", "common_op_edit", "iVideo:param:edit", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
    }

    private void initIVideoParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.serverIP", "", "\u670d\u52a1\u5668IP"));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.serverPort", "80", "\u670d\u52a1\u5668\u7aef\u53e3"));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.serverUsername", "", "\u7528\u6237\u540d"));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.serverPassword", "", "\u5bc6\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.bioSecurityDomain", "", "\u767e\u50b2\u745e\u8fbe\u57df\u540d"));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.sendEventInterval", "1000", "\u53d1\u9001\u4e8b\u4ef6\u65f6\u95f4\u95f4\u9694"));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.isParamsChanged", "false", "\u5224\u65ad\u53c2\u6570\u662f\u5426\u6539\u53d8\u4e86"));
        String uuid = String.valueOf(System.currentTimeMillis());
        String token = EncrypAESUtil.encrytToString((String)("Arteco_" + uuid));
        this.baseSysParamService.initData(new BaseSysParamItem("ivideo.accessToken", token, "\u8bbf\u95ee\u6743\u9650\u63a7\u5236\u53c2\u6570token"));
        BaseSysParamItem artecoItem = new BaseSysParamItem("arteco.version", "true", "arteco version", Boolean.valueOf(true));
        this.baseSysParamService.initData(artecoItem);
        BaseSysParamItem c2pItem = new BaseSysParamItem("c2p.version", "true", "c2p version", Boolean.valueOf(true));
        this.baseSysParamService.initData(c2pItem);
        this.baseSysParamService.initData(new BaseSysParamItem("digifort.version", "true", "digifort license", Boolean.valueOf(true)));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"vid-integrated");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("IVideoUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("IVideoUpgradeVersion", curVersion, "Vid-integrated Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

