/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.sql.Timestamp;
import java.util.Date;

@From(after="VDB_UNLOCK_RECORDS t ")
@OrderBy(after="t.EVENT_TIME DESC")
@GridConfig
public class VdbUnlockRecordsItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", sortNo=0, show=false)
    private String id;
    @Column(name="t.DEVICE_ID")
    private String deviceId;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="common_time", width="150")
    private Timestamp eventTime;
    @Column(name="t.DEVICE_NAME")
    @GridColumn(label="adms_device_deviceName", width="150")
    private String deviceName;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="base_area_name", width="150")
    private String areaName;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="110", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="110", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="110", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="t.UNLOCK_TYPE")
    @GridColumn(label="vdb_unlockRecords_type", format="0=pers_card_cardNo,1=common_newVerify_mode_pw,2=vdb_unlockRecordsType_call,3=vdb_unlockRecordsType_exitButton,4=common_newVerify_mode_face", width="100")
    private String unlockType;
    @Column(name="t.NUMBER")
    @GridColumn(label="vdb_unlockRecords_credential", width="100", sort="na")
    private String number;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", columnType="custom", convert="convertVdbUnlockRecordsStatus", width="80")
    private String status;
    @Column(name="t.CAPTURE_PHOTO_PATH")
    private String capturePhotoPath;
    private String group;
    @Column(name="t.USER_TYPE")
    private String userType;
    private String relay;
    @Column(name="t.MAC")
    private String mac;
    @Condition(value="t.EVENT_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.EVENT_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.AREA_NAME IN (select aa.name from auth_area aa where aa.id in(select aua.auth_area_id from auth_user_area aua where aua.auth_user_id = ''{0}''))")
    private String areaNameByUserId;

    public VdbUnlockRecordsItem() {
    }

    public VdbUnlockRecordsItem(String name, String group, String userType, String unlockType, String number, String status, String relay, Timestamp eventTime) {
        this.name = name;
        this.group = group;
        this.userType = userType;
        this.unlockType = unlockType;
        this.number = number;
        this.status = status;
        this.relay = relay;
        this.eventTime = eventTime;
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public Timestamp getEventTime() {
        return this.eventTime;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getUnlockType() {
        return this.unlockType;
    }

    public String getNumber() {
        return this.number;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCapturePhotoPath() {
        return this.capturePhotoPath;
    }

    public String getGroup() {
        return this.group;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getRelay() {
        return this.relay;
    }

    public String getMac() {
        return this.mac;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getAreaNameByUserId() {
        return this.areaNameByUserId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setEventTime(Timestamp eventTime) {
        this.eventTime = eventTime;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setUnlockType(String unlockType) {
        this.unlockType = unlockType;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCapturePhotoPath(String capturePhotoPath) {
        this.capturePhotoPath = capturePhotoPath;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public void setRelay(String relay) {
        this.relay = relay;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setAreaNameByUserId(String areaNameByUserId) {
        this.areaNameByUserId = areaNameByUserId;
    }
}

