/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="VDB_UNIT t LEFT JOIN VDB_BUILDING b on t.BUILDING_ID = b.ID LEFT JOIN AUTH_AREA a on b.auth_area_id = a.id ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=200, winWidth=420, operates={@GridOperate(type="edit", permission="vdb:unit:edit", url="vdbUnit.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="vdb:unit:del", url="vdbUnit.do?del", label="common_op_del")})
public class VdbUnitItem
extends BaseItem
implements Serializable {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="vdb_unit_name", width="120", sortNo=1, editPermission="vdb:unit:edit", editUrl="vdbUnit.do?edit")
    private String name;
    @Column(name="t.UNIT_NO")
    @GridColumn(label="vdb_unit_number", width="100")
    private String unitNo;
    @Column(name="b.NAME")
    @GridColumn(label="vdb_building_name", width="120")
    private String buildingName;
    @Column(name="b.BUILDING_NO")
    @GridColumn(label="vdb_building_number", width="100")
    private String buildingNo;
    @Column(name="t.INIT_FLAG")
    private Boolean initFlag;
    @Condition(value="b.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.BUILDING_ID")
    private String vdbBuildingId;
    @Column(name="t.ID", equalTag="<>")
    private String idNotEq;

    public VdbUnitItem() {
    }

    public VdbUnitItem(Boolean equals) {
        super(equals);
    }

    public VdbUnitItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public VdbUnitItem(String name, String unitNo, Boolean initFlag, String vdbBuildingId) {
        this.name = name;
        this.unitNo = unitNo;
        this.initFlag = initFlag;
        this.vdbBuildingId = vdbBuildingId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUnitNo() {
        return this.unitNo;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getBuildingNo() {
        return this.buildingNo;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVdbBuildingId() {
        return this.vdbBuildingId;
    }

    public String getIdNotEq() {
        return this.idNotEq;
    }

    public VdbUnitItem setId(String id) {
        this.id = id;
        return this;
    }

    public VdbUnitItem setName(String name) {
        this.name = name;
        return this;
    }

    public VdbUnitItem setUnitNo(String unitNo) {
        this.unitNo = unitNo;
        return this;
    }

    public VdbUnitItem setBuildingName(String buildingName) {
        this.buildingName = buildingName;
        return this;
    }

    public VdbUnitItem setBuildingNo(String buildingNo) {
        this.buildingNo = buildingNo;
        return this;
    }

    public VdbUnitItem setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
        return this;
    }

    public VdbUnitItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VdbUnitItem setVdbBuildingId(String vdbBuildingId) {
        this.vdbBuildingId = vdbBuildingId;
        return this;
    }

    public VdbUnitItem setIdNotEq(String idNotEq) {
        this.idNotEq = idNotEq;
        return this;
    }

    public String toString() {
        return "VdbUnitItem(id=" + this.getId() + ", name=" + this.getName() + ", unitNo=" + this.getUnitNo() + ", buildingName=" + this.getBuildingName() + ", buildingNo=" + this.getBuildingNo() + ", initFlag=" + this.getInitFlag() + ", userId=" + this.getUserId() + ", vdbBuildingId=" + this.getVdbBuildingId() + ", idNotEq=" + this.getIdNotEq() + ")";
    }
}

