/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT JOIN PERS_CARD pc ON t.ID = pc.PERSON_ID LEFT JOIN AUTH_DEPARTMENT d ON t.auth_dept_id = d.id ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class VdbSelectPersonItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    private String personId;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="90")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="90")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="90")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, sort="na", width="65", show=false)
    private String cardNo;
    private String type;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    private String linkId;
    private String modelType;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.ID NOT IN (SELECT alp.PERS_PERSON_ID FROM VDB_LEVEL_PERSON alp WHERE alp.LEVEL_ID=''{0}'')")
    private String levelId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getType() {
        return this.type;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public VdbSelectPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public VdbSelectPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public VdbSelectPersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public VdbSelectPersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public VdbSelectPersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public VdbSelectPersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public VdbSelectPersonItem setType(String type) {
        this.type = type;
        return this;
    }

    public VdbSelectPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VdbSelectPersonItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public VdbSelectPersonItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public VdbSelectPersonItem setModelType(String modelType) {
        this.modelType = modelType;
        return this;
    }

    public VdbSelectPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VdbSelectPersonItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public VdbSelectPersonItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }
}

