/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT join PERS_CARD pc on t.ID = pc.PERSON_ID LEFT JOIN VDB_PERSON vp on vp.pers_person_id= t.id  left join VDB_BUILDING vb on vb.id= vp.BUILDING_ID left join VDB_UNIT vu on vu.id= vp.UNIT_ID ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="select", permission="vdb:personLevelByPerson:addLevel", url="skip.do?page=vdb_personLevelByPerson_personSelectLevelContent&personId=(id)&personPin=(persPin)", label="common_level_addPersonLevel", click="afterAddPersonLevel")})
public class VdbPersonLevelByPersonItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="90", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String persPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="80", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="80", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="95", sort="na", show=false, encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNos;
    @Condition(value="(LOWER (pc.CARD_NO) LIKE LOWER (''%{0}%''))", encryptConverter=true)
    private String likeCardNo;
    private String deptName;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;
    @Column(name="vb.NAME")
    @GridColumn(label="vdb_building_name", sortNo=5, width="80", sort="na")
    private String buildingName;
    @Column(name="vu.NAME")
    @GridColumn(label="vdb_unit_name", sortNo=5, width="80", sort="na")
    private String unitName;
    @Column(name="vp.ROOM_NO")
    @GridColumn(label="vdb_device_roomNo", sortNo=5, width="80", sort="na")
    private String roomNo;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.auth_dept_id IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public VdbPersonLevelByPersonItem() {
    }

    public VdbPersonLevelByPersonItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNos() {
        return this.cardNos;
    }

    public String getLikeCardNo() {
        return this.likeCardNo;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getRoomNo() {
        return this.roomNo;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPersPin(String persPin) {
        this.persPin = persPin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setCardNos(String cardNos) {
        this.cardNos = cardNos;
    }

    public void setLikeCardNo(String likeCardNo) {
        this.likeCardNo = likeCardNo;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setRoomNo(String roomNo) {
        this.roomNo = roomNo;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

