/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="VDB_LEVEL_PERSON t LEFT JOIN VDB_LEVEL l ON t.LEVEL_ID=l.ID Left join PERS_PERSON p on p.id = t.PERS_PERSON_ID LEFT JOIN VDB_PERSON vp on vp.PERS_PERSON_ID = p.id left join VDB_BUILDING vb on vb.id= vp.BUILDING_ID left join VDB_UNIT vu on vu.id= vp.UNIT_ID ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class VdbLevelPersonItem
extends BaseItem {
    @Column(name="p.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="p.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="100", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @GridColumn(label="pers_dept_entity", sortNo=5, width="150", sort="na", show=false)
    private String deptName;
    @Column(name="vb.NAME")
    @GridColumn(label="vdb_building_name", sortNo=5, width="150", sort="na")
    private String buildingName;
    @Column(name="vu.NAME")
    @GridColumn(label="vdb_unit_name", sortNo=5, width="150", sort="na")
    private String unitName;
    @Column(name="vp.ROOM_NO")
    @GridColumn(label="vdb_device_roomNo", sortNo=5, width="150", sort="na")
    private String roomNo;
    @Column(name="t.LEVEL_ID", equalTag="=")
    private String linkId;
    @Condition(value="(LOWER (p.NAME) LIKE LOWER (''%{0}%'') OR LOWER (p.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Column(name="t.LEVEL_ID")
    private String levelId;
    @Condition(value="p.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getRoomNo() {
        return this.roomNo;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getUserId() {
        return this.userId;
    }

    public VdbLevelPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public VdbLevelPersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public VdbLevelPersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public VdbLevelPersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public VdbLevelPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public VdbLevelPersonItem setBuildingName(String buildingName) {
        this.buildingName = buildingName;
        return this;
    }

    public VdbLevelPersonItem setUnitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    public VdbLevelPersonItem setRoomNo(String roomNo) {
        this.roomNo = roomNo;
        return this;
    }

    public VdbLevelPersonItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public VdbLevelPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VdbLevelPersonItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public VdbLevelPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

