/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="VDB_DEVICE t LEFT JOIN VDB_LEVEL_DEVICE ld ON ld.DEVICE_ID=t.ID LEFT JOIN AUTH_AREA a on t.auth_area_id = a.id LEFT JOIN VDB_BUILDING b on t.BUILDING_ID = b.id LEFT JOIN VDB_UNIT u on t.UNIT_ID = u.id ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class VdbLevelDeviceItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.DEVICE_NO")
    private String deviceNo;
    @Column(name="t.NAME")
    @GridColumn(label="common_dev_name", width="120")
    private String name;
    @GridColumn(label="common_dev_devType", width="100", format="0=vdb_device_doorStation,1=vdb_device_outerStation,2=vdb_device_doorbellStation,3=vdb_device_indoorStation")
    @Column(name="t.DEVICE_TYPE")
    private String deviceType;
    @Column(name="a.NAME")
    @GridColumn(label="base_area_name", width="90")
    private String authAreaName;
    @Column(name="b.NAME")
    @GridColumn(label="vdb_building_name", width="100")
    private String buildingName;
    @Column(name="u.NAME")
    @GridColumn(label="vdb_unit_name", width="100")
    private String unitName;
    @Column(name="ld.LEVEL_ID", equalTag="=")
    private String vdbLevelId;
    @Column(name="ld.DEVICE_ID")
    private String vdbDeviceId;
    @Condition(value="t.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.DEVICE_TYPE", equalTag="=")
    private String deviceTypeEq;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;

    public String getId() {
        return this.id;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public String getName() {
        return this.name;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getVdbLevelId() {
        return this.vdbLevelId;
    }

    public String getVdbDeviceId() {
        return this.vdbDeviceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeviceTypeEq() {
        return this.deviceTypeEq;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public VdbLevelDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public VdbLevelDeviceItem setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    public VdbLevelDeviceItem setName(String name) {
        this.name = name;
        return this;
    }

    public VdbLevelDeviceItem setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public VdbLevelDeviceItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public VdbLevelDeviceItem setBuildingName(String buildingName) {
        this.buildingName = buildingName;
        return this;
    }

    public VdbLevelDeviceItem setUnitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    public VdbLevelDeviceItem setVdbLevelId(String vdbLevelId) {
        this.vdbLevelId = vdbLevelId;
        return this;
    }

    public VdbLevelDeviceItem setVdbDeviceId(String vdbDeviceId) {
        this.vdbDeviceId = vdbDeviceId;
        return this;
    }

    public VdbLevelDeviceItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VdbLevelDeviceItem setDeviceTypeEq(String deviceTypeEq) {
        this.deviceTypeEq = deviceTypeEq;
        return this;
    }

    public VdbLevelDeviceItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }
}

