/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.sql.Timestamp;
import java.util.Date;

@From(after="VDB_CALL_RECORDS t ")
@OrderBy(after="t.EVENT_TIME DESC")
@GridConfig
public class VdbCallRecordsItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", sortNo=0, show=false)
    private String id;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="common_time", width="150")
    private Timestamp eventTime;
    @Column(name="t.DEVICE_NAME")
    @GridColumn(label="adms_device_deviceName", width="150")
    private String deviceName;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="base_area_name", width="150")
    private String areaName;
    @Column(name="t.NUMBER")
    @GridColumn(label="vdb_records_number", width="150")
    private String number;
    @Column(name="t.EVENT_TYPE")
    @GridColumn(label="common_leftMenu_event", format="0=vdb_records_received,1=vdb_records_call,2=vdb_records_missingCall", width="150")
    private String eventType;
    @Column(name="t.DURATION")
    @GridColumn(label="vdb_records_duration", width="30")
    private String duration;
    @Column(name="t.MAC")
    private String mac;
    @Condition(value="t.EVENT_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.EVENT_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.AREA_NAME IN (select aa.name from auth_area aa where aa.id in(select aua.auth_area_id from auth_user_area aua where aua.auth_user_id = ''{0}''))")
    private String areaNameByUserId;

    public VdbCallRecordsItem() {
    }

    public VdbCallRecordsItem(String eventType, String deviceName, String number, String duration, Timestamp eventTime) {
        this.eventTime = eventTime;
        this.deviceName = deviceName;
        this.number = number;
        this.eventType = eventType;
        this.duration = duration;
    }

    public String getId() {
        return this.id;
    }

    public Timestamp getEventTime() {
        return this.eventTime;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getNumber() {
        return this.number;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getMac() {
        return this.mac;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getAreaNameByUserId() {
        return this.areaNameByUserId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEventTime(Timestamp eventTime) {
        this.eventTime = eventTime;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setAreaNameByUserId(String areaNameByUserId) {
        this.areaNameByUserId = areaNameByUserId;
    }
}

