/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="VDB_BUILDING t LEFT JOIN AUTH_AREA a on t.auth_area_id = a.id ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=200, winWidth=420, operates={@GridOperate(type="edit", permission="vdb:building:edit", url="vdbBuilding.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="vdb:building:del", url="vdbBuilding.do?del", label="common_op_del")})
public class VdbBuildingItem
extends BaseItem
implements Serializable {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="vdb_building_name", width="120", sortNo=1, editPermission="vdb:building:edit", editUrl="vdbBuilding.do?edit")
    private String name;
    @Column(name="t.BUILDING_NO")
    @GridColumn(label="vdb_building_number", width="100")
    private String buildingNo;
    @Column(name="a.NAME")
    @GridColumn(label="base_area_name", width="90")
    private String authAreaName;
    @Column(name="t.AUTH_AREA_ID", equalTag="in")
    private String authAreaId;
    @Condition(value="t.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.ID", equalTag="<>")
    private String idNotEq;
    @Column(name="t.INIT_FLAG")
    private Boolean initFlag;

    public VdbBuildingItem() {
    }

    public VdbBuildingItem(Boolean equals) {
        super(equals);
    }

    public VdbBuildingItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public VdbBuildingItem(String name, String buildingNo, String authAreaId, Boolean initFlag) {
        this.name = name;
        this.buildingNo = buildingNo;
        this.authAreaId = authAreaId;
        this.initFlag = initFlag;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getBuildingNo() {
        return this.buildingNo;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getIdNotEq() {
        return this.idNotEq;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public VdbBuildingItem setId(String id) {
        this.id = id;
        return this;
    }

    public VdbBuildingItem setName(String name) {
        this.name = name;
        return this;
    }

    public VdbBuildingItem setBuildingNo(String buildingNo) {
        this.buildingNo = buildingNo;
        return this;
    }

    public VdbBuildingItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public VdbBuildingItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public VdbBuildingItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VdbBuildingItem setIdNotEq(String idNotEq) {
        this.idNotEq = idNotEq;
        return this;
    }

    public VdbBuildingItem setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
        return this;
    }

    public String toString() {
        return "VdbBuildingItem(id=" + this.getId() + ", name=" + this.getName() + ", buildingNo=" + this.getBuildingNo() + ", authAreaName=" + this.getAuthAreaName() + ", authAreaId=" + this.getAuthAreaId() + ", userId=" + this.getUserId() + ", idNotEq=" + this.getIdNotEq() + ", initFlag=" + this.getInitFlag() + ")";
    }
}

