/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.service.AttPointService;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveTypeItem;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.jdbc.JdbcOperateTemplate;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryItem;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=40)
public class AttInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AttInit.class);
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;
    @Autowired
    private JdbcOperateTemplate jdbcOperateTemplate;
    @Autowired
    private AttParamService attParamService;
    @Autowired
    private AttPointService attPointService;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.language:zh_CN}")
    private String language;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("AttProInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initAttParams();
            this.initAttLeaveType();
            this.initAttDictionary();
            if (!this.baseSysParamService.getAlreadyInitModule("AttInit")) {
                this.initUpgradeVersion();
            }
            this.baseSysParamService.setAlreadyInitModule("AttProInit");
        }
        this.initAttData();
    }

    private void initAttData() {
        try {
            this.attPointService.initAttPointTransaction();
        }
        catch (Exception e) {
            log.error("ATT initAttData Exception", (Throwable)e);
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemMenuItem = null;
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        systemMenuItem = new AuthPermissionItem("Att", "att_module", "att", "system", "true", Integer.valueOf(4));
        systemMenuItem = this.authPermissionService.saveItem(systemMenuItem);
        parentMenuItem = new AuthPermissionItem("AttAttendanceDevice", "att_leftMenu_attendanceDevice", "att:attendance:device", "menu", "true", Integer.valueOf(1));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attDevice.do");
        parentMenuItem.setImg("att_device.png");
        parentMenuItem.setImgHover("att_device_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttAreaPerson", "att_areaPerson_byAreaPerson", "att:areaPerson", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAreaPerson.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonRefresh", "common_op_refresh", "att:areaPerson:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonDel", "common_op_del", "att:areaPerson:del", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonAddPerson", "att_op_forZoneAddPers", "att:areaPerson:addPerson", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonSetUserSms", "att_op_dataUserSms", "att:areaPerson:setUserSms", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonSyncDev", "att_op_syncPers", "att:areaPerson:syncPerToDev", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonImportBatchDel", "att_areaPerson_importBatchDel", "att:areaPerson:importBatchDel", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonImport", "att_areaPerson_importAreaPerson", "att:areaPerson:import", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonExport", "common_op_export", "att:areaPerson:export", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDevice", "att_leftMenu_device", "att:device", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDevice.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceRefresh", "common_op_refresh", "att:device:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceEdit", "common_op_edit", "att:device:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSearch", "common_dev_searchDev", "att:device:search", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceDel", "common_op_del", "att:device:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceEnable", "common_enable", "att:device:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceDisable", "common_disable", "att:device:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSyncDev", "att_op_syncDev", "att:device:syncdev", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSetTime", "att_op_account", "att:device:settime", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceFillPin", "att_device_getPin", "att:device:fillpin", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSetStamp", "att_op_check", "att:device:setstamp", "button", "true", Integer.valueOf(10));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceDeleteCmd", "att_op_deleteCmd", "att:device:deletecmd", "button", "true", Integer.valueOf(11));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSetSms", "att_op_dataSms", "att:device:setsms", "button", "true", Integer.valueOf(12));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceClearAttPic", "att_op_clearAttPic", "att:device:clearattpic", "button", "true", Integer.valueOf(13));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceClearAttLog", "att_op_clearAttLog", "att:device:clearattlog", "button", "true", Integer.valueOf(14));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceReboot", "common_dev_reboot", "att:device:reboot", "button", "true", Integer.valueOf(15));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceGetDevOpt", "common_dev_getDevOpt", "att:device:getdevopt", "button", "true", Integer.valueOf(16));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceClearAttPers", "att_op_clearAttPers", "att:device:clearattpers", "button", "true", Integer.valueOf(17));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceQueryOption", "att_deviceOption_query", "att:device:queryOption", "button", "true", Integer.valueOf(18));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceAuthArea", "auth_user_authorizedAreas", "att:device:authArea", "button", "true", Integer.valueOf(19));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceExport", "common_op_export", "att:device:export", "button", "true", Integer.valueOf(20));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttUpgradeFirmware", "common_dev_upgradeFirmware", "att:device:upgradeFirmware", "button", "true", Integer.valueOf(21));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttPoint", "att_leftMenu_point", "att:point", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attPoint.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointRefresh", "common_op_refresh", "att:point:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointAdd", "common_op_new", "att:point:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointExport", "common_op_export", "att:point:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointDel", "common_op_del", "att:point:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointEdit", "common_op_edit", "att:point:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttRealTimeCallRoll", "att_leftMenu_realTime_callRoll", "att:realTime:callRoll", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attRealTimeCallRoll.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        childMenuItem = new AuthPermissionItem("AttSignAddress", "att_leftMenu_sign_address", "att:signAddress", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/attSignAddress.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignAddressRefresh", "common_op_refresh", "att:signAddress:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignAddressAdd", "common_op_new", "att:signAddress:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignAddressDel", "common_op_del", "att:signAddress:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignAddressEdit", "common_op_edit", "att:signAddress:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAdmsDevCmd", "att_leftMenu_adms_devCmd", "att:adms:devCmd", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAdmsDevCmd.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdmsDevCmdRefresh", "common_op_refresh", "att:adms:devCmd:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdmsDevCmdClearCmd", "adms_devCmd_clearCmd", "att:adms:devCmd:clearCmd", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdmsDevCmdExport", "common_op_export", "att:adms:devCmd:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdmsDevCmdDel", "common_op_del", "att:adms:devCmd:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDeviceOpLog", "att_leftMenu_device_op_log", "att:deviceoplog", "menu", "true", Integer.valueOf(8));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeviceOpLog.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceOpLogRefresh", "common_op_refresh", "att:deviceoplog:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceOpLogExport", "common_op_export", "att:deviceoplog:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttBasicInformation", "att_person_attSet", "att:basic:information", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attRule.do");
        parentMenuItem.setImg("att_basic.png");
        parentMenuItem.setImgHover("att_basic_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != childMenuItem) {
            buttonMenuItem = new AuthPermissionItem("PersPersonAttEdit", "pers_person_attSet", "pers:person:attEdit", "button", "true", Integer.valueOf(101));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        }
        childMenuItem = new AuthPermissionItem("AttRule", "att_leftMenu_base_rule", "att:rule", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attRule.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttRuleEdit", "common_op_edit", "att:rule:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttRuleRealTimeSet", "att_realTime_realTimeSet", "att:rule:realTimeSet", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttRuleEmployeeSet", "auth_login_personLogin", "att:rule:employeeSet", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttHoliday", "att_leftMenu_holiday", "att:holiday", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attHoliday.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayRefresh", "common_op_refresh", "att:holiday:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayAdd", "common_op_new", "att:holiday:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayDel", "common_op_del", "att:holiday:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayEdit", "common_op_edit", "att:holiday:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeaveType", "att_leftMenu_leaveType", "att:leaveType", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attLeaveType.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeRefresh", "common_op_refresh", "att:leaveType:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeAdd", "common_op_new", "att:leaveType:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeDel", "common_op_del", "att:leaveType:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeEdit", "common_op_edit", "att:leaveType:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAutoExport", "att_leftMenu_autoExport", "att:autoExport", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAutoExport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportRefresh", "common_op_refresh", "att:autoExport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportAdd", "common_op_new", "att:autoExport:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportDel", "common_op_del", "att:autoExport:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportEnable", "common_enable", "att:autoExport:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportDisable", "common_disable", "att:autoExport:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportEdit", "common_op_edit", "att:autoExport:edit", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("WfFlowableList", "wf_leftMenu_flow_setting", "wf:flow", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/wfFlow.do?moduleCode=att");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("WfFlowItemRefresh", "common_op_refresh", "wf:flow:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("WfFlowItemAdd", "common_op_add", "wf:flow:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("WfFlowItemEdit", "common_op_edit", "wf:flow:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("WfFlowItemDel", "common_op_del", "wf:flow:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("WfFlowItemEnable", "common_enable", "wf:flow:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("WfFlowItemDisable", "common_commStatus_disable", "wf:flow:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttScheduleManagement", "att_leftMenu_scheduleManagement", "att:schedule:management", "menu", "true", Integer.valueOf(4));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attGroup.do");
        parentMenuItem.setImg("att_schedule.png");
        parentMenuItem.setImgHover("att_schedule_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttTimeSlot", "att_leftMenu_timeSlot", "att:timeSlot", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTimeSlot.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotRefresh", "common_op_refresh", "att:timeSlot:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotAdd", "common_op_new", "att:timeSlot:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotDel", "common_op_del", "att:timeSlot:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotEdit", "common_op_edit", "att:timeSlot:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttShift", "att_leftMenu_shift", "att:shift", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attShift.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftRefresh", "common_op_refresh", "att:shift:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftAdd", "common_op_new", "att:shift:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftDel", "common_op_del", "att:shift:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftEdit", "common_op_edit", "att:shift:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftClearTimeSlot", "att_shift_cleanTimeSlot", "att:shift:clearTimeSlot", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttPersonSch", "att_leftMenu_personSch", "att:personsch", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attPersonSch.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchCycleSch", "att_personSch_cycleSch", "att:personsch:cycleSch", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchTempSch", "att_leftMenu_tempSch", "att:personsch:tempSch", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchCleanCycleSch", "att_personSch_cleanCycleSch", "att:personsch:cleanCycleSch", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchCleanTempSch", "att_personSch_cleanTempSch", "att:personsch:cleanTempSch", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchExport", "att_personSch_export", "att:personsch:export", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchImport", "att_personSch_import", "att:personsch:import", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchExportTemplate", "att_personSch_exportTemplate", "att:personsch:exportTemplate", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttGroup", "att_leftMenu_groupSch", "att:group", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attGroup.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupRefresh", "common_op_refresh", "att:group:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupAdd", "common_op_new", "att:group:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupDel", "common_op_del", "att:group:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupEdit", "common_op_edit", "att:group:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupAddPerson", "common_op_addPerson", "att:group:addPerson", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupPersonRefresh", "common_op_refresh", "att:groupPerson:refresh", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupPersonDel", "pers_common_delPerson", "att:groupPerson:del", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchCycleSch", "att_personSch_cycleSch", "att:personsch:cycleSch", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchTempSch", "att_leftMenu_tempSch", "att:personsch:tempSch", "button", "true", Integer.valueOf(10));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchCleanCycleSch", "att_personSch_cleanCycleSch", "att:personsch:cleanCycleSch", "button", "true", Integer.valueOf(11));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchCleanTempSch", "att_personSch_cleanTempSch", "att:personsch:cleanTempSch", "button", "true", Integer.valueOf(12));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttSchDetails", "att_leftMenu_schDetails", "att:schDetails", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attSchDetails.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSchDetailsDel", "att_personSch_delSch", "att:schDetails:del", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSchDetailsEdit", "common_op_edit", "att:schDetails:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSchDetailsDxport", "common_op_export", "att:schDetails:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttExceptionManagement", "att_leftMenu_exceptionManagement", "att:exception:management", "menu", "true", Integer.valueOf(5));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attSign.do");
        parentMenuItem.setImg("att_exception.png");
        parentMenuItem.setImgHover("att_exception_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttSign", "att_leftMenu_sign", "att:sign", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attSign.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignRefresh", "common_op_refresh", "att:sign:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignAdd", "common_op_new", "att:sign:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignDel", "common_op_del", "att:sign:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignExport", "common_op_export", "att:sign:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignImport", "common_op_import", "att:sign:import", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignApproval", "att_flow_approve", "att:sign:approval", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeave", "att_leftMenu_leave", "att:leave", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attLeave.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveRefresh", "common_op_refresh", "att:leave:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveAdd", "common_op_new", "att:leave:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveDel", "common_op_del", "att:leave:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveExport", "common_op_export", "att:leave:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveImage", "att_leave_image", "att:leave:image", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveImport", "common_op_import", "att:leave:import", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveApproval", "att_flow_approve", "att:leave:approval", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTrip", "att_leftMenu_trip", "att:trip", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTrip.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripRefresh", "common_op_refresh", "att:trip:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripAdd", "common_op_new", "att:trip:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripDel", "common_op_del", "att:trip:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripExport", "common_op_export", "att:trip:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttOut", "att_leftMenu_out", "att:out", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attOut.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutRefresh", "common_op_refresh", "att:out:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutAdd", "common_op_new", "att:out:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutDel", "common_op_del", "att:out:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutExport", "common_op_export", "att:out:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttOvertime", "att_leftMenu_overtime", "att:overtime", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attOvertime.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeRefresh", "common_op_refresh", "att:overtime:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeAdd", "common_op_new", "att:overtime:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeDel", "common_op_del", "att:overtime:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeExport", "common_op_export", "att:overtime:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeImport", "common_op_import", "att:overtime:import", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeApproval", "att_flow_approve", "att:overtime:approval", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAdjust", "att_schedule_offDetail", "att:adjust", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAdjust.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustRefresh", "common_op_refresh", "att:adjust:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustAdd", "common_op_new", "att:adjust:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustDel", "common_op_del", "att:adjust:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustExport", "common_op_export", "att:adjust:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustImport", "common_op_import", "att:adjust:import", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustApproval", "att_flow_approve", "att:adjust:approval", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttClass", "att_leftMenu_class", "att:class", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attClass.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassRefresh", "common_op_refresh", "att:class:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassAdd", "common_op_new", "att:class:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassDel", "common_op_del", "att:class:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassExport", "common_op_export", "att:class:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassImport", "common_op_import", "att:class:import", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassApproval", "att_flow_approve", "att:class:approval", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttDetailReport", "att_leftMenu_detailReport", "att:detail:report", "menu", "true", Integer.valueOf(6));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attManualCalculation.do");
        parentMenuItem.setImg("att_report.png");
        parentMenuItem.setImgHover("att_report_over.png");
        this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttManualCalculation", "att_leftMenu_manualCalculation", "att:manualCalculation", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attManualCalculation.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttManualCalculationRefresh", "common_op_refresh", "att:manualCalculation:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttManualCalculationCalculate", "att_op_calculation", "att:manualCalculation:calculate", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTransaction", "att_leftMenu_transaction", "att:transaction", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTransaction.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionRefresh", "common_op_refresh", "att:transaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionExport", "common_op_export", "att:transaction:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionImportUSBRecord", "att_op_importUSBRecord", "att:transaction:importUSBRecord", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionExportAttPhoto", "att_transaction_exportAttPhoto", "att:transaction:exportAttPhoto", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionSyncRecord", "att_transaction_SyncRecord", "att:transaction:SyncRecord", "button", "true", Integer.valueOf(10));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDayCardDetailReport", "att_leftMenu_dayCardDetailReport", "att:dayCardDetailReport", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayCardDetailReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayCardDetailReportRefresh", "common_op_refresh", "att:dayCardDetailReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayCardDetailReportExport", "common_op_export", "att:dayCardDetailReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttDailyReport", "att_leftMenu_dailyReport", "att:daily:report", "menu", "true", Integer.valueOf(7));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attDayDetailReport.do");
        parentMenuItem.setImg("att_report.png");
        parentMenuItem.setImgHover("att_report_over.png");
        this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttDayDetailReport", "att_leftMenu_dayDetailReport", "att:dayDetailReport", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayDetailReportRefresh", "common_op_refresh", "att:dayDetailReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayDetailReportExport", "common_op_export", "att:dayDetailReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttWorkTimeReport", "att_leftMenu_workTimeReport", "att:workTimeReport", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexWorkTimeReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttWorkTimeReportRefresh", "common_op_refresh", "att:workTimeReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttWorkTimeReportExport", "common_op_export", "att:workTimeReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttOvertimeReport", "att_leftMenu_overtimeReport", "att:overtimeReport", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexOvertimeReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeReportRefresh", "common_op_refresh", "att:overtimeReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeReportExport", "common_op_export", "att:overtimeReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeaveReport", "att_leftMenu_leaveReport", "att:leaveReport", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexLeaveReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveReportRefresh", "common_op_refresh", "att:leaveReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveReportExport", "common_op_export", "att:leaveReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAbnormalReport", "att_leftMenu_abnormal", "att:abnormalReport", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexAbnormalReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAbnormalReportRefresh", "common_op_refresh", "att:abnormalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAbnormalReportExport", "common_op_export", "att:abnormalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLateReport", "att_leftMenu_lateReport", "att:lateReport", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexLateReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLateReportRefresh", "common_op_refresh", "att:lateReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLateReportExport", "common_op_export", "att:lateReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttEarlyReport", "att_leftMenu_earlyReport", "att:earlyReport", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexEarlyReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttEarlyReportRefresh", "common_op_refresh", "att:earlyReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttEarlyReportExport", "common_op_export", "att:earlyReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAbsentReport", "att_leftMenu_absentReport", "att:absentReport", "menu", "true", Integer.valueOf(8));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do?indexAbsentReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAbsentReportRefresh", "common_op_refresh", "att:absentReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAbsentReportExport", "common_op_export", "att:absentReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttMonthReport", "att_leftMenu_monthReport", "att:month:report", "menu", "true", Integer.valueOf(8));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attMonthDetailReport.do");
        parentMenuItem.setImg("att_report.png");
        parentMenuItem.setImgHover("att_report_over.png");
        this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthDetailReport", "att_leftMenu_monthDetailReport", "att:monthDetailReport", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthDetailReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthDetailReportRefresh", "common_op_refresh", "att:monthDetailReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthDetailReportExport", "common_op_export", "att:monthDetailReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthWorkTimeReport", "att_leftMenu_monthWorkTimeReport", "att:monthWorkTimeReport", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthDetailReport.do?indexMonthWorkTimeReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthWorkTimeReportRefresh", "common_op_refresh", "att:monthWorkTimeReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthWorkTimeReportExport", "common_op_export", "att:monthWorkTimeReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthCardReport", "att_leftMenu_monthCardReport", "att:monthCardReport", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthDetailReport.do?indexMonthCardReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthCardReportRefresh", "common_op_refresh", "att:monthCardReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthCardReportExport", "common_op_export", "att:monthCardReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthOvertimeReport", "att_leftMenu_monthOvertimeReport", "att:monthOvertimeReport", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthDetailReport.do?indexMonthOvertimeReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthOvertimeReportRefresh", "common_op_refresh", "att:monthOvertimeReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthOvertimeReportExport", "common_op_export", "att:monthOvertimeReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttStatisticalReport", "att_leftMenu_statisticalReport", "att:statistical:report", "menu", "true", Integer.valueOf(9));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attMonthStatisticalReport.do");
        parentMenuItem.setImg("att_statistics_report.png");
        parentMenuItem.setImgHover("att_statistics_report_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthStatisticalReport", "att_leftMenu_monthStatisticalReport", "att:monthStatisticalReport", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthStatisticalReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthStatisticalReportRefresh", "common_op_refresh", "att:monthStatisticalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthStatisticalReportExport", "common_op_export", "att:monthStatisticalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttOvertimeSummaryReport", "att_leftMenu_overtimeSummaryReport", "att:overtimeSummaryReport", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthStatisticalReport.do?indexOvertimeSummaryReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeSummaryReportRefresh", "common_op_refresh", "att:overtimeSummaryReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeSummaryReportExport", "common_op_export", "att:overtimeSummaryReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeaveSummaryReport", "att_leftMenu_leaveSummaryReport", "att:leaveSummaryReport", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthStatisticalReport.do?indexLeaveSummaryReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveSummaryReportRefresh", "common_op_refresh", "att:leaveSummaryReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveSummaryReportExport", "common_op_export", "att:leaveSummaryReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDeptStatisticalReport", "att_leftMenu_deptStatisticalReport", "att:deptStatistiCalReport", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeptStatisticalReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptStatisticalReportRefresh", "common_op_refresh", "att:deptStatistiCalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptStatisticalReportExport", "common_op_export", "att:deptStatistiCalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDeptOvertimeSummaryReport", "att_leftMenu_deptOvertimeSummaryReport", "att:deptOvertimeSummaryReport", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeptStatisticalReport.do?indexDeptOvertimeSummaryReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptOvertimeSummaryReportRefresh", "common_op_refresh", "att:deptOvertimeSummaryReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptOvertimeSummaryReportExport", "common_op_export", "att:deptOvertimeSummaryReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDeptLeaveSummaryReport", "att_leftMenu_deptLeaveSummaryReport", "att:deptLeaveSummaryReport", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeptStatisticalReport.do?indexDeptLeaveSummaryReport");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptLeaveSummaryReportRefresh", "common_op_refresh", "att:deptLeaveSummaryReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptLeaveSummaryReportExport", "common_op_export", "att:deptLeaveSummaryReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAnnualLeaveReport", "att_annualLeave_report", "att:annualLeaveReport", "menu", "true", Integer.valueOf(10));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAnnualLeaveReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAnnualLeaveReportRefresh", "common_op_refresh", "att:annualLeaveReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAnnualLeaveReportExport", "common_op_export", "att:annualLeaveReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttSignCallRollReport", "att_leftMenu_attSignCallRollReport", "att:signCallRollReport", "menu", "true", Integer.valueOf(11));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attSignCallRollReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignCallRollReportRefresh", "common_op_refresh", "att:signCallRollReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignCallRollReportExport", "common_op_export", "att:signCallRollReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttCustomReportManage", "att_customReport", "att:customReport:manage", "menu", "true", Integer.valueOf(10));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attCustomReport.do");
        parentMenuItem.setImg("att_statistics_report.png");
        parentMenuItem.setImgHover("att_statistics_report_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttCustomReport", "att_customReport", "att:customReport", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attCustomReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomReportRefresh", "common_op_refresh", "att:customReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomReportAdd", "common_op_new", "att:customReport:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomReportDel", "common_op_del", "att:customReport:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomReportExport", "common_op_export", "att:customReport:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("WfFlowable", "wf_leftMenu_flow", "wf:task", "menu", "true", Integer.valueOf(11));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setImg("wf_flow.png");
        parentMenuItem.setImgHover("wf_flow_over.png");
        parentMenuItem.setActionLink("attWorkflow.do?myApply");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("WFFlowableMyApply", "wf_leftMenu_flowable_myapply", "wf:myApply:list", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attFlowable.do?myApply");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        childMenuItem = new AuthPermissionItem("WfFlowablePendingTask", "wf_leftMenu_flowable", "wf:pendingTask:list", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attFlowable.do?pendingTask");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        childMenuItem = new AuthPermissionItem("WfFlowableApprovedTask", "wf_leftMenu_flowable_his", "wf:approvedTask:list", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attFlowable.do?approvedTask");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
    }

    public void initAttParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.signIn", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleSignIn", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.signOut", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleSignOut", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.shortestMinutes", "120", I18nUtil.i18nCode((String)"att_rule_baseRuleShortestMinutes", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.longestMinutes", "600", I18nUtil.i18nCode((String)"att_rule_baseRuleLongestMinutes", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.elasticCal", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleElasticCal", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.lateAndEarly", "false", I18nUtil.i18nCode((String)"att_rule_baseRuleLateAndEarly", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.countOvertime", "true", I18nUtil.i18nCode((String)"att_rule_baseRuleCountOvertime", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.smartFindClass", "1", I18nUtil.i18nCode((String)"att_rule_baseRuleSmartFindClass", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.crossDay", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleCrossDay", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignInCountType", "absent", I18nUtil.i18nCode((String)"att_rule_noSignInCountType", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignInCountLateMinute", "0", I18nUtil.i18nCode((String)"att_rule_noSignInCountLateMinute", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignOffCountType", "absent", I18nUtil.i18nCode((String)"att_rule_noSignOffCountType", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignOffCountEarlyMinute", "0", I18nUtil.i18nCode((String)"att_rule_noSignOffCountEarlyMinute", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.decimal", "1", I18nUtil.i18nCode((String)"att_rule_countConvertDecimal", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.sms.uid", "0", "sms uid"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.reportSetting.shortDateFormat", "yyyy/MM/DD", "\u65e5\u671f\u683c\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.reportSetting.shortTimeFormat", "HH:mm", "\u65f6\u95f4\u683c\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.mapName", "gaodeMap", I18nUtil.i18nCode((String)"att_h5_defaultMap", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.distanceMatrixApi", "https://restapi.amap.com/v3/distance?origins=%s&destination=%s&type=0&key=", "\u6839\u636e\u7ecf\u7eac\u5ea6\u7b97\u8ddd\u79bb"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.placeApi", "https://restapi.amap.com/v3/geocode/regeo?output=json&location=%s&key=", "\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.mapKey", "4aeb1569617bc236f832a9ed0d6c3398", "\u4e91\u5e73\u53f0KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.googleMap", "googleMap", I18nUtil.i18nCode((String)"att_h5_googleMap", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.google.distanceMatrixApi", "https://maps.google.cn/maps/api/distancematrix/json?origins=%s&destinations=%s&key=", "\u8c37\u6b4capi\u6839\u636e\u7ecf\u7eac\u5ea6\u7b97\u8ddd\u79bb"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.google.placeApi", "https://maps.google.cn/maps/api/geocode/json?latlng=%s&key=", "\u8c37\u6b4capi\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.google.mapKey", "AIzaSyBOP5cLG70Jd0tC0j4sxCwCB3JaBGlsq40", "\u8c37\u6b4c\u4e91\u5e73\u53f0KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaodeMap", "gaodeMap", I18nUtil.i18nCode((String)"att_h5_gaodeMap", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.distanceMatrixApi", "https://restapi.amap.com/v3/distance?origins=%s&destination=%s&type=0&key=", "\u9ad8\u5fb7api\u6839\u636e\u7ecf\u7eac\u5ea6\u7b97\u8ddd\u79bb"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.placeApi", "https://restapi.amap.com/v3/geocode/regeo?output=json&location=%s&key=", "\u9ad8\u5fb7api\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.mapKey", "4aeb1569617bc236f832a9ed0d6c3398", "\u9ad8\u5fb7\u4e91\u5e73\u53f0JAVA-KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.mapJsKey", "042328d3d9dace44bbf87030e4cd9ccc", "\u9ad8\u5fb7\u4e91\u5e73\u53f0JS-KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.device.autoAdd", "1", "\u65b0\u589e\u8bbe\u5907\u81ea\u52a8\u6dfb\u52a0"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.device.receivePersonOnlyDb", "1", "\u4ec5\u63a5\u6536\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u7684\u4eba\u5458\u6570\u636e"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.rollCall", "1", "\u5b9e\u65f6\u70b9\u540d"));
        String enableEmpLogin = "0";
        if ("ZKBioAccess".equals(this.productCode)) {
            enableEmpLogin = "1";
        }
        this.baseSysParamService.initData(new BaseSysParamItem("att.self.loginEntrance", enableEmpLogin, "\u5458\u5de5\u81ea\u52a9\u767b\u5f55\u5165\u53e3"));
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"03:00:00");
        values.put("keptType", (Object)BaseDataConstants.DATA_CLEAN_KEPTMONTH);
        BaseSysParamItem item = new BaseSysParamItem("attReportDataClean", values.toString(), "base_dataClean_attTrans");
        this.baseSysParamService.initData(item);
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.enable", "0", "\u662f\u5426\u542f\u5b9e\u65f6\u8ba1\u7b97\uff080\u542f\u7528\u30011\u7981\u7528\u3001\u9ed8\u8ba4\u542f\u7528\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.calculate", "0 0/2 * * * ?", "\u8003\u52e4\u5b9e\u65f6\u8ba1\u7b97\u9891\u7387"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.updateSchInfo", "0 0 1 * * ?", "\u6bcf\u5929\u5b9a\u65f6\u66f4\u65b0\u6392\u73ed\u4fe1\u606f"));
        Calendar defaultDate = Calendar.getInstance();
        defaultDate.set(11, 2);
        defaultDate.set(12, 0);
        defaultDate.set(13, 0);
        defaultDate.set(14, 0);
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.calculateAllTime", DateUtil.dateToString((Date)defaultDate.getTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS), "\u8ba1\u7b97\u6240\u6709\u4eba\u5458\u7684\u65f6\u95f4"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.report.updateDayCardDetail", "0 */10 * * * ?", "\u6bcf10\u5206\u949f\u7edf\u8ba1\u4e00\u6b21"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.point.pullTransaction", "0 0/5 * * * ?", "\u8003\u52e4\u70b9\u5b9a\u65f6\u83b7\u53d6\u8bb0\u5f55\u9891\u7387"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.enable", "0", "\u662f\u5426\u542f\u5b9e\u5e74\u5047\uff080\u542f\u7528\u30011\u7981\u7528\uff08\u7a7a\u4e5f\u662f\u7981\u7528\uff09\u3001\u9ed8\u8ba4\u542f\u7528\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.calculateDate", "", "\u5e74\u5047\u6e05\u96f6\u53d1\u653e\u65e5\u671f"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.calculateMonth", "1", "\u5e74\u5047\u6e05\u96f6\u53d1\u653e\u6708\u4efd"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.calculateDay", "1", "\u5e74\u5047\u6e05\u96f6\u6e05\u96f6\u53d1\u653e\u65e5"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.calculateType", "rounding", "\u6309\u5de5\u9f84\u6708\u4efd\u6bd4\u4f8b\u65f6\u957f\u8ba1\u7b97\u65b9\u5f0f\uff08abort=\u5411\u4e0b\uff08\u820d\u5f03\uff09,rounding=\u56db\u820d\u4e94\u5165,carry=\u5411\u4e0a\uff08\u8fdb\u4f4d\uff09\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.rule", "0-1-0,1-10-5,10-20-10,20-999-15", "\u5e74\u5047\u65f6\u957f\u89c4\u5219"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.annualLeave.enableCalculateType", "false", "\u662f\u5426\u542f\u7528\u6309\u5de5\u9f84\u6708\u4efd\u6bd4\u4f8b\u65f6\u957f\u8ba1\u7b97"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.photo.encryptProp", "true", "\u4eba\u5458\u654f\u611f\u4fe1\u606f\u4fdd\u62a4-\u8003\u52e4\u7167\u7247"));
        JSONObject notificationValues = new JSONObject();
        notificationValues.put("Email", (Object)"1");
        notificationValues.put("SMS", (Object)"1");
        notificationValues.put("Whatsapp", (Object)"1");
        notificationValues.put("Line", (Object)"1");
        BaseSysParamItem attMessageNotification = new BaseSysParamItem("attMessageNotification", notificationValues.toString(), "base_dataClean_attTrans");
        this.baseSysParamService.initData(attMessageNotification);
    }

    private void initAttLeaveType() {
        this.jdbcOperateTemplate.alterTableCharLen("ATT_LEAVETYPE", "LEAVETYPE_NO", "50");
        ArrayList<AttLeaveTypeItem> attLeaveTypeItemList = new ArrayList<AttLeaveTypeItem>();
        AttLeaveTypeItem leaveThing = new AttLeaveTypeItem("L1", I18nUtil.i18nCode((String)"att_leaveType_leaveThing", (Object[])new Object[0]), Boolean.valueOf(true), Boolean.valueOf(true), new Double(0.5), "hour", "rounding", I18nUtil.i18nCode((String)"att_other_leaveThing", (Object[])new Object[0]), "leaveType");
        leaveThing.setSortNo(Integer.valueOf(1));
        attLeaveTypeItemList.add(leaveThing);
        AttLeaveTypeItem leaveAnnual = new AttLeaveTypeItem("L5", I18nUtil.i18nCode((String)"att_leaveType_leaveAnnual", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(0.5), "day", "rounding", I18nUtil.i18nCode((String)"att_other_leaveAnnual", (Object[])new Object[0]), "leaveType");
        leaveAnnual.setSortNo(Integer.valueOf(2));
        attLeaveTypeItemList.add(leaveAnnual);
        AttLeaveTypeItem leaveSick = new AttLeaveTypeItem("L4", I18nUtil.i18nCode((String)"att_leaveType_leaveSick", (Object[])new Object[0]), Boolean.valueOf(true), Boolean.valueOf(true), new Double(1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_other_leaveSick", (Object[])new Object[0]), "leaveType");
        leaveSick.setSortNo(Integer.valueOf(3));
        attLeaveTypeItemList.add(leaveSick);
        AttLeaveTypeItem leaveMarriage = new AttLeaveTypeItem("L2", I18nUtil.i18nCode((String)"att_leaveType_leaveMarriage", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "day", "carry", I18nUtil.i18nCode((String)"att_other_leaveMarriage", (Object[])new Object[0]), "leaveType");
        leaveMarriage.setSortNo(Integer.valueOf(4));
        attLeaveTypeItemList.add(leaveMarriage);
        AttLeaveTypeItem leaveBirth = new AttLeaveTypeItem("L3", I18nUtil.i18nCode((String)"att_leaveType_leaveBirth", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "day", "carry", I18nUtil.i18nCode((String)"att_other_leaveBirth", (Object[])new Object[0]), "leaveType");
        leaveBirth.setSortNo(Integer.valueOf(5));
        attLeaveTypeItemList.add(leaveBirth);
        AttLeaveTypeItem leaveNursing = new AttLeaveTypeItem("L8", I18nUtil.i18nCode((String)"att_leaveType_leaveNursing", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "hour", "rounding", I18nUtil.i18nCode((String)"att_other_leaveNursing", (Object[])new Object[0]), "leaveType");
        leaveNursing.setSortNo(Integer.valueOf(6));
        attLeaveTypeItemList.add(leaveNursing);
        AttLeaveTypeItem leaveHome = new AttLeaveTypeItem("L7", I18nUtil.i18nCode((String)"att_leaveType_leaveHome", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "day", "rounding", I18nUtil.i18nCode((String)"att_other_leaveHome", (Object[])new Object[0]), "leaveType");
        leaveHome.setSortNo(Integer.valueOf(7));
        attLeaveTypeItemList.add(leaveHome);
        AttLeaveTypeItem leaveFuneral = new AttLeaveTypeItem("L6", I18nUtil.i18nCode((String)"att_leaveType_leaveFuneral", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "day", "carry", I18nUtil.i18nCode((String)"att_other_leaveFuneral", (Object[])new Object[0]), "leaveType");
        leaveFuneral.setSortNo(Integer.valueOf(8));
        attLeaveTypeItemList.add(leaveFuneral);
        AttLeaveTypeItem trip = new AttLeaveTypeItem("trip", I18nUtil.i18nCode((String)"att_leftMenu_trip", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(0.5), "day", "rounding", I18nUtil.i18nCode((String)"att_other_leavetrip", (Object[])new Object[0]), "leaveType");
        trip.setSortNo(Integer.valueOf(9));
        attLeaveTypeItemList.add(trip);
        AttLeaveTypeItem out = new AttLeaveTypeItem("out", I18nUtil.i18nCode((String)"att_leftMenu_out", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(0.5), "hour", "rounding", I18nUtil.i18nCode((String)"att_other_leaveout", (Object[])new Object[0]), "leaveType");
        out.setSortNo(Integer.valueOf(10));
        attLeaveTypeItemList.add(out);
        AttLeaveTypeItem actual = new AttLeaveTypeItem("actual", I18nUtil.i18nCode((String)"att_rule_arrive", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "minute", "carry", I18nUtil.i18nCode((String)"att_other_arrive", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(actual);
        AttLeaveTypeItem early = new AttLeaveTypeItem("early", I18nUtil.i18nCode((String)"att_common_early", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "minute", "carry", I18nUtil.i18nCode((String)"att_other_early", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(early);
        AttLeaveTypeItem late = new AttLeaveTypeItem("late", I18nUtil.i18nCode((String)"att_common_late", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(1.0), "minute", "carry", I18nUtil.i18nCode((String)"att_other_late", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(late);
        AttLeaveTypeItem noCheckOut = new AttLeaveTypeItem("noCheckOut", I18nUtil.i18nCode((String)"att_rule_noSignOff", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_other_noSignOff", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(noCheckOut);
        AttLeaveTypeItem noCheckIn = new AttLeaveTypeItem("noCheckIn", I18nUtil.i18nCode((String)"att_rule_noSignIn", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_other_noSignIn", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(noCheckIn);
        AttLeaveTypeItem overtime = new AttLeaveTypeItem("overtime", I18nUtil.i18nCode((String)"att_common_overtime", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(0.5), "hour", "carry", I18nUtil.i18nCode((String)"att_other_overtime", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(overtime);
        AttLeaveTypeItem absent = new AttLeaveTypeItem("absent", I18nUtil.i18nCode((String)"att_common_absent", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(0.5), "hour", "carry", I18nUtil.i18nCode((String)"att_other_absent", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(absent);
        AttLeaveTypeItem schAndRest = new AttLeaveTypeItem("schAndRest", I18nUtil.i18nCode((String)"att_common_schAndRest", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_schedule_off", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(schAndRest);
        AttLeaveTypeItem noSch = new AttLeaveTypeItem("noSch", I18nUtil.i18nCode((String)"att_schedule_noSchDetail", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_statistical_remarkNoSch", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(noSch);
        AttLeaveTypeItem tuneOff = new AttLeaveTypeItem("tuneOff", I18nUtil.i18nCode((String)"att_rule_off", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_other_off", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(tuneOff);
        AttLeaveTypeItem attClass = new AttLeaveTypeItem("class", I18nUtil.i18nCode((String)"att_schedule_classDetail", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_schedule_class", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(attClass);
        AttLeaveTypeItem holiday = new AttLeaveTypeItem("holiday", I18nUtil.i18nCode((String)"att_leftMenu_holiday", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_statistical_remarkHoliday", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(holiday);
        AttLeaveTypeItem noCheckInInc = new AttLeaveTypeItem("noCheckInInc", I18nUtil.i18nCode((String)"att_rule_noCheckInIncomplete", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_other_incomplete", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(noCheckInInc);
        AttLeaveTypeItem noCheckOutInc = new AttLeaveTypeItem("noCheckOutInc", I18nUtil.i18nCode((String)"att_rule_noCheckOutIncomplete", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true), new Double(-1.0), "hour", "carry", I18nUtil.i18nCode((String)"att_other_outcomplete", (Object[])new Object[0]), "params");
        attLeaveTypeItemList.add(noCheckOutInc);
        for (AttLeaveTypeItem attLeaveTypeItem : attLeaveTypeItemList) {
            this.attLeaveTypeService.initData(attLeaveTypeItem);
        }
    }

    private void initAttDictionary() {
        BaseDictionaryItem baseDictionaryItem = new BaseDictionaryItem("AttShiftWorkType", "att_shift_workType", Boolean.valueOf(false), "att_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("normalWork", "att_shift_normalWork", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("weekendOt", "att_overtime_rest", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("holidayOt", "att_shift_holidayOt", Integer.valueOf(2), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("AttVerifyMode", "common_verifyMode_entiy", Boolean.valueOf(false), "att_module");
        this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "att_verifyMode_0", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "att_verifyMode_1", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "att_verifyMode_2", Integer.valueOf(2), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "att_verifyMode_3", Integer.valueOf(3), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "att_verifyMode_4", Integer.valueOf(4), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "att_verifyMode_5", Integer.valueOf(5), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "att_verifyMode_6", Integer.valueOf(6), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", "att_verifyMode_7", Integer.valueOf(7), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", "att_verifyMode_8", Integer.valueOf(8), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", "att_verifyMode_9", Integer.valueOf(9), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("10", "att_verifyMode_10", Integer.valueOf(10), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("11", "att_verifyMode_11", Integer.valueOf(11), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("12", "att_verifyMode_12", Integer.valueOf(12), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("13", "att_verifyMode_13", Integer.valueOf(13), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("14", "att_verifyMode_14", Integer.valueOf(14), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("15", "att_verifyMode_15", Integer.valueOf(15), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("16", "att_verifyMode_16", Integer.valueOf(16), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("17", "att_verifyMode_17", Integer.valueOf(17), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("18", "att_verifyMode_18", Integer.valueOf(18), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("19", "att_verifyMode_19", Integer.valueOf(19), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("20", "att_verifyMode_20", Integer.valueOf(20), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("21", "att_verifyMode_21", Integer.valueOf(21), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("22", "att_verifyMode_22", Integer.valueOf(22), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("23", "att_verifyMode_23", Integer.valueOf(23), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("24", "att_verifyMode_24", Integer.valueOf(24), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("25", "att_verifyMode_25", Integer.valueOf(25), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("26", "att_verifyMode_26", Integer.valueOf(26), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("27", "att_verifyMode_27", Integer.valueOf(27), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("28", "att_verifyMode_28", Integer.valueOf(28), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("29", "att_verifyMode_29", Integer.valueOf(29), baseDictionaryItem.getId()));
    }

    private void initUpgradeVersion() {
        BaseSysParamItem baseSysParamItem;
        String curVersion = VersionUtil.getReleaseGitTags((String)"att");
        if (StringUtils.isNotBlank((CharSequence)curVersion) && StringUtils.isBlank((CharSequence)(baseSysParamItem = this.baseSysParamService.findByParamName("AttUpgradeVersion")).getId())) {
            baseSysParamItem = new BaseSysParamItem("AttUpgradeVersion", curVersion, "Att Upgrade Version", Boolean.valueOf(true));
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

