/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.vo;

import com.zkteco.zkbiosecurity.auth.vo.AuthAppItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@From(after="AUTH_USER AU")
@OrderBy(after="AU.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=600, winWidth=500, operates={@GridOperate(type="edit", permission="auth:user:edit", url="authUser.do?edit", label="common_op_edit", filter="authUserShowEdit"), @GridOperate(type="del", permission="auth:user:del", url="authUser.do?del&usernames=(username)", label="common_op_del", showConvertor="showDelAuthUser")})
public class AuthUserItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 6038447890271759288L;
    @Column(name="AU.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="AU.USERNAME")
    @GridColumn(label="auth_user_username", width="150", columnType="edit", editPermission="auth:user:edit", editUrl="authUser.do?edit", filter="authUserShowEdit")
    private String username;
    private String loginPwd;
    private String repassword;
    @Column(name="AU.PWD_CREATE_TIME")
    private Date pwdCreateTime;
    @Column(name="AU.USER_LOGIN_LIMIT")
    private Integer userLoginLimit;
    @Column(name="AU.NAME")
    @GridColumn(label="auth_user_firstName", width="100", encryptMode="${systemEntry.name.encryptMode}", encryptProp="${systemEntry.name.encryptProp}")
    private String name;
    @Column(name="AU.LAST_NAME")
    @GridColumn(label="auth_user_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${systemEntry.lastName.encryptMode}", encryptProp="${systemEntry.lastName.encryptProp}")
    private String lastName;
    @Column(name="AU.EMAIL")
    @GridColumn(label="auth_user_email", width="200", encryptMode="${systemEntry.email.encryptMode}", encryptProp="${systemEntry.email.encryptProp}")
    private String email;
    @Column(name="AU.PHONE")
    @GridColumn(label="auth_user_phone", width="200", show=false)
    private String phone;
    @GridColumn(label="auth_user_authorizedDepartment", width="200")
    private String authUserAuthorizedDept;
    @GridColumn(label="auth_user_authorizedAreas", width="200")
    private String authUserAuthorizedArea;
    private Boolean isStaff;
    @Column(name="AU.IS_ACTIVE")
    @GridColumn(label="auth_user_staffState", width="110", columnType="custom", convert="convertToIcon")
    private Boolean isActive;
    @Column(name="AU.IS_SUPERUSER")
    @GridColumn(label="auth_user_superuserState", width="110", columnType="custom", convert="convertToIcon")
    private Boolean isSuperuser;
    @Column(name="AU.INIT_FLAG")
    private Boolean initFlag;
    @Column(name="AU.COMPANY_ID")
    private String companyId;
    @Column(name="AU.PWD_INIT_FLAG")
    private String pwdInitFlag;
    @Column(name="AU.SALT")
    private String salt;
    private Boolean appAuthorization;
    private Boolean enabledCredential;
    private Set<String> roleSet = new HashSet<String>();
    private Set<String> permissionSet = new HashSet<String>();
    private List<AuthAreaItem> areaList = new ArrayList<AuthAreaItem>();
    private List<AuthDepartmentItem> departmentList = new ArrayList<AuthDepartmentItem>();
    private List<AuthAppItem> appList = new ArrayList<AuthAppItem>();
    private String appId;
    private String areaIds;
    private String deptIds;
    private String roleIds;
    private String bioTemplateJson;
    private String fingerTemplate;
    private String fingerId;

    public AuthUserItem() {
    }

    public AuthUserItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AuthUserItem(String username, String loginPwd, String name) {
        this.username = username;
        this.loginPwd = loginPwd;
        this.name = name;
    }

    public boolean showDelAuthUser() {
        return this.initFlag == null || this.initFlag == false;
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLoginPwd() {
        return this.loginPwd;
    }

    public String getRepassword() {
        return this.repassword;
    }

    public Date getPwdCreateTime() {
        return this.pwdCreateTime;
    }

    public Integer getUserLoginLimit() {
        return this.userLoginLimit;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getAuthUserAuthorizedDept() {
        return this.authUserAuthorizedDept;
    }

    public String getAuthUserAuthorizedArea() {
        return this.authUserAuthorizedArea;
    }

    public Boolean getIsStaff() {
        return this.isStaff;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Boolean getIsSuperuser() {
        return this.isSuperuser;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getPwdInitFlag() {
        return this.pwdInitFlag;
    }

    public String getSalt() {
        return this.salt;
    }

    public Boolean getAppAuthorization() {
        return this.appAuthorization;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public Set<String> getRoleSet() {
        return this.roleSet;
    }

    public Set<String> getPermissionSet() {
        return this.permissionSet;
    }

    public List<AuthAreaItem> getAreaList() {
        return this.areaList;
    }

    public List<AuthDepartmentItem> getDepartmentList() {
        return this.departmentList;
    }

    public List<AuthAppItem> getAppList() {
        return this.appList;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAreaIds() {
        return this.areaIds;
    }

    public String getDeptIds() {
        return this.deptIds;
    }

    public String getRoleIds() {
        return this.roleIds;
    }

    public String getBioTemplateJson() {
        return this.bioTemplateJson;
    }

    public String getFingerTemplate() {
        return this.fingerTemplate;
    }

    public String getFingerId() {
        return this.fingerId;
    }

    public AuthUserItem setId(String id) {
        this.id = id;
        return this;
    }

    public AuthUserItem setUsername(String username) {
        this.username = username;
        return this;
    }

    public AuthUserItem setLoginPwd(String loginPwd) {
        this.loginPwd = loginPwd;
        return this;
    }

    public AuthUserItem setRepassword(String repassword) {
        this.repassword = repassword;
        return this;
    }

    public AuthUserItem setPwdCreateTime(Date pwdCreateTime) {
        this.pwdCreateTime = pwdCreateTime;
        return this;
    }

    public AuthUserItem setUserLoginLimit(Integer userLoginLimit) {
        this.userLoginLimit = userLoginLimit;
        return this;
    }

    public AuthUserItem setName(String name) {
        this.name = name;
        return this;
    }

    public AuthUserItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public AuthUserItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthUserItem setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public AuthUserItem setAuthUserAuthorizedDept(String authUserAuthorizedDept) {
        this.authUserAuthorizedDept = authUserAuthorizedDept;
        return this;
    }

    public AuthUserItem setAuthUserAuthorizedArea(String authUserAuthorizedArea) {
        this.authUserAuthorizedArea = authUserAuthorizedArea;
        return this;
    }

    public AuthUserItem setIsStaff(Boolean isStaff) {
        this.isStaff = isStaff;
        return this;
    }

    public AuthUserItem setIsActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public AuthUserItem setIsSuperuser(Boolean isSuperuser) {
        this.isSuperuser = isSuperuser;
        return this;
    }

    public AuthUserItem setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
        return this;
    }

    public AuthUserItem setCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    public AuthUserItem setPwdInitFlag(String pwdInitFlag) {
        this.pwdInitFlag = pwdInitFlag;
        return this;
    }

    public AuthUserItem setSalt(String salt) {
        this.salt = salt;
        return this;
    }

    public AuthUserItem setAppAuthorization(Boolean appAuthorization) {
        this.appAuthorization = appAuthorization;
        return this;
    }

    public AuthUserItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public AuthUserItem setRoleSet(Set<String> roleSet) {
        this.roleSet = roleSet;
        return this;
    }

    public AuthUserItem setPermissionSet(Set<String> permissionSet) {
        this.permissionSet = permissionSet;
        return this;
    }

    public AuthUserItem setAreaList(List<AuthAreaItem> areaList) {
        this.areaList = areaList;
        return this;
    }

    public AuthUserItem setDepartmentList(List<AuthDepartmentItem> departmentList) {
        this.departmentList = departmentList;
        return this;
    }

    public AuthUserItem setAppList(List<AuthAppItem> appList) {
        this.appList = appList;
        return this;
    }

    public AuthUserItem setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public AuthUserItem setAreaIds(String areaIds) {
        this.areaIds = areaIds;
        return this;
    }

    public AuthUserItem setDeptIds(String deptIds) {
        this.deptIds = deptIds;
        return this;
    }

    public AuthUserItem setRoleIds(String roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    public AuthUserItem setBioTemplateJson(String bioTemplateJson) {
        this.bioTemplateJson = bioTemplateJson;
        return this;
    }

    public AuthUserItem setFingerTemplate(String fingerTemplate) {
        this.fingerTemplate = fingerTemplate;
        return this;
    }

    public AuthUserItem setFingerId(String fingerId) {
        this.fingerId = fingerId;
        return this;
    }
}

