/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="AUTH_DEPARTMENT t LEFT JOIN AUTH_DEPARTMENT p ON t.PARENT_ID = p.ID ")
@OrderBy(after="t.SORT,t.CREATE_TIME")
@GridConfig(operate=true, idField="id", winHeight=320, winWidth=470, operates={@GridOperate(type="edit", permission="auth:department:edit", url="authDepartment.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="auth:department:del", url="authDepartment.do?del", label="common_op_del", showConvertor="delShowConvertor", click="reloadDeptTreeAndGrid")})
public class AuthDepartmentItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    public static final short DEPT_NORMAL = 0;
    public static final short DEPT_DELETE = 1;
    public static final short DEPT_MODULE = 2;
    public static final String INIT_CODE_AUTH_DEPT = "1";
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.CODE")
    @GridColumn(columnType="edit", label="auth_dept_deptNo", width="100", editPermission="auth:department:edit", editUrl="authDepartment.do?edit&id=(id)")
    private String code;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="auth_dept_deptName", width="150", editPermission="auth:department:edit", editUrl="authDepartment.do?edit&id=(id)")
    private String name;
    @Column(name="t.SORT")
    @GridColumn(show=false)
    private Integer sortNo;
    @Column(name="p.CODE")
    @GridColumn(label="auth_dept_parentDeptNo", width="150")
    private String parentCode;
    @Column(name="p.NAME")
    @GridColumn(label="auth_dept_parentDeptName", width="150")
    private String parentName;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="common_createdDate", width="150", isExportExcel=false)
    private Date createTime;
    @Column(name="p.ID", equalTag="=")
    @GridColumn(show=false)
    private String parentId;
    @Column(name="t.INIT_CODE")
    private String initCode;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.CODE", equalTag="in")
    private String inCode;
    @Condition(value="t.NAME", equalTag="in")
    private String inName;
    @Column(name="t.APP_ID", equalTag="=")
    private String appId;
    @Condition(value="t.APP_ID", equalTag="in")
    private String inAppId;
    @Condition(value="t.UPDATE_TIME", equalTag=">=")
    private Date updateAfter;
    @Condition(value="t.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public AuthDepartmentItem() {
    }

    public AuthDepartmentItem(Boolean equals) {
        super(equals);
    }

    public AuthDepartmentItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AuthDepartmentItem(String code, String initCode, String name, Integer sortNo) {
        this.name = name;
        this.code = code;
        this.initCode = initCode;
        this.sortNo = sortNo;
    }

    public AuthDepartmentItem(String code, String name, Integer sortNo) {
        this.name = name;
        this.code = code;
        this.sortNo = sortNo;
    }

    public boolean delShowConvertor() {
        return !INIT_CODE_AUTH_DEPT.equals(this.initCode);
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getInitCode() {
        return this.initCode;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInCode() {
        return this.inCode;
    }

    public String getInName() {
        return this.inName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getInAppId() {
        return this.inAppId;
    }

    public Date getUpdateAfter() {
        return this.updateAfter;
    }

    public String getUserId() {
        return this.userId;
    }

    public AuthDepartmentItem setId(String id) {
        this.id = id;
        return this;
    }

    public AuthDepartmentItem setCode(String code) {
        this.code = code;
        return this;
    }

    public AuthDepartmentItem setName(String name) {
        this.name = name;
        return this;
    }

    public AuthDepartmentItem setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
        return this;
    }

    public AuthDepartmentItem setParentCode(String parentCode) {
        this.parentCode = parentCode;
        return this;
    }

    public AuthDepartmentItem setParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public AuthDepartmentItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public AuthDepartmentItem setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public AuthDepartmentItem setInitCode(String initCode) {
        this.initCode = initCode;
        return this;
    }

    public AuthDepartmentItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public AuthDepartmentItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public AuthDepartmentItem setInCode(String inCode) {
        this.inCode = inCode;
        return this;
    }

    public AuthDepartmentItem setInName(String inName) {
        this.inName = inName;
        return this;
    }

    public AuthDepartmentItem setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public AuthDepartmentItem setInAppId(String inAppId) {
        this.inAppId = inAppId;
        return this;
    }

    public AuthDepartmentItem setUpdateAfter(Date updateAfter) {
        this.updateAfter = updateAfter;
        return this;
    }

    public AuthDepartmentItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

