/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.cache.PersCacheManager;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import com.zkteco.zkbiosecurity.pers.service.PersSupportFuncService;
import com.zkteco.zkbiosecurity.pers.service.PersUserTypeService;
import com.zkteco.zkbiosecurity.pers.service.PersWiegandFmtService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonnalListItem;
import com.zkteco.zkbiosecurity.pers.vo.PersUserTypeItem;
import com.zkteco.zkbiosecurity.pers.vo.PersWiegandFmtItem;
import com.zkteco.zkbiosecurity.system.constants.BasePrintTemplateConstants;
import com.zkteco.zkbiosecurity.system.service.BasePrintParamService;
import com.zkteco.zkbiosecurity.system.service.BasePrintTemplateService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BasePrintParamItem;
import com.zkteco.zkbiosecurity.system.vo.BasePrintTemplateItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=20)
public class PersInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private PersWiegandFmtService persWiegandFmtService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BasePrintParamService basePrintParamService;
    @Autowired
    private BasePrintTemplateService basePrintTemplateService;
    @Autowired
    private PersSupportFuncService persSupportFuncService;
    @Autowired
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersCacheManager persCacheManager;
    @Autowired
    private PersUserTypeService persUserTypeService;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("PersInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initPersWiegandFmtItem();
            this.initPersonnalList();
            this.initPersParams();
            this.initPersUserType();
            if (this.persSupportFuncService.isSupportPrintTemplate()) {
                this.initPrintTemplate();
            }
            if (!"zh_CN".equals(this.language) && !this.isCloud.booleanValue()) {
                this.initAppMenus();
            }
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("PersInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Pers", "pers_module", "pers", "system", "true", Integer.valueOf(2));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("PersPersonManager", "pers_person_manager", "pers:person:manager", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("persPerson.do");
        subMenuItem1.setImg("pers.png");
        subMenuItem1.setImgHover("pers_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("PersPerson", "pers_person", "pers:person", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("PersPersonRefresh", "common_op_refresh", "pers:person:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonAdd", "common_op_new", "pers:person:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonEdit", "common_op_edit", "pers:person:edit", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonDel", "common_op_del", "pers:person:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonResetSelfPwd", "pers_person_resetSelfPwd", "pers:person:resetSelfPwd", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonDataCount", "pers_person_dataCount", "pers:person:dataCount", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonCardPrint", "pers_person_cardprint", "pers:person:cardPrint", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonDelBioTemplate", "pers_person_delBioTemplate", "pers:person:delBioTemplate", "button", "true", Integer.valueOf(17));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonViewBioPhoto", "pers_person_cropFaceShow", "pers:person:viewBioPhoto", "button", "true", Integer.valueOf(20));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonEnabled", "common_enable", "pers:person:enabled", "button", "true", Integer.valueOf(21));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonDisable", "common_disable", "pers:person:disable", "button", "true", Integer.valueOf(22));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonAppLoginEnabled", "pers_applogin_enabled", "pers:person:enabledApplogin", "button", "true", Integer.valueOf(23));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonAppLoginDisable", "pers_applogin_disable", "pers:person:disableApplogin", "button", "true", Integer.valueOf(24));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonPayment", "pers_person_payment", "pers:person:payment", "button", "true", Integer.valueOf(18));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonRenewal", "pers_person_renewal", "pers:person:renewal", "button", "true", Integer.valueOf(19));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonMemberMeasurements", "pers_person_member_measurements", "pers:person:memberMeasurements", "button", "true", Integer.valueOf(20));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersMembership", "pers_membership", "pers:membership", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persMembership.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersMembershipRefresh", "common_op_refresh", "pers:membership:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersMembershipAdd", "common_op_new", "pers:membership:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersMembershipEdit", "common_op_edit", "pers:membership:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersMembershipDel", "common_op_del", "pers:membership:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersUserType", "pers_userType", "pers:userType", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persUserType.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersUserTypeRefresh", "common_op_refresh", "pers:userType:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersUserTypeAdd", "common_op_new", "pers:userType:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersUserTypeEdit", "common_op_edit", "pers:userType:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersUserTypeDel", "common_op_del", "pers:userType:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersTrainerPlan", "pers_trainerPlan", "pers:trainerPlan", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persTrainerPlan.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersTrainerPlanRefresh", "common_op_refresh", "pers:trainerPlan:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTrainerPlanAdd", "common_op_new", "pers:trainerPlan:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTrainerPlanEdit", "common_op_edit", "pers:trainerPlan:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTrainerPlanDel", "common_op_del", "pers:trainerPlan:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersParams", "common_leftMenu_paramSet", "pers:params", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("skip.do?page=pers_params_params");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersParamsEdit", "common_op_edit", "pers:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersTempPerson", "pers_tempPerson", "pers:tempPerson", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persTempPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonRefresh", "common_op_refresh", "pers:tempPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonAudit", "pers_tempPerson_audit", "pers:tempPerson:audit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonDel", "common_op_del", "pers:tempPerson:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonView", "pers_tempPerson_view", "pers:tempPerson:view", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersAttribute", "pers_attribute", "pers:attribute", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persAttribute.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersAttributeRefresh", "common_op_refresh", "pers:attribute:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersAttributeAdd", "common_op_new", "pers:attribute:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersAttributeEdit", "common_op_edit", "pers:attribute:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersAttributeDel", "common_op_del", "pers:attribute:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PersInquiryManager", "pers_inquiryManager", "pers:inquiryManager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("persInquiryManagement.do");
        subMenuItem1.setImg("vis_register.png");
        subMenuItem1.setImgHover("vis_register_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PersInquiryManagement", "pers_inquiryManagement", "pers:inquiryManagement", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persInquiryManagement.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersInquiryManagementRefresh", "common_op_refresh", "pers:inquiryManagement:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersInquiryManagementAdd", "common_op_new", "pers:inquiryManagement:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersInquiryManagementEdit", "common_op_edit", "pers:inquiryManagement:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersInquiryManagementDel", "common_op_del", "pers:inquiryManagement:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersInquiryConvertToMember", "pers_inquiry_convert_to_member", "pers:inquiry:convertToMember", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PersUserManagementReports", "pers_User_management_Reports", "pers:user:management:reports", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("persPaymentReport.do");
        subMenuItem1.setImg("comm_reports.png");
        subMenuItem1.setImgHover("comm_reports_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PersPaymentReport", "pers_payment_report", "pers:payment:report", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persPaymentReport.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersPaymentReportRefresh", "common_op_refresh", "pers:payment:report:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPaymentReportDuePay", "pers_payment_report_duePay", "pers:payment:report:duePay", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPaymentReportSendInvoice", "pers_payment_report_sendInvoice", "pers:payment:report:sendInvoice", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersPaymentHistoryReport", "pers_payment_history_report", "pers:payment:history:report", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persPaymentHistoryReport.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersPaymentHistoryReportRefresh", "common_op_refresh", "pers:payment:history:report:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersNewMemberReport", "pers_newMember_report", "pers:newMember:report", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persNewMemberReport.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersNewMemberReportRefresh", "common_op_refresh", "pers:newMember:report:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersMemberExpiryReport", "pers_memberExpiry_report", "pers:memberExpiry:report", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persExpiryMemberReport.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersMemberExpiryReportRefresh", "common_op_refresh", "pers:memberExpiry:report:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersMemberExpiryReportExpNotification", "pers_send_expiry_notification", "pers:memberExpiry:report:expNotification", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersMemberRenewalReport", "pers_memberRenewal_report", "pers:memberRenewal:report", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persMembershipRenewal.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersMemberRenewalReportRefresh", "common_op_refresh", "pers:memberRenewal:report:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PersCardManager", "pers_card_manager", "pers:card:manager", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("persCard.do");
        subMenuItem1.setImg("pers_card.png");
        subMenuItem1.setImgHover("pers_card_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PersCard", "pers_card", "pers:card", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persCard.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersCardRefresh", "common_op_refresh", "pers:card:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersCardBatchIssueCard", "pers_batchIssCard_entity", "pers:card:batchIssueCard", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersCardLoss", "pers_lossCard_entity", "pers:card:batchCardLoss", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersCardRevert", "pers_revertCard_entity", "pers:card:batchCardRevert", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersCardExport", "common_op_export", "pers:card:export", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersWiegandFmtItem", "pers_wiegandFmt", "pers:wiegandFmt", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persWiegandFmt.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemRefresh", "common_op_refresh", "pers:wiegandFmt:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemAdd", "common_op_new", "pers:wiegandFmt:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemDel", "common_op_del", "pers:wiegandFmt:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemTest", "pers_wgFmt_cardFormatTesting", "pers:wiegandFmt:test", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemEdit", "common_op_edit", "pers:wiegandFmt:edit", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersCardIssue", "pers_card_issue", "pers:issueCard", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persIssueCard.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersCardIssueRefresh", "common_op_refresh", "pers:issueCard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersCardIssueExport", "common_op_export", "pers:issueCard:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    public void initPersWiegandFmtItem() {
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wiegandFmt_isDefaultFmt", (Object[])new Object[0]), Short.valueOf((short)0), Short.valueOf((short)0), "", "", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "26", Short.valueOf((short)1), Short.valueOf((short)26), "pccccccccccccccccccccccccp", "eeeeeeeeeeeeeooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "26a", Short.valueOf((short)1), Short.valueOf((short)26), "pssssssssccccccccccccccccp", "eeeeeeeeeeeeeooooooooooooo", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "34", Short.valueOf((short)1), Short.valueOf((short)34), "pccccccccccccccccccccccccccccccccp", "eeeeeeeeeeeeeeeeeooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "34a", Short.valueOf((short)1), Short.valueOf((short)34), "pssssssssssssssssccccccccccccccccp", "eeeeeeeeeeeeeeeeeooooooooooooooooo", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "36", Short.valueOf((short)1), Short.valueOf((short)36), "pssssssssssssssssccccccccccccccccccp", "oooooooooooooooeeeeeeeeeeeeeeeeeeeee", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "37", Short.valueOf((short)1), Short.valueOf((short)37), "psssssssssssssssscccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeboooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "37a", Short.valueOf((short)1), Short.valueOf((short)37), "pmmmmsssssssssssscccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeooooooooooooooooooo", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "50", Short.valueOf((short)1), Short.valueOf((short)50), "pssssssssssssssssccccccccccccccccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeeeeeeeeooooooooooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(String.valueOf(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0])) + "66", Short.valueOf((short)1), Short.valueOf((short)66), "pccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooooooooooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
    }

    public void initPersParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("pers.userDataFolder.photo", "/pers/photo", "\u4eba\u5458\u7167\u7247"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.personSupportFakeDel", "true", "\u662f\u5426\u652f\u6301\u5047\u5220"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinLen", "9", "pin\u7684\u957f\u5ea6"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinSupportLetter", "false", "\u62fc\u53f7\u662f\u5426\u652f\u6301\u5b57\u6bcd"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinSupportDefault", "false", "pin\u53f7\u662f\u5426\u9ed8\u8ba4"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinSupportIncrement", "true", "pin\u53f7\u662f\u5426\u81ea\u52a8\u589e\u957f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardLen", "32", "\u5361\u53f7\u957f\u5ea6\uff0c\u9ed8\u8ba432\u4f4d"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.siteCodeLen", "20", "siteCode\u7684\u957f\u5ea6"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardSupportLetter", "false", "\u5361\u53f7\u662f\u5426\u652f\u6301\u5b57\u6bcd"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.readIdCard", "false", "\u5237\u8eab\u4efd\u8bc1"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.physicalNoToCardNo", "false", "\u8eab\u4efd\u8bc1\u7269\u7406\u5361\u53f7\u5f53\u5361\u53f7"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardHex", "0", "\u5361\u8fdb\u5236\u663e\u793a 0\uff1a\u4e3a\u5341\u8fdb\u5236\u30011\uff1a\u4e3a\u5341\u516d\u8fdb\u5236"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.showDept", "true", "\u662f\u5426\u663e\u793a\u4eba\u5458\u548c\u90e8\u95e8\u7684\u90e8\u95e8\u6811"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardTempalteCode", "default", "\u9ed8\u8ba4\u5236\u5361\u6a21\u677f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardsSupport", "false", "\u662f\u5426\u652f\u6301\u591a\u5361"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardsReadMode", "1", "\u5361\u53f7\u8bfb\u53d6\u65b9\u5f0f 1\uff1a\u63a7\u5236\u5668\u8bfb\u5934\u30012\uff1aID180\uff08\u8bfb\u8eab\u4efd\u8bc1\u7269\u7406\u5361\u53f7\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.IDReadMode", "1", "\u8eab\u4efd\u8bc1\u8bfb\u5934\u65b9\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.ocrDriveVerson", "2", "ocr\u9a71\u52a8\u7248\u672c"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinRetain", "true", "\u79bb\u804c\u4eba\u5458\u662f\u5426\u4fdd\u7559\u7f16\u53f7"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.employeeRegistrar", "true", "\u662f\u5426\u542f\u7528\u5458\u5de5\u767b\u8bb0"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.tempPerson.audit", "1", "\u662f\u5426\u76f4\u63a5\u5ba1\u6838\u901a\u8fc7"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.ocrCertNoType", "1", "ocr\u56de\u586b\u8bc1\u4ef6\u53f7\u7801\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.tempPerson.urlCreate", "", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.selfRegistration", "1", "\u542f\u7528\u81ea\u52a9\u767b\u8bb0"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.name.encryptProp", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.name.encryptMode", "S1", "\u59d3\u540d\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.lastName.encryptProp", "true", "\u59d3\u6c0f\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.lastName.encryptMode", "S1", "\u59d3\u6c0f\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.mobilePhone.encryptProp", "true", "\u624b\u673a\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.mobilePhone.encryptMode", "S2", "\u624b\u673a\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.gender.encryptProp", "true", "\u6027\u522b\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.gender.encryptMode", "S0F1", "\u6027\u522b\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.certNumber.encryptProp", "true", "\u8bc1\u4ef6\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.certNumber.encryptMode", "S2", "\u8bc1\u4ef6\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.birthday.encryptProp", "true", "\u51fa\u751f\u65e5\u671f\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.birthday.encryptMode", "S2", "\u51fa\u751f\u65e5\u671f\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.email.encryptProp", "true", "\u90ae\u7bb1\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.email.encryptMode", "S2", "\u90ae\u7bb1\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.carPlate.encryptProp", "true", "\u8f66\u724c\u53f7\u7801\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.carPlate.encryptMode", "S2", "\u8f66\u724c\u53f7\u7801\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pin.encryptProp", "true", "\u7f16\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pin.encryptMode", "S2", "\u7f16\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardNo.encryptProp", "true", "\u5361\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardNo.encryptMode", "S2", "\u5361\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.headPortrait.encryptProp", "true", "\u5934\u50cf\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.bioPhoto.encryptProp", "true", "\u6bd4\u5bf9\u7167\u7247\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.userId", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.name", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.lastName", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.membershipPlan", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.totalAmount", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.paidAmount", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.dueAmount", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.paymentDate", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.trainer", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.trainerPlan", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.paymentMode", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.auto.invoice", "1", "\u542f\u7528\u81ea\u52a9\u767b\u8bb0"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.auto.invoiceMethod", "0", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.daysToExpiry", "7", "\u5b9e\u65f6\u76d1\u63a7\u9875\u9762\u5f39\u51fa\u4eba\u5458\u7167\u7247\u5927\u5c0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.member.expiryMethod", "0", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.days.newMembers", "7", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.header", "Welcome To Easy GymFit", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.invoice.footer", "Thanks for Visiting", "\u4e8c\u7ef4\u7801url"));
        this.persCacheManager.setAutoInquiryPin("0");
        this.baseSysParamService.initData(new BaseSysParamItem("pers.qrCodeUPI.photo", "", "QRCodeUPI"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.dayFrequencyHour", "24", "Hour"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.dayFrequencyMinute", "60", "Hour"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.persexpireMemberCron", "", "notification for expire members"));
    }

    public void initPrintTemplate() {
        BasePrintTemplateItem basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_persDefalut", (Object[])new Object[0]), String.valueOf(BasePrintTemplateConstants.TEMPLATE_VERTICAL_DEFAULT) + this.language, Integer.valueOf(635), Integer.valueOf(1010), "pers", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_VERTICAL), Boolean.valueOf(true)));
        this.initVerticalPrintParam(basePrintTemplateItem.getId());
        basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_persDefalutHZ", (Object[])new Object[0]), String.valueOf(BasePrintTemplateConstants.TEMPLATE_HORIZONTAL_DEFAULT) + this.language, Integer.valueOf(1010), Integer.valueOf(635), "pers", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_HORIZONTAL), Boolean.valueOf(true)));
        this.initHorizontalPrintParam(basePrintTemplateItem.getId());
    }

    private void initVerticalPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        if (!this.language.equalsIgnoreCase("zh_CN")) {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "635", "1010", "background", "/images/printTemplate/defaultTempUS_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "635", "1010", "background", "/images/printTemplate/verticalUS_opposite.jpg"));
        } else {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "635", "1010", "background", "/images/printTemplate/defaultTemp_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "635", "1010", "background", "/images/printTemplate/vertical_opposite.jpg"));
        }
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.photo", "100px", "140px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.name", "122px", "313px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_wholeName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.department", "122px", "350px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_dept", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.pin", "122px", "385px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.entryDate", "122px", "420px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_entryDate", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initHorizontalPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        if (!this.language.equalsIgnoreCase("zh_CN")) {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "1010", "635", "background", "/images/printTemplate/defaultTempHUS_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "1010", "635", "background", "/images/printTemplate/horizontalUS_opposite.jpg"));
        } else {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "1010", "635", "background", "/images/printTemplate/defaultTempH_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "1010", "635", "background", "/images/printTemplate/horizontal_opposite.jpg"));
        }
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.photo", "50px", "130px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.name", "282px", "142px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_wholeName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.department", "282px", "177px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_dept", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.pin", "282px", "212px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.entryDate", "282px", "247px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_entryDate", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initAppMenus() {
        AuthPermissionItem appModuleItem = null;
        AuthPermissionItem appMenuItem = null;
        AuthPermissionItem appButtonItem = null;
        appModuleItem = this.authPermissionService.getItemByCode("App");
        if (appModuleItem == null) {
            appModuleItem = new AuthPermissionItem("App", "app_module", "app", "app_system", "true", Integer.valueOf(998));
            this.authPermissionService.initData(appModuleItem);
        }
        appMenuItem = new AuthPermissionItem("AppPers", "app_pers", "app:APPpers", "app_menu", "true", Integer.valueOf(1));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("AppPersList", "app_pers_list", "app:APPpersList", "app_button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppPersAdd", "app_pers_add", "app:APPpersAdd", "app_button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppPersSet", "app_pers_set", "app:APPpersSet", "app_button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"pers");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("PersUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("PersUpgradeVersion", curVersion, "Pers Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }

    public void initPersonnalList() {
        this.persPersonnalListService.initData(new PersPersonnalListItem(I18nUtil.i18nCode((String)"pers_personnal_passList", (Object[])new Object[0]), "3", Boolean.valueOf(true)));
        this.persPersonnalListService.initData(new PersPersonnalListItem(I18nUtil.i18nCode((String)"pers_personnal_banList", (Object[])new Object[0]), "2", Boolean.valueOf(true)));
    }

    public void initPersUserType() {
        PersUserTypeItem persUserTypeItem = new PersUserTypeItem("1", I18nUtil.i18nCode((String)"pers_userType_staff", (Object[])new Object[0]));
        this.persUserTypeService.initData(persUserTypeItem);
        PersUserTypeItem persUserTypeItem1 = new PersUserTypeItem("2", I18nUtil.i18nCode((String)"pers_userType_trainer", (Object[])new Object[0]));
        this.persUserTypeService.initData(persUserTypeItem1);
        PersUserTypeItem persUserTypeItem2 = new PersUserTypeItem("3", I18nUtil.i18nCode((String)"pers_userType_member", (Object[])new Object[0]));
        this.persUserTypeService.initData(persUserTypeItem2);
    }
}

