/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolRouteTotalRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolRouteService;
import com.zkteco.zkbiosecurity.patrol.service.PatrolTotalService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolRouteTotalItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolRouteTotalController
extends ExportController
implements PatrolRouteTotalRemote {
    @Autowired
    private PatrolTotalService patrolTotalService;
    @Autowired
    private PatrolRouteService patrolRouteService;

    @RequiresPermissions(value={"patrol:route:total"})
    public ModelAndView index() {
        return new ModelAndView("patrol/total/patrolRouteTotal");
    }

    @RequiresPermissions(value={"patrol:routeTotal:refresh"})
    public DxGrid list(PatrolRouteTotalItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.patrolTotalService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        List items = pager.getData();
        for (PatrolRouteTotalItem item : items) {
            if (!StringUtils.isNotBlank((CharSequence)item.getPin())) continue;
            item.setPatrolPersons(this.patrolRouteService.getEntryValue(item.getPatrolPersons(), "pers.name.encryptProp", "pers.name.encryptMode"));
        }
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"patrol:routeTotal:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PatrolRouteTotalItem patrolRouteTotalItem = new PatrolRouteTotalItem();
        this.setConditionValue((BaseItem)patrolRouteTotalItem);
        List intemList = this.patrolTotalService.getItemData(PatrolRouteTotalItem.class, (BaseItem)patrolRouteTotalItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, PatrolRouteTotalItem.class);
    }
}

