/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolPlanRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolPlanService;
import com.zkteco.zkbiosecurity.patrol.service.PatrolShiftService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolPlanItem;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolShiftItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolPlanController
extends BaseController
implements PatrolPlanRemote {
    @Autowired
    private PatrolPlanService patrolPlanService;
    @Autowired
    private PatrolShiftService patrolShiftService;

    @RequiresPermissions(value={"patrol:plan"})
    public ModelAndView index() {
        return new ModelAndView("patrol/plan/patrolPlan");
    }

    @RequiresPermissions(value={"patrol:plan:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List patrolShiftItems = this.patrolShiftService.getPatrolShiftByPlanId(id);
            TreeMap<String, PatrolShiftItem> tempPatrolShiftMap = new TreeMap<String, PatrolShiftItem>();
            int index = 1;
            for (PatrolShiftItem patrolShiftItem : patrolShiftItems) {
                tempPatrolShiftMap.put("key" + index, patrolShiftItem);
                ++index;
            }
            this.request.setAttribute("tempPatrolShiftMap", tempPatrolShiftMap);
            this.request.setAttribute("item", (Object)this.patrolPlanService.getItemById(id));
        }
        return new ModelAndView("patrol/plan/editPatrolPlan");
    }

    @RequiresPermissions(value={"patrol:plan:edit"})
    @LogRequest(module="patrol_module", object="patrol_plan_entity", opType="common_op_edit", requestParams={"name"}, opContent="common_op_edit")
    public ZKResultMsg save(PatrolPlanItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getId()) && !this.patrolPlanService.validatePlanIsUsed(item.getId())) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"patrol_plan_warnEditPlan", (Object[])new Object[0]));
        }
        this.patrolPlanService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"patrol:plan:refresh"})
    public DxGrid list(PatrolPlanItem condition) {
        Pager pager = this.patrolPlanService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:plan:del"})
    @LogRequest(module="patrol_module", object="patrol_plan_entity", opType="common_op_del", requestParams={"name"}, opContent="common_op_del")
    public ZKResultMsg del(String ids) {
        this.patrolPlanService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        PatrolPlanItem item = this.patrolPlanService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getAllValidPlans() {
        String planId = StringUtils.isNotEmpty((CharSequence)this.request.getParameter("planId")) ? this.request.getParameter("planId") : "-1";
        JSONArray result = new JSONArray();
        List patrolPlanItems = this.patrolPlanService.getAllValidPlans(planId);
        for (PatrolPlanItem patrolPlanItem : patrolPlanItems) {
            JSONObject obj = new JSONObject();
            obj.put("patrolPlanId", (Object)patrolPlanItem.getId());
            obj.put("planName", (Object)patrolPlanItem.getName());
            obj.put("disabled", (Object)patrolPlanItem.getExpired());
            result.add((Object)obj);
        }
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)result);
        return zkResultMsg;
    }

    public ZKResultMsg getAllValidPlansByPlanId(String planId) {
        List patrolPlanItems = this.patrolPlanService.getAllValidPlans(planId);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (PatrolPlanItem patrolPlanItem : patrolPlanItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(patrolPlanItem.getId());
            selectItem.setText((Object)patrolPlanItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }
}

