/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolPersonTotalRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolTotalService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolPersonTotalItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolPersonTotalController
extends ExportController
implements PatrolPersonTotalRemote {
    @Autowired
    private PatrolTotalService patrolTotalService;

    @RequiresPermissions(value={"patrol:person:total"})
    public ModelAndView index() {
        return new ModelAndView("patrol/total/patrolPersonTotal");
    }

    @RequiresPermissions(value={"patrol:personTotal:refresh"})
    public DxGrid list(PatrolPersonTotalItem condition) {
        long limit = this.getLimitCount();
        Pager pager = this.patrolTotalService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), limit);
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"patrol:personTotal:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PatrolPersonTotalItem patrolPersonTotalItem = new PatrolPersonTotalItem();
        this.setConditionValue((BaseItem)patrolPersonTotalItem);
        List intemList = this.patrolTotalService.getItemData(PatrolPersonTotalItem.class, (BaseItem)patrolPersonTotalItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, PatrolPersonTotalItem.class);
    }
}

