/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolGroupRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolGroupService;
import com.zkteco.zkbiosecurity.patrol.service.PatrolPersonSelectService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolGroupItem;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolGroupPersonItem;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolGroupSelectItem;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolPersonSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolGroupController
extends BaseController
implements PatrolGroupRemote {
    @Autowired
    private PatrolGroupService patrolGroupService;
    @Autowired
    private PatrolPersonSelectService patrolPersonSelectService;

    @RequiresPermissions(value={"patrol:group"})
    public ModelAndView index() {
        return new ModelAndView("patrol/group/patrolGroup");
    }

    @RequiresPermissions(value={"patrol:group:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.patrolGroupService.getItemById(id));
        }
        return new ModelAndView("patrol/group/editPatrolGroup");
    }

    @RequiresPermissions(value={"patrol:group:edit"})
    @LogRequest(module="patrol_module", object="patrol_route_patrolGroup", opType="common_op_edit", requestParams={"name"}, opContent="common_op_edit")
    public ZKResultMsg save(PatrolGroupItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            this.patrolGroupService.patrolGroupIsUsed(item.getId());
        }
        this.patrolGroupService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"patrol:group:refresh"})
    public DxGrid list(PatrolGroupItem condition) {
        Pager pager = this.patrolGroupService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:group:del"})
    @LogRequest(module="patrol_module", object="patrol_route_patrolGroup", opType="common_op_del", requestParams={"name"}, opContent="common_op_del")
    public ZKResultMsg del(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.patrolGroupService.patrolGroupIsUsed(ids);
            this.patrolGroupService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        PatrolGroupItem item = this.patrolGroupService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    @LogRequest(module="patrol_module", object="patrol_route_patrolPerson", opType="common_op_add", requestParams={"groupName", "personPins"}, opContent="common_op_add")
    public ZKResultMsg addPerson() {
        String groupId = this.request.getParameter("patrolGroupId");
        String personIds = this.request.getParameter("persIds");
        String deptIds = this.request.getParameter("deptIds");
        String checkVal = this.request.getParameter("checkVal");
        if ("2".equals(checkVal) && StringUtils.isNotBlank((CharSequence)deptIds)) {
            PatrolPersonSelectItem patrolPersonSelectItem = new PatrolPersonSelectItem();
            patrolPersonSelectItem.setInDeptId(deptIds);
            patrolPersonSelectItem.setNotInGroupId(groupId);
            personIds = this.patrolGroupService.getPersonIdsByCondition(patrolPersonSelectItem);
        }
        if (StringUtils.isNotBlank((CharSequence)personIds) && StringUtils.isNotBlank((CharSequence)groupId)) {
            this.patrolGroupService.addPerson(personIds, groupId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"patrol:group:delPerson"})
    @LogRequest(module="patrol_module", object="patrol_route_patrolPerson", opType="common_op_del", requestParams={"groupName", "patrolPersonIds"}, opContent="common_op_del")
    public ZKResultMsg delPerson() {
        String groupId = this.request.getParameter("groupId");
        this.patrolGroupService.patrolGroupIsUsed(groupId);
        String patrolPersonIds = this.request.getParameter("patrolPersonIds");
        this.patrolGroupService.delPerson(groupId, patrolPersonIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid groupSelectList(PatrolGroupSelectItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectGroupIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectGroupIdsIn(condition.getSelectId());
        }
        Pager pager = this.patrolGroupService.getGroupSelectItemsByPage(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:group:refreshPerson"})
    public DxGrid patrolGroupPersonList(PatrolGroupPersonItem condition) {
        Pager pager = this.patrolGroupService.getGroupPersonItems(condition, this.request.getSession().getId(), this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg patrolGroupIsUsed(String id) {
        this.patrolGroupService.patrolGroupIsUsed(id);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkGroupPersonCount(String groupId) {
        this.patrolGroupService.checkGroupPersonCount(groupId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getPersonCountByDeptIds(String deptIds) {
        int personCount = this.patrolGroupService.getPersonCountByDeptIds(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }
}

