/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SecureKey;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAndHashAlgorithm;

final class SSLSessionImpl
extends ExtendedSSLSession {
    private static final byte compression_null = 0;
    private final ProtocolVersion protocolVersion;
    private final SessionId sessionId;
    private java.security.cert.X509Certificate[] peerCerts;
    private byte compressionMethod;
    private CipherSuite cipherSuite;
    private SecretKey masterSecret;
    private final boolean useExtendedMasterSecret;
    private final long creationTime = System.currentTimeMillis();
    private long lastUsedTime = 0L;
    private final String host;
    private final int port;
    private SSLSessionContextImpl context;
    private int sessionCount;
    private boolean invalidated;
    private java.security.cert.X509Certificate[] localCerts;
    private PrivateKey localPrivateKey;
    private String[] localSupportedSignAlgs;
    private String[] peerSupportedSignAlgs;
    private List<SNIServerName> requestedServerNames;
    private Principal peerPrincipal;
    private Principal localPrincipal;
    private final String endpointIdentificationAlgorithm;
    private boolean isSessionResumption = false;
    private static volatile int counter = 0;
    private static boolean defaultRejoinable = true;
    private static final Debug debug = Debug.getInstance("ssl");
    private Hashtable<SecureKey, Object> table = new Hashtable();
    private boolean acceptLargeFragments = Debug.getBooleanProperty("jsse.SSLEngine.acceptLargeFragments", false);

    SSLSessionImpl() {
        this(ProtocolVersion.NONE, CipherSuite.C_NULL, null, new SessionId(false, null), null, -1, false, null);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, Collection<SignatureAndHashAlgorithm> algorithms, SecureRandom generator, String host, int port, boolean useExtendedMasterSecret, String endpointIdAlgorithm) {
        this(protocolVersion, cipherSuite, algorithms, new SessionId(defaultRejoinable, generator), host, port, useExtendedMasterSecret, endpointIdAlgorithm);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, Collection<SignatureAndHashAlgorithm> algorithms, SessionId id, String host, int port, boolean useExtendedMasterSecret, String endpointIdAlgorithm) {
        this.protocolVersion = protocolVersion;
        this.sessionId = id;
        this.peerCerts = null;
        this.compressionMethod = 0;
        this.cipherSuite = cipherSuite;
        this.masterSecret = null;
        this.host = host;
        this.port = port;
        this.sessionCount = ++counter;
        this.localSupportedSignAlgs = SignatureAndHashAlgorithm.getAlgorithmNames(algorithms);
        this.useExtendedMasterSecret = useExtendedMasterSecret;
        this.endpointIdentificationAlgorithm = endpointIdAlgorithm;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Initialized:  " + this);
        }
    }

    void setMasterSecret(SecretKey secret) {
        if (this.masterSecret != null) {
            throw new RuntimeException("setMasterSecret() error");
        }
        this.masterSecret = secret;
    }

    SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    boolean getUseExtendedMasterSecret() {
        return this.useExtendedMasterSecret;
    }

    void setPeerCertificates(java.security.cert.X509Certificate[] peer) {
        if (this.peerCerts == null) {
            this.peerCerts = peer;
        }
    }

    void setLocalCertificates(java.security.cert.X509Certificate[] local) {
        this.localCerts = local;
    }

    void setLocalPrivateKey(PrivateKey privateKey) {
        this.localPrivateKey = privateKey;
    }

    void setPeerSupportedSignatureAlgorithms(Collection<SignatureAndHashAlgorithm> algorithms) {
        this.peerSupportedSignAlgs = SignatureAndHashAlgorithm.getAlgorithmNames(algorithms);
    }

    void setRequestedServerNames(List<SNIServerName> requestedServerNames) {
        this.requestedServerNames = new ArrayList<SNIServerName>(requestedServerNames);
    }

    void setPeerPrincipal(Principal principal) {
        if (this.peerPrincipal == null) {
            this.peerPrincipal = principal;
        }
    }

    void setLocalPrincipal(Principal principal) {
        this.localPrincipal = principal;
    }

    String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    boolean isRejoinable() {
        return this.sessionId != null && this.sessionId.length() != 0 && !this.invalidated && this.isLocalAuthenticationValid();
    }

    @Override
    public synchronized boolean isValid() {
        return this.isRejoinable();
    }

    boolean isLocalAuthenticationValid() {
        if (this.localPrivateKey != null) {
            try {
                this.localPrivateKey.getAlgorithm();
            }
            catch (Exception e) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] getId() {
        return this.sessionId.getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    SessionId getSessionId() {
        return this.sessionId;
    }

    CipherSuite getSuite() {
        return this.cipherSuite;
    }

    void setSuite(CipherSuite suite) {
        this.cipherSuite = suite;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Negotiating:  " + this);
        }
    }

    boolean isSessionResumption() {
        return this.isSessionResumption;
    }

    void setAsSessionResumption(boolean flag) {
        this.isSessionResumption = flag;
    }

    @Override
    public String getCipherSuite() {
        return this.getSuite().name;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.getProtocolVersion().name;
    }

    byte getCompression() {
        return this.compressionMethod;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SSLSessionImpl) {
            SSLSessionImpl sess = (SSLSessionImpl)obj;
            return this.sessionId != null && this.sessionId.equals(sess.getSessionId());
        }
        return false;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.peerCerts.clone();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCerts == null ? null : (Certificate[])this.localCerts.clone();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] certs = new X509Certificate[this.peerCerts.length];
        for (int i = 0; i < this.peerCerts.length; ++i) {
            byte[] der = null;
            try {
                der = this.peerCerts[i].getEncoded();
                certs[i] = X509Certificate.getInstance(der);
                continue;
            }
            catch (CertificateEncodingException e) {
                throw new SSLPeerUnverifiedException(e.getMessage());
            }
            catch (CertificateException e) {
                throw new SSLPeerUnverifiedException(e.getMessage());
            }
        }
        return certs;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts != null) {
            return (java.security.cert.X509Certificate[])this.peerCerts.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            if (this.peerPrincipal == null) {
                throw new SSLPeerUnverifiedException("peer not authenticated");
            }
            return this.peerPrincipal;
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerCerts[0].getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            return this.localPrincipal == null ? null : this.localPrincipal;
        }
        return this.localCerts == null ? null : this.localCerts[0].getSubjectX500Principal();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastUsedTime != 0L ? this.lastUsedTime : this.creationTime;
    }

    void setLastAccessedTime(long time) {
        this.lastUsedTime = time;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public int getPeerPort() {
        return this.port;
    }

    void setContext(SSLSessionContextImpl ctx) {
        if (this.context == null) {
            this.context = ctx;
        }
    }

    @Override
    public synchronized void invalidate() {
        this.invalidated = true;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.context != null) {
            this.context.remove(this.sessionId);
            this.context = null;
        }
    }

    @Override
    public void putValue(String key, Object value) {
        SSLSessionBindingEvent e;
        if (key == null || value == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        Object oldValue = this.table.put(secureKey, value);
        if (oldValue instanceof SSLSessionBindingListener) {
            e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)oldValue).valueUnbound(e);
        }
        if (value instanceof SSLSessionBindingListener) {
            e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)value).valueBound(e);
        }
    }

    @Override
    public Object getValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        return this.table.get(secureKey);
    }

    @Override
    public void removeValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(key);
        Object value = this.table.remove(secureKey);
        if (value instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent e = new SSLSessionBindingEvent(this, key);
            ((SSLSessionBindingListener)value).valueUnbound(e);
        }
    }

    @Override
    public String[] getValueNames() {
        Vector<Object> v = new Vector<Object>();
        Object securityCtx = SecureKey.getCurrentSecurityContext();
        Enumeration<SecureKey> e = this.table.keys();
        while (e.hasMoreElements()) {
            SecureKey key = e.nextElement();
            if (!securityCtx.equals(key.getSecurityContext())) continue;
            v.addElement(key.getAppKey());
        }
        Object[] names = new String[v.size()];
        v.copyInto(names);
        return names;
    }

    protected synchronized void expandBufferSizes() {
        this.acceptLargeFragments = true;
    }

    @Override
    public synchronized int getPacketBufferSize() {
        return this.acceptLargeFragments ? 33305 : 16921;
    }

    @Override
    public synchronized int getApplicationBufferSize() {
        return this.getPacketBufferSize() - 5;
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        if (this.localSupportedSignAlgs != null) {
            return (String[])this.localSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        if (this.peerSupportedSignAlgs != null) {
            return (String[])this.peerSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public List<SNIServerName> getRequestedServerNames() {
        if (this.requestedServerNames != null && !this.requestedServerNames.isEmpty()) {
            return Collections.unmodifiableList(this.requestedServerNames);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "[Session-" + this.sessionCount + ", " + this.getCipherSuite() + "]";
    }

    protected void finalize() throws Throwable {
        String[] names = this.getValueNames();
        for (int i = 0; i < names.length; ++i) {
            this.removeValue(names[i]);
        }
    }
}

