/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class ALPNExtension
extends HelloExtension {
    static final int ALPN_HEADER_LENGTH = 1;
    static final int MAX_APPLICATION_PROTOCOL_LENGTH = 255;
    static final int MAX_APPLICATION_PROTOCOL_LIST_LENGTH = 65535;
    private int listLength = 0;
    private List<String> protocolNames = null;

    ALPNExtension(String protocolName) throws SSLException {
        this(new String[]{protocolName});
    }

    ALPNExtension(String[] protocolNames) throws SSLException {
        super(ExtensionType.EXT_ALPN);
        if (protocolNames.length == 0) {
            throw new IllegalArgumentException("The list of application protocols cannot be empty");
        }
        this.protocolNames = Arrays.asList(protocolNames);
        for (String p : protocolNames) {
            int length = p.getBytes(StandardCharsets.UTF_8).length;
            if (length == 0) {
                throw new SSLProtocolException("Application protocol name is empty");
            }
            if (length <= 255) {
                this.listLength += length + 1;
            } else {
                throw new SSLProtocolException("Application protocol name is too long: " + p);
            }
            if (this.listLength <= 65535) continue;
            throw new SSLProtocolException("Application protocol name list is too long");
        }
    }

    ALPNExtension(HandshakeInStream s, int len) throws IOException {
        super(ExtensionType.EXT_ALPN);
        int remaining;
        byte[] bytes;
        if (len >= 2) {
            this.listLength = s.getInt16();
            if (this.listLength < 2 || this.listLength + 2 != len) {
                throw new SSLProtocolException("Invalid " + this.type + " extension: incorrect list length (length=" + this.listLength + ")");
            }
        } else {
            throw new SSLProtocolException("Invalid " + this.type + " extension: insufficient data (length=" + len + ")");
        }
        this.protocolNames = new ArrayList<String>();
        for (remaining = this.listLength; remaining > 0; remaining -= bytes.length + 1) {
            bytes = s.getBytes8();
            if (bytes.length == 0) {
                throw new SSLProtocolException("Invalid " + this.type + " extension: empty application protocol name");
            }
            String p = new String(bytes, StandardCharsets.UTF_8);
            this.protocolNames.add(p);
        }
        if (remaining != 0) {
            throw new SSLProtocolException("Invalid " + this.type + " extension: extra data (length=" + remaining + ")");
        }
    }

    List<String> getPeerAPs() {
        return this.protocolNames;
    }

    @Override
    int length() {
        return 6 + this.listLength;
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        s.putInt16(this.type.id);
        s.putInt16(this.listLength + 2);
        s.putInt16(this.listLength);
        for (String p : this.protocolNames) {
            s.putBytes8(p.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.protocolNames == null || this.protocolNames.isEmpty()) {
            sb.append("<empty>");
        } else {
            for (String protocolName : this.protocolNames) {
                sb.append("[" + protocolName + "]");
            }
        }
        return "Extension " + this.type + ", protocol names: " + sb;
    }
}

