/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivideo.remote.IVideoParamsRemote;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoParamsService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IVideoParamsController
extends BaseController
implements IVideoParamsRemote {
    @Autowired
    private IVideoParamsService iVideoParamsService;
    @Autowired
    private IVideoControlEntityService iVideoControlEntityService;

    public ModelAndView index() {
        return null;
    }

    @RequiresPermissions(value={"iVideo:params"})
    public ModelAndView getIVideoParam() {
        Map iVideoParams = this.iVideoParamsService.getIVideoParams();
        String serverType = "";
        if (this.iVideoControlEntityService.isArteco()) {
            serverType = "Arteco";
        } else if (this.iVideoControlEntityService.isC2P()) {
            serverType = "C2P";
        } else if (this.iVideoControlEntityService.isDigifort()) {
            serverType = "Digifort";
        }
        this.request.setAttribute("serverType", (Object)serverType);
        this.request.setAttribute("iVideoParams", (Object)iVideoParams);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("ivideo/params/iVideoParams");
    }

    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        this.iVideoParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg generateToken() {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        String token = this.iVideoParamsService.generateToken();
        resultMsg.setData((Object)token);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

