/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoControlEntityItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/ivideo"})
@Api(tags={"IVideoControlEntity"}, description="ivideo controlEntity")
public class IVideoOperateControlEntityController {
    private static final Logger log = LoggerFactory.getLogger(IVideoOperateControlEntityController.class);
    @Autowired
    private IVideoControlEntityService iVideoControlEntityService;
    @Value(value="${system.data.security-encrypt:false}")
    private boolean isOpenSecurityEncrypt;

    @ApiOperation(value="open arteco controlEntity", notes="Return Acc Device Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/arteco/openControlEntity"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String open(@RequestParam(name="pin") String pin, @RequestParam(name="interval") Integer interval) {
        Integer tempInterval = interval;
        tempInterval = tempInterval == null || tempInterval < 0 ? 5 : tempInterval;
        tempInterval = tempInterval > 255 ? 255 : tempInterval;
        IVideoControlEntityItem item = this.iVideoControlEntityService.getItemByOpenOrClosePinAndEntityClassName(pin, "AccDoor");
        if (item != null) {
            if (tempInterval < 255) {
                this.iVideoControlEntityService.operateDoor("openDoor", String.valueOf(tempInterval), item.getEntityId());
            } else {
                this.iVideoControlEntityService.operateDoor("normalOpenDoor", String.valueOf(tempInterval), item.getEntityId());
            }
        }
        return "true";
    }

    @ResponseBody
    @RequestMapping(value={"/arteco/closeControlEntity"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Remote Close By Id", notes="Return Result Object", produces="text/plain")
    public String close(@RequestParam(name="pin") String pin) {
        IVideoControlEntityItem item = this.iVideoControlEntityService.getItemByOpenOrClosePinAndEntityClassName(pin, "AccDoor");
        if (item != null) {
            this.iVideoControlEntityService.operateDoor("closeDoor", null, item.getEntityId());
        }
        return "true";
    }

    @ApiOperation(value="open arteco controlEntity", notes="Return Acc Device Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/openDoor"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public JSONObject openDoor(@RequestParam(name="json") JSONObject json) {
        JSONObject retJson = new JSONObject();
        String doorName = json.getString("doorName");
        int tempInterval = json.getInteger("interval");
        this.iVideoControlEntityService.openDoor(doorName, tempInterval);
        retJson.put("result", (Object)"true");
        return retJson;
    }

    @ResponseBody
    @RequestMapping(value={"/closeDoor"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Remote Close By Id", notes="Return Result Object", produces="text/plain")
    public JSONObject closeDoor(@RequestParam(name="json") JSONObject json) {
        JSONObject retJson = new JSONObject();
        String doorName = json.getString("doorName");
        this.iVideoControlEntityService.closeDoor(doorName);
        retJson.put("result", (Object)"true");
        return retJson;
    }

    @ResponseBody
    @RequestMapping(value={"/getPhoto"}, method={RequestMethod.GET}, produces={"application/json"})
    public void getCapturePhoto(HttpServletRequest request, HttpServletResponse response) {
        String imgUrl = request.getParameter("imgUrl");
        imgUrl = new File("BioSecurityFile/" + imgUrl).getAbsolutePath();
        if (this.searchFile(imgUrl)) {
            if (this.isOpenSecurityEncrypt) {
                String tempImgUrl = request.getParameter("imgUrl");
                this.readEncryptFile(tempImgUrl, response);
            } else {
                this.readPhotoFile(imgUrl, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPhotoFile(String imgUrl, HttpServletResponse response) {
        FileInputStream hFile = null;
        OutputStream toClient = null;
        try {
            hFile = new FileInputStream(imgUrl);
            int j = 0;
            j = hFile.available();
            byte[] data = new byte[j];
            hFile.read(data);
            toClient = response.getOutputStream();
            toClient.write(data);
            toClient.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            try {
                hFile.close();
                toClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("ivideo read photo File faile" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEncryptFile(String imgUrl, HttpServletResponse response) {
        OutputStream toClient = null;
        try {
            byte[] data = FileEncryptUtil.getDecryptFile((String)imgUrl);
            toClient = response.getOutputStream();
            toClient.write(data);
            toClient.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            try {
                toClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("ivideo read photo File faile" + e);
            }
        }
    }

    private boolean searchFile(String url) {
        Boolean result = false;
        File file = new File(url);
        for (int i = 0; i < 8; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!file.exists()) continue;
            result = true;
            break;
        }
        return result;
    }
}

