/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivideo.remote.IVideoDigifortCameraRemote;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoDigifortCameraService;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorSelectAuxInItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorSelectAuxOutItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorSelectDoorItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoDigifortCameraItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IVideoDigifortCameraController
extends BaseController
implements IVideoDigifortCameraRemote {
    @Autowired
    private IVideoDigifortCameraService iVideoDigifortCameraService;
    @Autowired
    private IVideoControlEntityService iVideoControlEntityService;

    @RequiresPermissions(value={"iVideo:digifortCamera"})
    public ModelAndView index() {
        return new ModelAndView("ivideo/digifort/ivideoDigifortCamera");
    }

    @RequiresPermissions(value={"iVideo:digifortCamera:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.iVideoDigifortCameraService.getItemById(id));
        }
        this.request.setAttribute("serverType", (Object)"digifort");
        return new ModelAndView("ivideo/digifort/editIVideoDigifortCamera");
    }

    @RequiresPermissions(value={"iVideo:digifortCamera:add", "iVideo:digifortCamera:edit"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_digifortCamera", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(IVideoDigifortCameraItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.iVideoDigifortCameraService.saveItem(item);
        return res;
    }

    @RequiresPermissions(value={"iVideo:digifortCamera:refresh"})
    public DxGrid list(IVideoDigifortCameraItem condition) {
        Pager pager = this.iVideoDigifortCameraService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public boolean isExist(IVideoDigifortCameraItem item) {
        String name = this.request.getParameter("name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return this.iVideoDigifortCameraService.isExist(name);
        }
        return true;
    }

    public DxGrid selectAccDoorList(IVideoConnectorSelectDoorItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectDoorIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.iVideoDigifortCameraService.getDoorSelectItemsByPage(this.request.getSession().getId(), condition, selectDoorIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAccAuxInList(IVideoConnectorSelectAuxInItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectAuxInIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.iVideoDigifortCameraService.getAuxInSelectItemsByPage(this.request.getSession().getId(), condition, selectAuxInIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAccAuxOutList(IVideoConnectorSelectAuxOutItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectAuxInIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.iVideoDigifortCameraService.getAuxOutSelectItemsByPage(this.request.getSession().getId(), condition, selectAuxInIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"iVideo:digifortCamera:del"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_digifortCamera", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.iVideoDigifortCameraService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView liveView(String id) {
        IVideoDigifortCameraItem item = this.iVideoDigifortCameraService.getItemById(id);
        this.request.setAttribute("id", (Object)id);
        this.request.setAttribute("cameraName", (Object)item.getName());
        return new ModelAndView("ivideo/digifort/opIVideoDigifortCameraLiveView");
    }

    public ModelAndView editBookmark(String id) {
        IVideoDigifortCameraItem item = this.iVideoDigifortCameraService.getItemById(id);
        this.request.setAttribute("editPage", (Object)true);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("ivideo/digifort/opIVideoDigifortCameraBookmark");
    }

    public ZKResultMsg isCameraWorking(String cameraName) {
        ZKResultMsg res = new ZKResultMsg();
        res.setData((Object)this.iVideoDigifortCameraService.isCameraWorking(cameraName));
        return res;
    }

    public ZKResultMsg getSessionInfo() {
        ZKResultMsg res = new ZKResultMsg();
        res.setData((Object)this.iVideoDigifortCameraService.getSessionInfo());
        return res;
    }

    public ZKResultMsg saveBookMark(IVideoDigifortCameraItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.iVideoDigifortCameraService.saveBookMark(item);
        return res;
    }
}

