/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivideo.remote.IVideoControlEntityRemote;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoChannel2ControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoControlEntityItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IVideoControlEntityController
extends BaseController
implements IVideoControlEntityRemote {
    @Autowired
    private IVideoControlEntityService iVideoControlEntityService;
    @Autowired
    private IVideoChannel2ControlEntityService iVideoChannel2EntityService;

    @RequiresPermissions(value={"iVideo:controlEntity:edit"})
    public ModelAndView edit(String id) {
        IVideoControlEntityItem item = this.iVideoControlEntityService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        boolean hasRelay = this.iVideoControlEntityService.isSupportFun(item.getDevSn(), "~RelayStateFunOn");
        this.request.setAttribute("hasRelay", (Object)hasRelay);
        return new ModelAndView("ivideo/entity/editIVideoControlEntity");
    }

    @RequiresPermissions(value={"iVideo:controlEntity:edit"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="docking_controlEntity_edit", requestParams={"entityName"}, opContent="common_name")
    public ZKResultMsg save(IVideoControlEntityItem item) {
        this.iVideoControlEntityService.saveItem(item);
        return new ZKResultMsg();
    }

    @RequiresPermissions(value={"iVideo:controlEntity:refresh"})
    public DxGrid list(IVideoControlEntityItem condition) {
        Pager pager = this.iVideoControlEntityService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"iVideo:connector:addDoor"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="docking_connector_addDoor", requestParams={"connectorName", "doorNames"}, opContent="common_name")
    public ZKResultMsg addDoor() {
        String connectId = this.request.getParameter("connectId");
        String doorIds = this.request.getParameter("doorIds");
        if (StringUtils.isNotBlank((CharSequence)doorIds) && this.iVideoControlEntityService.checkLicense(doorIds)) {
            this.iVideoControlEntityService.addAccDoor(connectId, doorIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"iVideo:connector:addAuxIn"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="docking_connector_addAuxIn", requestParams={"connectorName", "auxInNames"}, opContent="common_name")
    public ZKResultMsg addAuxIn() {
        String connectId = this.request.getParameter("connectId");
        String auxInIds = this.request.getParameter("auxInIds");
        if (StringUtils.isNotBlank((CharSequence)auxInIds) && this.iVideoControlEntityService.checkLicense(auxInIds)) {
            this.iVideoControlEntityService.addAuxIn(connectId, auxInIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="docking_controlEntity_delete", requestParams={"connectorName", "entityNames"}, opContent="common_name")
    @RequiresPermissions(value={"iVideo:controlEntity:del"})
    public ZKResultMsg delEntity() {
        String connectId = this.request.getParameter("connectId");
        String entityIds = this.request.getParameter("entityIds");
        if (StringUtils.isNotBlank((CharSequence)connectId) && StringUtils.isNotBlank((CharSequence)entityIds)) {
            this.iVideoControlEntityService.deleteByIds(entityIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"iVideo:controlEntity:bindChannel"})
    public ZKResultMsg bindChannel() {
        String entityId = this.request.getParameter("entityId");
        String channelIds = this.request.getParameter("channelIds");
        if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((CharSequence)channelIds)) {
            this.iVideoChannel2EntityService.bindOrUnbindChannel(entityId, channelIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"iVideo:connector:addAuxOut"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="docking_connector_addAuxOut", requestParams={"connectorName", "auxOutNames"}, opContent="common_name")
    public ZKResultMsg addAuxOut() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String connectId = this.request.getParameter("connectId");
        String auxOutIds = this.request.getParameter("auxOutIds");
        if (StringUtils.isNotBlank((CharSequence)auxOutIds) && this.iVideoControlEntityService.checkLicense(auxOutIds)) {
            this.iVideoControlEntityService.addAuxOut(connectId, auxOutIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public boolean isArteco() {
        return this.iVideoControlEntityService.isArteco();
    }
}

