/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivideo.remote.IVideoConnectorRemote;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoConnectorService;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorSelectAuxInItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorSelectAuxOutItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoConnectorSelectDoorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IVideoConnectorController
extends BaseController
implements IVideoConnectorRemote {
    @Autowired
    private IVideoConnectorService iVideoConnectorService;
    @Autowired
    private IVideoControlEntityService iVideoControlEntityService;

    @RequiresPermissions(value={"iVideo:connector"})
    public ModelAndView index() {
        return new ModelAndView("ivideo/connector/ivideoConnector");
    }

    @RequiresPermissions(value={"iVideo:connector:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.iVideoConnectorService.getItemById(id));
        }
        String serverType = "";
        if (this.iVideoControlEntityService.isArteco()) {
            serverType = "Arteco";
        } else if (this.iVideoControlEntityService.isC2P()) {
            serverType = "C2P";
        }
        this.request.setAttribute("serverType", (Object)serverType);
        return new ModelAndView("ivideo/connector/editIVideoConnector");
    }

    @RequiresPermissions(value={"iVideo:connector:add", "iVideo:connector:edit"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(IVideoConnectorItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.iVideoConnectorService.saveItem(item);
        return res;
    }

    @RequiresPermissions(value={"iVideo:connector:refresh"})
    public DxGrid list(IVideoConnectorItem condition) {
        Pager pager = this.iVideoConnectorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public boolean isExist(IVideoConnectorItem item) {
        String name = this.request.getParameter("name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return this.iVideoConnectorService.isExist(name);
        }
        return true;
    }

    public boolean isExistConnectorId(IVideoConnectorItem item) {
        String connectorId = this.request.getParameter("connectorId");
        if (StringUtils.isNotBlank((CharSequence)connectorId)) {
            return this.iVideoConnectorService.isExistConnectorId(connectorId);
        }
        return true;
    }

    public DxGrid selectAccDoorList(IVideoConnectorSelectDoorItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectDoorIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.iVideoConnectorService.getDoorSelectItemsByPage(this.request.getSession().getId(), condition, selectDoorIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAccAuxInList(IVideoConnectorSelectAuxInItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectAuxInIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.iVideoConnectorService.getAuxInSelectItemsByPage(this.request.getSession().getId(), condition, selectAuxInIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAccAuxOutList(IVideoConnectorSelectAuxOutItem condition) {
        Pager pager = new Pager();
        ArrayList<String> selectAuxInIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            pager = this.iVideoConnectorService.getAuxOutSelectItemsByPage(this.request.getSession().getId(), condition, selectAuxInIds, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"iVideo:connector:del"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_connector", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.iVideoConnectorService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

