/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivideo.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivideo.remote.IVideoChannelRemote;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoChannel2ControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoChannelService;
import com.zkteco.zkbiosecurity.ivideo.service.IVideoControlEntityService;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoChannelItem;
import com.zkteco.zkbiosecurity.ivideo.vo.IVideoControlEntityItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IVideoChannelController
extends BaseController
implements IVideoChannelRemote {
    @Autowired
    private IVideoChannelService iVideoChannelService;
    @Autowired
    private IVideoControlEntityService iVideoControlEntityService;
    @Autowired
    private IVideoChannel2ControlEntityService channel2EntityService;

    @RequiresPermissions(value={"iVideo:channel"})
    public ModelAndView index() {
        return new ModelAndView("ivideo/channel/iVideoChannel");
    }

    @RequiresPermissions(value={"iVideo:channel:refresh"})
    public DxGrid list(IVideoChannelItem condition) {
        Pager pager = this.iVideoChannelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"iVideo:channel:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.iVideoChannelService.getItemById(id));
        }
        return new ModelAndView("ivideo/channel/editIVideoChannel");
    }

    @RequiresPermissions(value={"iVideo:channel:add", "iVideo:channel:edit"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_vidChannel", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(IVideoChannelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.iVideoChannelService.saveItem(item);
        return res;
    }

    public boolean isExist(IVideoChannelItem item) {
        String name = this.request.getParameter("name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return this.iVideoChannelService.isExist(name);
        }
        return true;
    }

    public boolean isExistCameraId(IVideoChannelItem item) {
        String cameraId = this.request.getParameter("cameraId");
        if (StringUtils.isNotBlank((CharSequence)cameraId)) {
            return this.iVideoChannelService.isExistCameraId(cameraId);
        }
        return true;
    }

    @RequiresPermissions(value={"iVideo:channel:del"})
    @LogRequest(module="docking_third_party", object="docking_leftMenu_vidChannel", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.iVideoChannelService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        IVideoControlEntityItem controlEntityItem = this.iVideoControlEntityService.getItemById(entityId);
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)controlEntityItem.getEntityName());
        List channel2EntityIds = this.channel2EntityService.getBindChannelIdsByEntityId(entityId);
        this.request.setAttribute("value", (Object)StringUtils.join((Object[])channel2EntityIds.toArray(), (String)","));
        return new ModelAndView("ivideo/channel/iVideoChannelSelectContent");
    }
}

