/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.license.init;

import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.dll.LibraryService;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.biz.LicenseFileBiz;
import com.zkteco.zkbiosecurity.guard.license.bean.LicInfo;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.guard.license.util.LicCheckUtil2;
import com.zkteco.zkbiosecurity.guard.license.util.LicFileHelper;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class LicenseInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(LicenseInit.class);
    @Autowired
    private AuthInitDataProvider authInitDataProvider;
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.installDate}")
    private String installDate;
    @Value(value="${system.key}")
    private String systemKey;
    @Value(value="${system.devMode}")
    private String devMode;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.oem}")
    private String systemOem;
    @Value(value="${system.trialDays:}")
    private String trialDays;
    @Autowired
    private LibraryService libraryService;
    @Autowired(required=false)
    private LicenseCheckInnerInvoke[] licenseCheckInnerInvoke;
    @Autowired(required=false)
    private BaseLicenseProvider baseLicenseProvider;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private LicenseFileBiz licenseFileBiz;

    public void run(String ... args) throws Exception {
        ModuleCode.installDate = this.installDate;
        ModuleCode.language = this.language;
        ModuleCode.systemKey = this.systemKey;
        ModuleCode.devMode = this.devMode;
        ModuleCode.productCode = this.productCode;
        ModuleCode.systemOem = this.systemOem;
        ModuleCode.trialDays = this.trialDays;
        if (SystemOsUtil.isWindow()) {
            this.libraryService.loadLibrary("license/zklicclient");
        } else if (SystemOsUtil.isLinux()) {
            this.libraryService.loadLibrary("zklicclient");
        }
        this.ckeckProductCode();
        LicenseUtil.initLicense((IModuleAuth[])this.moduleAuths);
        LicenseUtil.licenseCheckExpired((LicenseCheckInnerInvoke[])this.licenseCheckInnerInvoke);
        this.launchWebsocket();
    }

    private void ckeckProductCode() {
        if ("ZKBioCVSecurity".equals(this.productCode) && this.getLicFileProductCod() == 8) {
            log.warn("Upgrading from ZKBioAccess to ZKBioCVSecurity products! cancelLicense");
            this.licenseFileBiz.cancelLicense();
        }
    }

    private int getLicFileProductCod() {
        LicInfo licInfoRece = new LicInfo();
        String path = ClassUtil.getRootPath() + "/license/biosecurity.lic";
        List modules = LicFileHelper.readLicModules((String)path);
        licInfoRece.setModules(modules);
        LicModule module = null;
        ModuleBean bean = null;
        if (modules != null) {
            for (int i = 0; i < modules.size(); ++i) {
                module = (LicModule)modules.get(i);
                if (!(module.getLicenseNumber() != null && !"".equals(module.getLicenseNumber()) ? (bean = LicCheckUtil2.getModuleBeanByNum((String)module.getLicenseNumber(), (boolean)false)) != null : module.getSerialNumber() != null && !"".equals(module.getSerialNumber()) && (bean = LicCheckUtil2.getModuleBeanByNum((String)module.getSerialNumber(), (boolean)true)) != null)) continue;
                return bean.getProductCode();
            }
        }
        return 5;
    }

    private void launchWebsocket() {
        String licenseId = this.baseLicenseProvider.getLicenseId();
        if (StringUtils.isNotBlank((CharSequence)licenseId)) {
            this.baseLicenseClientService.reconnectionWebsocket();
        } else {
            log.info("LicenseId is null,so can not start  cloud websocket!");
        }
    }
}

