/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.guard.license.util.LicFileHelper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class LicResetUtil {
    private static final Logger log = LoggerFactory.getLogger(LicResetUtil.class);

    public static boolean checkLicenseIsDisable(String licId, String flag, String licenseNumber) {
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{licId, licenseNumber, flag})) {
            if (flag.contains("_RESETFILE")) {
                return true;
            }
            String licenseId = flag.split("_")[0];
            if (!licId.equals(licenseId)) {
                return true;
            }
            Preferences root = Preferences.userNodeForPackage(LicResetUtil.class);
            byte[] lics = root.getByteArray(flag, "default".getBytes(StandardCharsets.UTF_8));
            String licStr = new String(lics);
            if (licStr.contains(licenseNumber)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkLicenseIsDisable(String licId, String flag) {
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{licId, flag})) {
            if (flag.contains("_RESETFILE")) {
                return true;
            }
            String licenseId = flag.split("_")[0];
            if (!licId.equals(licenseId)) {
                return true;
            }
            Preferences root = Preferences.userNodeForPackage(LicResetUtil.class);
            byte[] lics = root.getByteArray(flag, JSON.toJSONString(new ArrayList()).getBytes(StandardCharsets.UTF_8));
            String licStr = new String(lics);
            log.info("checkLicenseIsDisable ----------" + licStr);
            List licNumbers = JSONArray.parseArray((String)licStr, String.class);
            if (!CollectionUtils.isEmpty((Collection)licNumbers)) {
                return true;
            }
        }
        return false;
    }

    public static void disableLicense(String licId, String flag, List<String> licenseNumbers) {
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{licId, flag}) && !CollectionUtils.isEmpty(licenseNumbers)) {
            Preferences root = Preferences.userNodeForPackage(LicResetUtil.class);
            byte[] lics = root.getByteArray(flag, JSON.toJSONString(new ArrayList()).getBytes(StandardCharsets.UTF_8));
            String licStr = new String(lics);
            List licNumbers = JSONArray.parseArray((String)licStr, String.class);
            for (String licNum : licenseNumbers) {
                if (licNumbers.contains(licNum)) continue;
                licNumbers.add(licNum);
            }
            licStr = JSON.toJSONString((Object)licNumbers);
            root.putByteArray(flag, licStr.getBytes(StandardCharsets.UTF_8));
            log.info("disableLicense  success ----------licId:" + licId + "  flag:" + flag);
        }
    }

    public static void writeLicResetIdentity(String licId) {
        if (StringUtils.isNotBlank((CharSequence)licId)) {
            Preferences root = Preferences.userNodeForPackage(LicResetUtil.class);
            byte[] Ids = root.getByteArray("ZKLIC_RESETIDENTITY", JSON.toJSONString(new ArrayList()).getBytes(StandardCharsets.UTF_8));
            String licStr = new String(Ids);
            List licIds = JSONArray.parseArray((String)licStr, String.class);
            if (!licIds.contains(licId)) {
                licIds.add(licId);
            }
            licStr = JSON.toJSONString((Object)licIds);
            root.putByteArray("ZKLIC_RESETIDENTITY", licStr.getBytes(StandardCharsets.UTF_8));
            log.info("writeLicResetIdentity licId----------" + licId);
        }
    }

    public static boolean getLicResetIdentity(String licId) {
        if (StringUtils.isNotBlank((CharSequence)licId)) {
            Preferences root = Preferences.userNodeForPackage(LicResetUtil.class);
            byte[] ids = root.getByteArray("ZKLIC_RESETIDENTITY", JSON.toJSONString(new ArrayList()).getBytes(StandardCharsets.UTF_8));
            String licStr = new String(ids);
            log.info("getLicResetIdentity ----------" + licStr);
            List licIds = JSONArray.parseArray((String)licStr, String.class);
            log.info("getLicResetIdentity licId----------" + licId);
            if (licIds.contains(licId)) {
                return true;
            }
        }
        return false;
    }

    public static String getLicResetFlag() {
        String licPath = LicFileHelper.getLicPath();
        String flag = LicFileHelper.readLicFlag(licPath);
        flag = StringUtils.isNotBlank((CharSequence)flag) ? flag + "_RESETFILE" : LicFileHelper.readLicId(licPath) + "_RESETFILE";
        return flag;
    }
}

