/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.util;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.guard.foldex.helper.MD5Helper;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.EncrypAESUtil;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.LicCompany;
import com.zkteco.zkbiosecurity.guard.license.bean.LicInfo;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.LicUidCard;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

public class LicFileHelper {
    private static Logger logger = LoggerFactory.getLogger(LicFileHelper.class);
    public static final String LIC_PATH = "/license/biosecurity.lic";
    public static final String LIC_COMPANY = "lic_c";
    public static final String LIC_LICENSE = "lic_l";
    public static final String LIC_ID = "lic_id";
    public static final String LIC_UIDCARD = "lic_U";
    public static final String LIC_PRIVATE_KEY = "lic_prk";
    public static final String LIC_PUBLIC_KEY = "lic_puk";
    public static final String LIC_DNS = "lic_dns";
    public static final String LIC_FLAG = "lic_F";
    public static final String LIC_ENCRYPT_KEY = "ZKTeco#.2022@Lic";
    public static final String DISTRIBUTOR_LIC_PATH = "/license/licdistributor.lic";

    public static void updateModules(String licPath, List<LicModule> modules) {
        Assert.notNull(modules);
        CopyOnWriteArrayList<LicModule> modulesOld = new CopyOnWriteArrayList<LicModule>(LicFileHelper.readLicModules(licPath));
        for (LicModule module : modules) {
            if (StringUtils.isBlank((CharSequence)module.getId()) || StringUtils.isBlank((CharSequence)module.getLicenseNumber())) continue;
            LicModule moduleOld = null;
            for (int i = 0; i < modulesOld.size(); ++i) {
                if ((module.getId().equals(Module.MODULE_ACC_PULL.getId() + "") || module.getId().equals(Module.MODULE_ACC_C3.getId() + "")) && (((LicModule)modulesOld.get(i)).getId().equals(Module.MODULE_ACC_PULL.getId() + "") || ((LicModule)modulesOld.get(i)).getId().equals(Module.MODULE_ACC_C3.getId() + ""))) {
                    modulesOld.remove(i);
                    break;
                }
                if (!((LicModule)modulesOld.get(i)).getId().equals(module.getId())) continue;
                moduleOld = (LicModule)modulesOld.get(i);
                break;
            }
            if (moduleOld == null) {
                modulesOld.add(module);
                continue;
            }
            BeanUtils.copyProperties((Object)module, moduleOld);
        }
        LicFileHelper.writeLicModules(licPath, modulesOld);
    }

    public static void writeLicId(String licPath, String id) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)id);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_ID, LicFileHelper.encode(id));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicId(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            if (!p.containsKey(LIC_ID)) {
                return "";
            }
            String id = LicFileHelper.decode(p.getProperty(LIC_ID));
            return StringUtils.trimToEmpty((String)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicId(InputStream upload) {
        Properties p = new Properties();
        try {
            InputStream ins = upload;
            p.load(ins);
            ins.close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new ZKBusinessException("load lic file error");
        }
        try {
            if (!p.containsKey(LIC_ID)) {
                return "";
            }
            String id = LicFileHelper.decode(p.getProperty(LIC_ID));
            return StringUtils.trimToEmpty((String)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicCompany(String licPath, LicCompany company) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)company);
            String jsonComapny = JSONObject.toJSONString((Object)company);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_COMPANY, LicFileHelper.encode(jsonComapny));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicUidCard(String licPath, LicUidCard uidcard) {
        try {
            Assert.hasText((String)licPath);
            String jsonuidcard = JSONObject.toJSONString((Object)uidcard);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_UIDCARD, LicFileHelper.encode(jsonuidcard));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LicCompany readLicCompany(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            String companyStr = p.getProperty(LIC_COMPANY);
            if (!StringUtils.isBlank((CharSequence)companyStr)) {
                return (LicCompany)JSONObject.parseObject((String)LicFileHelper.decode(companyStr), LicCompany.class);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LicCompany readLicCompany(InputStream upload) {
        block5: {
            try {
                Properties p = new Properties();
                if (upload == null) break block5;
                try {
                    InputStream ins = upload;
                    p.load(ins);
                    ins.close();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new ZKBusinessException("load lic file error");
                }
                String companyStr = p.getProperty(LIC_COMPANY);
                if (!StringUtils.isBlank((CharSequence)companyStr)) {
                    return (LicCompany)JSONObject.parseObject((String)LicFileHelper.decode(companyStr), LicCompany.class);
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static LicUidCard readLicUidCard(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            String uidcard = p.getProperty(LIC_UIDCARD);
            if (!StringUtils.isBlank((CharSequence)uidcard)) {
                return (LicUidCard)JSONObject.parseObject((String)LicFileHelper.decode(uidcard), LicUidCard.class);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicModules(String licPath, List<LicModule> modules) {
        Assert.hasText((String)licPath);
        Assert.notNull(modules);
        String jsonModules = LicFileHelper.encode(JSONObject.toJSONString(modules));
        Properties p = LicFileHelper.getLicFileProperties(licPath);
        p.setProperty(LIC_LICENSE, jsonModules);
        LicFileHelper.saveLicFile(p, licPath);
    }

    public static List<LicModule> readLicModules(String licPath) {
        Properties p = LicFileHelper.getLicFileProperties(licPath);
        String modulesStr = p.getProperty(LIC_LICENSE);
        if (!StringUtils.isBlank((CharSequence)modulesStr)) {
            modulesStr = LicFileHelper.decode(modulesStr);
            return JSONObject.parseArray((String)modulesStr, LicModule.class);
        }
        return new ArrayList<LicModule>();
    }

    public static List<LicModule> readLicModules(InputStream upload) {
        Properties p = new Properties();
        try {
            InputStream ins = upload;
            p.load(ins);
            ins.close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new ZKBusinessException("load lic file error");
        }
        String modulesStr = p.getProperty(LIC_LICENSE);
        if (!StringUtils.isBlank((CharSequence)modulesStr)) {
            modulesStr = LicFileHelper.decode(modulesStr);
            return JSONObject.parseArray((String)modulesStr, LicModule.class);
        }
        return new ArrayList<LicModule>();
    }

    public static synchronized void deleteLicFile() {
        String path = LicFileHelper.getLicPath();
        File licFile = new File(path);
        if (licFile.exists()) {
            licFile.delete();
        }
    }

    public static synchronized void cleanLicCompanyAndLicense() {
        String path = LicFileHelper.getLicPath();
        Properties ps = LicFileHelper.getLicFileProperties(path);
        if (ps != null && ps.containsKey(LIC_COMPANY)) {
            ps.remove(LIC_COMPANY);
        }
        if (ps != null && ps.containsKey(LIC_LICENSE)) {
            ps.remove(LIC_LICENSE);
        }
        if (ps != null && ps.containsKey(LIC_ID)) {
            ps.remove(LIC_ID);
        }
        LicFileHelper.saveLicFile(ps, path);
    }

    private static synchronized Properties getLicFileProperties(String licPath) {
        Properties prop = new Properties();
        File licFile = new File(licPath);
        if (licFile.exists()) {
            try {
                FileInputStream ins = new FileInputStream(new File(licPath));
                prop.load(ins);
                ((InputStream)ins).close();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                throw new ZKBusinessException("load lic file error");
            }
        }
        return prop;
    }

    private static synchronized void saveLicFile(Properties prop, String licPath) {
        try {
            File licFile = new File(licPath);
            if (!licFile.exists()) {
                licFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(licFile);
            prop.store(out, "lic file");
            out.close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new ZKBusinessException("save lic file error");
        }
    }

    public static void writeLicPrivateKey(String licPath, String licPrivateKey) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)licPrivateKey);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_PRIVATE_KEY, LicFileHelper.encode(licPrivateKey));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicPrivateKey(String licPath, boolean decrypt) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            if (!p.containsKey(LIC_PRIVATE_KEY)) {
                return "";
            }
            String enPriKey = LicFileHelper.decode(p.getProperty(LIC_PRIVATE_KEY));
            if (decrypt && StringUtils.isNotBlank((CharSequence)enPriKey)) {
                String licenseId = MD5Helper.encrypt32((String)StringUtils.trimToNull((String)LicFileHelper.readLicId(licPath)));
                return FoldexUtil.decryptAESB64((String)licenseId, (String)licenseId.substring(8, 24), (String)enPriKey);
            }
            return StringUtils.trimToEmpty((String)enPriKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicPublicKey(String licPath, String licPublicKey) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)licPublicKey);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_PUBLIC_KEY, LicFileHelper.encode(licPublicKey));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicPublicKey(String licPath, boolean decrypt) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            if (!p.containsKey(LIC_PUBLIC_KEY)) {
                return "";
            }
            String enPubKey = LicFileHelper.decode(p.getProperty(LIC_PUBLIC_KEY));
            if (decrypt && StringUtils.isNotBlank((CharSequence)enPubKey)) {
                String licenseId = MD5Helper.encrypt32((String)StringUtils.trimToNull((String)LicFileHelper.readLicId(licPath)));
                return FoldexUtil.decryptAESB64((String)licenseId, (String)licenseId.substring(8, 24), (String)enPubKey);
            }
            return StringUtils.trimToEmpty((String)enPubKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicDistributor(String licPath, LicInfo licInfo) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)licInfo);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_ID, LicFileHelper.encode(StringUtils.trimToEmpty((String)licInfo.getId())));
            String jsonComapny = JSONObject.toJSONString((Object)licInfo.getCompany());
            p.setProperty(LIC_COMPANY, LicFileHelper.encode(jsonComapny));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LicInfo readLicDistributor(String licPath) {
        try {
            Assert.hasText((String)licPath);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            LicInfo licInfo = null;
            if (p.containsKey(LIC_ID) && p.containsKey(LIC_COMPANY)) {
                licInfo = new LicInfo();
                String id = LicFileHelper.decode(p.getProperty(LIC_ID));
                licInfo.setId(id);
                String companyStr = p.getProperty(LIC_COMPANY);
                if (!StringUtils.isBlank((CharSequence)companyStr)) {
                    LicCompany company = (LicCompany)JSONObject.parseObject((String)LicFileHelper.decode(companyStr), LicCompany.class);
                    licInfo.setCompany(company);
                }
            }
            return licInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void initDistributorLic(LicInfo licInfo) {
        try {
            Assert.notNull((Object)licInfo);
            Assert.hasText((String)licInfo.getId());
            Assert.notNull((Object)licInfo.getCompany());
            File licFile = new File(LicFileHelper.getLicDistributorPath());
            if (licFile.exists()) {
                LicInfo old = LicFileHelper.readLicDistributor(LicFileHelper.getLicDistributorPath());
                Assert.hasText((String)old.getId());
                if (old.getId().equals(licInfo.getId())) {
                    return;
                }
                throw new ZKBusinessException();
            }
            LicFileHelper.writeLicDistributor(LicFileHelper.getLicDistributorPath(), licInfo);
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
    }

    public static String getLicPath() {
        return ClassUtil.getRootPath() + LIC_PATH;
    }

    public static String getLicDistributorPath() {
        return ClassUtil.getRootPath() + DISTRIBUTOR_LIC_PATH;
    }

    private static String encode(String s) {
        String encodeStr = EncrypAESUtil.encrytToString((String)s);
        return encodeStr;
    }

    private static String decode(String s) {
        String decodeStr = EncrypAESUtil.decryptToString((String)s);
        return decodeStr;
    }

    public static void writeLicDns(String licPath, String dns) {
        try {
            Assert.hasText((String)licPath);
            dns = StringUtils.isBlank((CharSequence)dns) ? "" : LicFileHelper.decrypt(dns, LIC_ENCRYPT_KEY);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_DNS, LicFileHelper.encode(dns));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicDns(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            if (!p.containsKey(LIC_DNS)) {
                return "";
            }
            String id = LicFileHelper.decode(p.getProperty(LIC_DNS));
            return StringUtils.trimToEmpty((String)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicFlag(String licPath, String flag) {
        try {
            Assert.hasText((String)licPath);
            flag = StringUtils.isBlank((CharSequence)flag) ? "" : LicFileHelper.decrypt(flag, LIC_ENCRYPT_KEY);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_FLAG, LicFileHelper.encode(flag));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicFlag(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            if (!p.containsKey(LIC_FLAG)) {
                return "";
            }
            String id = LicFileHelper.decode(p.getProperty(LIC_FLAG));
            return StringUtils.trimToEmpty((String)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String source, String secretKey) {
        try {
            if (StringUtils.isBlank((CharSequence)source)) {
                return source;
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, new SecretKeySpec(secretKey.getBytes(), "AES"));
            byte[] encrypted = Base64.decodeBase64((String)source);
            return new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return source;
        }
    }

    public static String encrypt(String source, String secretKey) {
        try {
            if (StringUtils.isBlank((CharSequence)source)) {
                return source;
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(secretKey.getBytes(), "AES"));
            return Base64.encodeBase64String((byte[])cipher.doFinal(source.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            return source;
        }
    }
}

