/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.bean;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import java.util.List;

public enum SystemModule {
    ACC(ModuleCode.ACC, Module.MODULE_ACC_PULL, Module.MODULE_ACC_PUSH),
    ARTECO(ModuleCode.ARTECO, Module.MODULE_ARTECO),
    API(ModuleCode.API, Module.MODULE_API),
    AD(ModuleCode.AD, Module.MODULE_AD),
    C2P(ModuleCode.C2P, Module.MODULE_C2P),
    DIGIFORT(ModuleCode.DIGIFORT, Module.MODULE_DIGIFORT),
    VID(ModuleCode.VID, Module.MODULE_VID),
    VIS(ModuleCode.VIS, Module.MODULE_VIS),
    ELE(ModuleCode.ELE, Module.MODULE_ELE),
    PAT(ModuleCode.PAT, Module.MODULE_PAT),
    HOTEL(ModuleCode.HOTEL, Module.MODULE_HOTEL),
    LED(ModuleCode.LED, Module.MODULE_LED),
    ATT(ModuleCode.ATT, Module.MODULE_ATT, Module.MODULE_PARKING_LPR_CAMERA, Module.MODULE_ACCESS_CONTROL_DOOR, Module.MODULE_INS_ATT, Module.MODULE_PID_ATT, Module.MODULE_VMS_ATT, Module.MODULE_VID_ATT, Module.MODULE_IVS_ATT, Module.MODULE_PSG_ATT, Module.MODULE_ESDC_ATT),
    ACCATT(ModuleCode.ACCATT, Module.MODULE_ACC_ATT),
    PARK(ModuleCode.PARK, Module.MODULE_PARK, Module.MODULE_PARKTICKET),
    OCR(ModuleCode.OCR, Module.MODULE_OCR),
    APP(ModuleCode.APP, Module.MODULE_APP),
    PERSIDREADER(ModuleCode.PERSIDREADER, Module.MODULE_PERS_ID_READER),
    VISOCR(ModuleCode.VISOCR, Module.MODULE_VIS_OCR),
    VISIDREADER(ModuleCode.VISIDREADER, Module.MODULE_VIS_ID_READER),
    VISPRINTCARD(ModuleCode.VISPRINTCARD, Module.MODULE_VIS_PRINT_CARD),
    HOTELOCR(ModuleCode.HOTELOCR, Module.MODULE_HOTEL_OCR),
    HOTELIDREADER(ModuleCode.HOTELPRINTCARD, Module.MODULE_HOTEL_ID_READER),
    PRINTCARD(ModuleCode.PRINTCARD, Module.MODULE_PRINTCARD),
    SYSTEMPERS(ModuleCode.SYSTEMPERS, Module.MODULE_SYSTEM_PERS),
    SYSTEMDEPARTMENT(ModuleCode.SYSTEMDEPARTMENT, Module.MODULE_SYSTEM_DEPARTMENT),
    SYSTEMAREA(ModuleCode.SYSTEMAREA, Module.MODULE_SYSTEM_AREA),
    PARKINGLPRCAMERA(ModuleCode.PARKINGLPRCAMERA, Module.MODULE_PARKING_LPR_CAMERA),
    ACCESSCONTROLDOOR(ModuleCode.ACCESSCONTROLDOOR, Module.MODULE_ACCESS_CONTROL_DOOR),
    POS(ModuleCode.POS, Module.MODULE_POS),
    LCD(ModuleCode.LCD, Module.MODULE_LCD),
    CARDCONTROL(ModuleCode.CARDCONTROL, Module.MODULE_CARD_CONTROL),
    PID(ModuleCode.PID, Module.MODULE_PID),
    PASSAGE(ModuleCode.PSG, Module.MODULE_PSG),
    INS(ModuleCode.INS, Module.MODULE_INS),
    INSATT(ModuleCode.INSATT, Module.MODULE_INS_ATT),
    PIDATT(ModuleCode.PIDATT, Module.MODULE_PID_ATT),
    AI(ModuleCode.AI, Module.MODULE_AI),
    HOTELSIGNATURE(ModuleCode.HOTELSIGNATURE, Module.MODULE_HOTEL_SIGNATURE),
    VISSIGNATURE(ModuleCode.VISSIGNATURE, Module.MODULE_VIS_SIGNATURE),
    POSID(ModuleCode.POSID, Module.MODULE_POSID),
    VMS(ModuleCode.VMS, Module.MODULE_VMS),
    OA(ModuleCode.OA, Module.MODULE_OA),
    ICM(ModuleCode.ICM, Module.MODULE_ICM),
    VISADVANCED(ModuleCode.VISADVANCED, Module.MODULE_VIS_ADVANCED),
    GSMGPRSMODEM(ModuleCode.GSMGPRSMODEM, Module.MODULE_GSMGPRSMODEM),
    THIRDSMS(ModuleCode.THIRDSMS, Module.MODULE_THIRDSMS),
    VMSATT(ModuleCode.VMSATT, Module.MODULE_VMS_ATT),
    LINE(ModuleCode.LINE, Module.MODULE_LINE),
    CVA(ModuleCode.CVA, Module.MODULE_CVA),
    ASSETS(ModuleCode.ASSETS, Module.MODULE_ASSETS),
    FENCE(ModuleCode.FENCE, Module.MODULE_FENCE),
    VIDATT(ModuleCode.VIDATT, Module.MODULE_VID_ATT),
    APT(ModuleCode.APT, Module.MODULE_APT),
    APPPERS(ModuleCode.APPPERS, Module.MODULE_APPPERS),
    DEVICETOTALCOUNT(ModuleCode.DEVTOTALCOUNT, Module.MODULE_DEV_TOTAL_COUNT),
    IVS(ModuleCode.IVS, Module.MODULE_IVS),
    IVSATT(ModuleCode.IVSATT, Module.MODULE_IVS_ATT),
    PSGATT(ModuleCode.PSGATT, Module.MODULE_PSG_ATT),
    SIS(ModuleCode.SIS, Module.MODULE_SIS),
    OAMEET(ModuleCode.OAMEET, Module.MODULE_OAMEET),
    LOCKER(ModuleCode.LOCKER, Module.MODULE_LOCKER),
    IAS(ModuleCode.IAS, Module.MODULE_IAS),
    ILK(ModuleCode.ILK, Module.MODULE_ILK),
    ESDCATT(ModuleCode.ESDCATT, Module.MODULE_ESDC_ATT),
    VDB(ModuleCode.VDB, Module.MODULE_VDB_INDOORSTATION, Module.MODULE_VDB_DOORSTATION);

    private ModuleCode moduleCode;
    private List<Module> modules = Lists.newArrayList();
    private boolean isLeaf = true;

    public static boolean containCode(String code) {
        for (SystemModule systemModule : SystemModule.values()) {
            if (!systemModule.getModuleCode().getCode().equalsIgnoreCase(code)) continue;
            return true;
        }
        return false;
    }

    public static SystemModule getByCode(String code) {
        for (SystemModule systemModule : SystemModule.values()) {
            if (!systemModule.getModuleCode().getCode().equalsIgnoreCase(code)) continue;
            return systemModule;
        }
        return null;
    }

    private SystemModule(ModuleCode moduleCode, Module ... modules) {
        this.moduleCode = moduleCode;
        this.modules = Lists.newArrayList((Object[])modules);
        if (modules.length > 1) {
            this.isLeaf = false;
        }
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ModuleCode getModuleCode() {
        return this.moduleCode;
    }

    public String getCode() {
        return this.moduleCode.getCode();
    }
}

