/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.bean;

import com.zkteco.guard.security.LicenseHelper;
import com.zkteco.zkbiosecurity.guard.LicenseCheckUtil;
import com.zkteco.zkbiosecurity.guard.LicenseContextUtil;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleType;
import com.zkteco.zkbiosecurity.license.vo.bean.ResultCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;

public enum ModuleCode {
    ACC("acc", "Access Control", "${acc_module}", "${common_doors}"),
    ACCADVANCED("accadvanced", "Advanced Access Control", "${auth_license_moduleAccAdvanced}", 4),
    PULL("pull", "Pull Access Control", "${auth_license_moduleAccPull}", "${common_devices}", 2),
    PUSH("push", "Push Access Control", "${auth_license_moduleAccPush}", "${common_devices}", 1),
    C3("c3", "C3 Acccess Control", "${auth_license_moduleAccPullC3}", "${common_devices}"),
    VIS("vis", "Vistior Control", "${vis_module}", "${auth_license_passengers}", 6),
    VID("vid", "Video Control", "${vid_module}", "${common_cameras}", 9),
    ELE("ele", "Elevator Control", "${ele_module}", "${common_devices}", 4),
    ELEDCS("eledcs", "Ele Dcs Control", "${ele_integration_dcs}"),
    ELEDCSQUANTITY("eledcsquantity", "DCS System Quantity", "${ele_integration_dcsServiceQuantity}", "${common_points}"),
    PAT("patrol", "Pat Control", "${patrol_module}", 8),
    HOTEL("hotel", "ZKBiolock3.0 Control", "${hotel_module}", 5),
    LED("led", "LED Control", "${led_module}"),
    PARK("park", "Park Control", "${park_module}", 7),
    PARKTICKET("ticket", "Park ticket Control", "${park_module}", 7),
    ATT("att", "Att Control", "${att_module}", "${common_points}", 3),
    ACCATT("accatt", "Acc Att Control", "${accatt_module}"),
    ARTECO("arteco", "Arteco Control", "${auth_license_arteco}"),
    C2P("c2p", "C2p Control", "${auth_license_c2p}"),
    OCR("ocr", "Ocr Control", "${auth_license_ocr}", "${common_clients}", 987),
    AD("ad", "Ad Control", "${auth_license_ad}"),
    PRINTCARD("printcard", "Print Card Control", "${auth_license_print_card}", "${common_clients}", 1111),
    API("api", "Api Control", "API"),
    APP("app", "App Control", "${auth_license_app}"),
    PERSIDREADER("persidreader", "Personnel ID Reader Control", "${auth_license_id_reader}", "${common_clients}", 1001),
    VISOCR("visocr", "Visitor OCR Control", "${auth_license_ocr}", "${common_clients}", 988),
    VISIDREADER("visidreader", "Visitor Id Reader Control", "${auth_license_id_reader}", "${common_clients}", 1002),
    VISPRINTCARD("visprintcard", "Visitor Print Card Control", "${auth_license_print_card}", "${common_clients}", 1112),
    HOTELOCR("hotelocr", "Hotel OCR Control", "${auth_license_ocr}", "${common_clients}", 988),
    HOTELIDREADER("hotelidreader", "Hotel Id Reader Control", "${auth_license_id_reader}", "${common_clients}", 1002),
    HOTELPRINTCARD("hotelprintcard", "Hotel Print Card Control", "${auth_license_print_card}", "${common_clients}", 1112),
    SYSTEMPERS("systempers", "System Pers Control", "${auth_license_persons}"),
    SYSTEMDEPARTMENT("systemdepartment", "System Department Control", "${auth_dept_entity}"),
    SYSTEMAREA("systemarea", "System Area Control", "${base_area_entity}"),
    ACCESSCONTROLDOOR("accesscontroldoor", "access control door", "${att_module}", "${common_points}", 3),
    PARKINGLPRCAMERA("parkinglprcamera", "parking lpr camera", "${att_module}", "${common_points}", 3),
    POS("pos", "Pos Control", "${pos_module}"),
    LCD("lcd", "LCD Control", "${acc_leftMenu_LCDRTMonitor}"),
    VISADVANCED("visadvanced", "Visitor Advanced Control", "${auth_license_vis_advanced}"),
    CARDCONTROL("cardcontrol", "Card Control", "${auth_license_card_control}"),
    PID("pid", "Identification Control", "${pid_module}"),
    PSG("psg", "Passage Control", "${psg_module}"),
    INS("ins", "Information Screen", "${ins_module}"),
    INSATT("insatt", "Information Screen For Att", "${att_module}", "${common_points}", 3),
    PIDATT("pidatt", "Identification For Att", "${att_module}", "${common_points}", 3),
    AI("ai", "Artificial Intelligence", "${ai_module}", "${common_points}", 3),
    HOTELSIGNATURE("hotelsignature", "Hotel Signature", "${auth_license_signature}", "${common_clients}", 1113),
    VISSIGNATURE("vissignature", "Visitor Signature", "${auth_license_signature}", "${common_clients}", 1114),
    MIDDLETABLE("middletable", "Middle Table", "${auth_license_middletable}"),
    POSID("posid", "Pos ID Control", "${posid_module}"),
    VMS("vms", "Vms Control", "${vms_module}", "${common_cameras}", 9),
    ICM("icm", "ICM Control", "${icm_module}"),
    OA("oa", "OA", "${oa_module}"),
    VMSATT("vmsatt", "Vms control door", "${att_module}", "${common_points}", 3),
    GSMGPRSMODEM("gsmgprsmodem", "Sms Gsm Gprs Modem Control", "${auth_license_smsmodem}"),
    THIRDSMS("thirdsms", "Sms Third-Park Control", "${auth_license_smsthirdpark}"),
    LINE("line", "Line Control", "${auth_license_line}"),
    CVA("cva", "Intelligent Analysis", "${cva_module}", 10),
    ASSETS("assets", "Fixed Assets", "${ass_module}", 11),
    FENCE("fence", "Electric Fence", "${fence_module}"),
    DIGIFORT("digifort", "Digifort Control", "${auth_license_digifort}"),
    VIDATT("vidatt", "Vid control door", "${att_module}", "${common_points}", 3),
    ESDC("esdc", "Esdc", "${esdc_module}"),
    ESDCATT("esdcatt", "esdc for att", "${att_module}", "${common_points}", 6),
    APT("apt", "Apt", "${auth_license_moduleApt}"),
    APPPERS("apppers", "App Control", "${auth_license_app_pers}"),
    DEVTOTALCOUNT("devtotalcount", "Device Total Count", "${auth_license_devtotalcount}", 12),
    IVS("ivs", "Intelligent Vid", "${ivs_module}", "${common_cameras}", 9),
    IVSATT("ivsatt", "ivs for att", "${att_module}", "${common_points}", 4),
    PSGATT("psgatt", "psg for att", "${att_module}", "${common_points}", 5),
    FACECOMPARE("facecompare", "Face Comparison Control", "${esdc_face_comparison}"),
    PERSSTRUCTURED("persstructured", "pedestrian Control", "${esdc_pers_structured}"),
    WHATSAPP("whatsapp", "whatsapp Control", "WhatsApp"),
    PERSONNELCONTROL("personnelcontrol", "Personnel Control Function", "${personnel_control}"),
    KEYACCESSCONTROL("keyaccesscontrol", "Key Access Control Function", "${key_access_control}"),
    OFFDUTY("offduty", "Off-duty Function", "${off_duty}"),
    PEOPLECOUNTING("peoplecounting", "People Counting Function", "${people_counting}"),
    ELECTRONICFENCE("electronicfence", "Electronic Fence Function", "${electronic_fence}"),
    SIS("sis", "Sis Control", "${sis_module}", "${common_points}"),
    OAMEET("oameeting", "OaMeet Control", "${oameeting_module}", "${common_points}"),
    ACCMUSTERPOINT("accmusterpoint", "Acc Musterpoint Control", "${acc_leftMenu_accMusterPoint}"),
    LOCKER("locker", "Locker Control", "${locker_module}"),
    PARKDUALVERIF("parkdualverif", "park and acc dual verification Control", "${park_license_doubleVerify}"),
    IAS("ias", "Ia Control", "${ias_module}", "${common_points}"),
    ILK("ilk", "Ilk Control", "${ilk_module}", "${common_points}"),
    IVSPATROL("ivspatrol", "ivs patrol Control", "${ivs_leftMenu_ivsPatrolManagement}"),
    VDB("vdb", "Vdb Control", "${vdb_module}", "${common_points}"),
    INDOORSTATION("vdbindoorstation", "indoorStation Access Control", "${vdb_license_indoorStation}", "${common_points}"),
    DOORSTATION("vdbdoorstation", "doorStation Access Control", "${vdb_license_doorStation}", "${common_points}");

    public static String language;
    public static String installDate;
    public static String devModelKey;
    public static String systemKey;
    public static String devMode;
    public static String productCode;
    public static String systemOem;
    public static String trialDays;
    public static String processor;
    private String code;
    private String name;
    private String i18n;
    private String unit = "${common_points}";
    private int sort = 999;

    public static ModuleCode getByCode(String code) {
        for (ModuleCode m : ModuleCode.values()) {
            if (!m.getCode().equals(code)) continue;
            return m;
        }
        return null;
    }

    private ModuleCode(String code, String name, String i18n) {
        this.code = code;
        this.name = name;
        this.i18n = i18n;
    }

    private ModuleCode(String code, String name, String i18n, int sort) {
        this(code, name, i18n);
        this.sort = sort;
    }

    private ModuleCode(String code, String name, String i18n, String unit, int sort) {
        this(code, name, i18n, unit);
        this.sort = sort;
    }

    private ModuleCode(String code, String name, String i18n, String unit) {
        this(code, name, i18n);
        this.unit = unit;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getI18n() {
        return this.i18n;
    }

    public String getUnit() {
        return this.unit;
    }

    public int getSort() {
        return this.sort;
    }

    public static String getTrialDays() {
        return trialDays;
    }

    public static void setTrialDays(String trialDays) {
        ModuleCode.trialDays = trialDays;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean proccessLicenseStr(List<String> licenseStrList) {
        if ("ZKBioAccess".equals(productCode) && this != ATT && this != ACCESSCONTROLDOOR && this != VMSATT && "${att_module}".equals(this.getI18n())) {
            return false;
        }
        if (this == ACCADVANCED && "ZKBioAccess".equals(productCode)) {
            return false;
        }
        if (this == CARDCONTROL) {
            return false;
        }
        if (this == ACCATT) {
            return false;
        }
        if (!(LicenseUtil.isLocal() || this != ACC && this != PULL && this != C3)) {
            return false;
        }
        if (LicenseUtil.isLocal() && (this == ARTECO || this == C2P || this == DIGIFORT || this == VISADVANCED || this == GSMGPRSMODEM || this == LINE || this == AD)) {
            return false;
        }
        if ("ZKBioAccess".equals(productCode) && (this == API || this == PRINTCARD || this == HOTELPRINTCARD || this == VISPRINTCARD)) {
            return false;
        }
        if (("ZKBioAccess".equals(productCode) || LicenseUtil.isLocal()) && (this == OCR || this == PERSIDREADER || this == VISIDREADER || this == VISOCR || this == HOTELIDREADER || this == HOTELOCR || this == HOTELSIGNATURE || this == VISSIGNATURE)) {
            return false;
        }
        if (LicenseUtil.isLocal() && this == APPPERS) {
            return false;
        }
        boolean ret = false;
        String i18n = this.getI18n();
        if (this == VISIDREADER || this == VISOCR || this == VISPRINTCARD || this == VISSIGNATURE) {
            i18n = i18n + "${vis_module}";
        } else if (this == OCR || this == PERSIDREADER || this == PRINTCARD) {
            i18n = i18n + "${pers_module}";
        } else if (this == HOTELOCR || this == HOTELIDREADER || this == HOTELPRINTCARD) {
            i18n = i18n + "${hotel_module}";
        }
        String pointsStr = this.getUnit();
        if (!LicenseUtil.isLocal() && this == PUSH) {
            i18n = ACC.getI18n();
            pointsStr = "${common_doors}";
        }
        String installLan = language;
        if (this == PARKINGLPRCAMERA) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_parking_lpr_camera}";
            } else {
                pointsStr = "${auth_license_parking_lpr_camera}";
            }
        } else if (this == ACCESSCONTROLDOOR) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_access_control_door}";
            } else {
                pointsStr = "${auth_license_access_control_door}";
            }
        } else if (this == INSATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_ins_att}";
            } else {
                pointsStr = "${auth_license_ins_att}";
            }
        } else if (this == ATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_att}";
            } else {
                pointsStr = "${auth_license_att}";
            }
        } else if (this == PIDATT) {
            if (!LicenseUtil.isLocal()) return false;
            i18n = i18n + "${auth_license_pid_att}";
        } else if (this == VMSATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_vms_att}";
            } else {
                pointsStr = "${auth_license_vms_att}";
            }
        } else if (this == VIDATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_vid_att}";
            } else {
                pointsStr = "${auth_license_vid_att}";
            }
        } else if (this == IVSATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_ivs_att}";
            } else {
                pointsStr = "${auth_license_ivs_att}";
            }
        } else if (this == PSGATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_psg_att}";
            } else {
                pointsStr = "${auth_license_psg_att}";
            }
        } else if (this == ESDCATT) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_esdc_att}";
            } else {
                pointsStr = "${auth_license_esdc_att}";
            }
        }
        if (this == PARK && !LicenseUtil.isLocal()) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_park_lpr}";
            } else {
                pointsStr = "${auth_license_park_lpr}";
            }
        }
        if (this == PARKTICKET && !LicenseUtil.isLocal()) {
            if ("zh_CN".equals(installLan)) {
                i18n = i18n + "${auth_license_park_tbm}";
            } else {
                pointsStr = "${auth_license_park_tbm}";
            }
        } else if (this == PARKTICKET && LicenseUtil.isLocal()) {
            return false;
        }
        ModuleBean moduleBean = LicenseUtil.getLicenseContext().getLicenseModule(this.getCode());
        Module module = Module.getByCode(moduleBean == null ? this.getCode() : moduleBean.getCode());
        String licInfoStr = "";
        if (this == Module.MODULE_ACC_PULL.getModuleCode() || this == Module.MODULE_ACC_C3.getModuleCode()) {
            if (LicenseUtil.getLicenseContext().isSupportFunction(Module.MODULE_ACC_C3) == ResultCode.SUCCESS) {
                i18n = Module.MODULE_ACC_C3.getModuleCode().getI18n();
                module = Module.MODULE_ACC_C3;
            }
            if (moduleBean != null && moduleBean.getCode().equals(Module.MODULE_ACC_C3.getCode())) {
                i18n = Module.MODULE_ACC_C3.getModuleCode().getI18n();
            }
        }
        String periodActivated = "${auth_license_period_activated}";
        String periodExpired = "${auth_license_period_expired}";
        String periodTrial = "${auth_license_period_trial}";
        String periodTrialExpired = "${auth_license_period_nonActivated}";
        String nonActivated = "${auth_license_period_nonActivated}";
        String permanent = "${auth_license_period_permanent}";
        String licensePeriod = periodTrial;
        String untiltime = "";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date curTime = new Date();
        if (moduleBean == null) return ret;
        if (!moduleBean.isTrial()) {
            untiltime = formatter.format(moduleBean.getLicenseDate());
            if (moduleBean.licenseAvaiable()) {
                licensePeriod = periodActivated;
                licInfoStr = this.assembleLicInfoStr(module, moduleBean, false, i18n, pointsStr, periodActivated);
                ret = true;
            } else {
                untiltime = "-";
                licensePeriod = periodExpired;
                licInfoStr = this.assembleLicInfoStr(module, moduleBean, true, i18n, pointsStr, periodExpired);
            }
            if (-1 == moduleBean.getLimitNumberOfDays()) {
                untiltime = permanent;
            }
            if (moduleBean.getLicenseDate().getTime() > curTime.getTime()) {
                try {
                    Date licenseDate = DateUtils.parseDate((String)(moduleBean.getLimitNumberOfDays() + ""), (String[])new String[]{"yyyyMMdd"});
                    int left = LicenseUtil.getDaysBetween(new Date(), licenseDate);
                    if (left < 7) {
                        untiltime = "<span style='color:#FF8000;'>" + untiltime + "</span>";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                untiltime = LicenseHelper.getPeriodUntilTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (LicenseUtil.isLocal() && (this == AD || this == PARKINGLPRCAMERA)) {
                return false;
            }
            if (moduleBean.trialAvaiable()) {
                licensePeriod = periodTrial;
                licInfoStr = this.assembleLicInfoStr(module, moduleBean, false, i18n, pointsStr, periodTrial);
            } else {
                untiltime = "-";
                licensePeriod = periodTrialExpired;
                licInfoStr = this.assembleLicInfoStr(module, moduleBean, true, i18n, pointsStr, periodTrialExpired);
            }
            if (module == Module.MODULE_SYSTEM_PERS || module == Module.MODULE_SYSTEM_AREA || module == Module.MODULE_SYSTEM_DEPARTMENT || LicenseUtil.isLocal() && module == Module.MODULE_API) {
                untiltime = permanent;
            }
            if (ModuleType.BUSSINESS != module.getModuleType() && (!LicenseUtil.isLocal() && module == Module.MODULE_API || this == LCD || this == MIDDLETABLE || this == CARDCONTROL || this == AD || LicenseUtil.isLocal() && this == LED || !module.isNumberLimit() && 0 == moduleBean.getControlCount()) && this != ACCESSCONTROLDOOR && this != PARKINGLPRCAMERA && this != PARKINGLPRCAMERA && this != PARKINGLPRCAMERA && this != INSATT && this != PIDATT && this != VMSATT && this != VIDATT && this != IVSATT && this != PSGATT) {
                untiltime = "-";
                licInfoStr = this.assembleLicInfoStr(module, moduleBean, false, i18n, pointsStr, nonActivated);
            }
        }
        if (!"".equals(licInfoStr) && licInfoStr != null) {
            String[] licInfoStrArr = licInfoStr.split(",");
            if (licInfoStrArr[1].contains(pointsStr)) {
                if (LicenseUtil.countMap.get(module.getModuleCode().getCode()) == null) {
                    licInfoStr = String.format("%s,%s,%s,%s,%s,%s", licInfoStrArr[0], licInfoStrArr[1], licInfoStrArr[2], untiltime, module.getModuleCode().getSort(), this.userOverLicense(0, pointsStr, module));
                } else if (LicenseUtil.isLocal() || module != Module.MODULE_ACC_PUSH) {
                    if (module == Module.MODULE_VIS) {
                        String displayVisPlaceControlCount = LicenseUtil.getLicenseContext().getVisPlaceControlCountDisplayStr();
                        licInfoStr = String.format("%s,%s,%s,%s,%s,%s", licInfoStrArr[0], this.leftCount(Integer.parseInt(displayVisPlaceControlCount), (Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode())) + "/" + licInfoStrArr[1], licInfoStrArr[2], untiltime, module.getModuleCode().getSort(), this.userOverLicense((Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode()), "/" + licInfoStrArr[1], module));
                    } else {
                        licInfoStr = String.format("%s,%s,%s,%s,%s,%s", licInfoStrArr[0], this.leftCount(moduleBean.getDefaultControlCount(), (Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode())) + "/" + licInfoStrArr[1], licInfoStrArr[2], untiltime, module.getModuleCode().getSort(), this.userOverLicense((Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode()), pointsStr, module));
                    }
                } else {
                    String commonDeviceStr = "${common_devices}";
                    int pullCount = LicenseUtil.getLicenseContext().getControlCount(Module.MODULE_ACC_PULL.getCode());
                    licInfoStr = pullCount > 0 ? String.format("%s,%s%s(Include max %s PULL %s),%s,%s,%s,%s", licInfoStrArr[0], this.leftCount(moduleBean.getDefaultControlCount(), (Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode())) + "/" + moduleBean.getDefaultControlCount(), pointsStr, pullCount, commonDeviceStr, licensePeriod, untiltime, module.getModuleCode().getSort(), this.userOverLicense((Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode()), pointsStr, module)) : String.format("%s,%s,%s,%s,%s,%s", licInfoStrArr[0], this.leftCount(moduleBean.getDefaultControlCount(), (Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode())) + "/" + licInfoStrArr[1], licInfoStrArr[2], untiltime, module.getModuleCode().getSort(), this.userOverLicense((Integer)LicenseUtil.countMap.get(module.getModuleCode().getCode()), pointsStr, module));
                }
            } else if (!licInfoStrArr[1].contains(pointsStr)) {
                licInfoStr = String.format("%s,%s,%s,%s,%s,%s", licInfoStrArr[0], licInfoStrArr[1], licInfoStrArr[2], untiltime, module.getModuleCode().getSort(), this.userOverLicense(0, pointsStr, module));
            }
        }
        licenseStrList.add(licInfoStr);
        return ret;
    }

    private String userOverLicense(int license, String point, Module module) {
        boolean resultCode = true;
        String licenseStr = license + point;
        if (("ZKBioCVServerV6000".equals(productCode) || "ZKBioCVSecurityFoundation".equals(productCode)) && module.isTotalLicense()) {
            if ("true".equals(LicenseContextUtil.getValue("is" + DEVTOTALCOUNT.getCode() + "over"))) {
                resultCode = false;
            }
            licenseStr = !resultCode && license > LicenseCheckUtil.getControlCount(Module.MODULE_DEV_TOTAL_COUNT) ? "<span style='color:red;'>" + license + point + "</span>" : licenseStr;
        } else if ("ZKBioCVSecurityFoundation".equals(productCode) && "accesscontroldoor".equals(module.getCode())) {
            licenseStr = licenseStr + "(${auth_license_devtotalcountTip0})";
        }
        return licenseStr;
    }

    public int leftCount(int firstNum, int secondNum) {
        return firstNum - secondNum < 0 ? 0 : firstNum - secondNum;
    }

    private String assembleLicInfoStr(Module module, ModuleBean moduleBean, boolean expired, String i18n, String pointUnit, String licensePeriod) {
        ModuleCode moduleCode = module.getModuleCode();
        String licInfoStr = "";
        if (!LicenseUtil.isLocal() && module == Module.MODULE_PARK && 0 == moduleBean.getMajor() && !moduleBean.isTrial()) {
            i18n = i18n + "(" + "${auth_license_park_deviceType1}" + ")";
        } else if (module == Module.MODULE_PARK && 1 == moduleBean.getMajor() && !moduleBean.isTrial()) {
            i18n = i18n + "(" + "${auth_license_park_deviceType2}" + ")";
        } else if (!LicenseUtil.isLocal() && module == Module.MODULE_PARK && moduleBean.isTrial()) {
            i18n = i18n + "(" + "${auth_license_park_deviceType1}" + ")";
        }
        if ("true".equals(LicenseContextUtil.getValue("isacc" + moduleCode.getCode() + "over"))) {
            i18n = "<span style='color:red;'>" + i18n + "</span>";
        }
        if ("true".equals(LicenseContextUtil.getValue("is" + moduleCode.getCode() + "over")) && !"pull".equals(moduleCode.getCode()) && !"push".equals(moduleCode.getCode()) && !"accadvanced".equals(moduleCode.getCode())) {
            i18n = "<span style='color:red;'>" + i18n + "</span>";
        }
        if (("pull".equals(moduleCode.getCode()) || "push".equals(moduleCode.getCode())) && !LicenseUtil.isLocal() && "true".equals(LicenseContextUtil.getValue("isaccover"))) {
            i18n = "<span style='color:red;'>" + i18n + "</span>";
        }
        if (module.isNumberLimit()) {
            if (moduleBean != null) {
                boolean isTrial = moduleBean.trialAvaiable();
                if (isTrial && (!LicenseUtil.isLocal() && module == Module.MODULE_API || this == LCD || this == CARDCONTROL || this == MIDDLETABLE || this == AD)) {
                    String x = "<span style='color:red;'>x</span>";
                    licInfoStr = String.format("%s," + x + ",%s,%s", i18n, licensePeriod, moduleCode.getSort());
                } else {
                    licInfoStr = String.format("%s,\u221a,%s,%s", i18n, licensePeriod, moduleCode.getSort());
                    if (!isTrial && !moduleBean.licenseAvaiable()) {
                        String x = "<span style='color:red;'>x</span>";
                        licInfoStr = String.format("%s," + x + ",%s,%s", i18n, licensePeriod, moduleCode.getSort());
                    }
                }
            }
        } else if (module == Module.MODULE_VIS) {
            String displayVisPlaceControlCount = LicenseUtil.getLicenseContext().getVisPlaceControlCountDisplayStr();
            String commonPointsStr = "${common_entries}";
            licInfoStr = String.format("%s,%s%s %s%s,%s,%s", i18n, displayVisPlaceControlCount, commonPointsStr, moduleBean.getDefaultControlCount(), pointUnit, licensePeriod, moduleCode.getSort());
        } else if (module == Module.MODULE_ELE_DCS) {
            String brand = "${ele_manufacturer}";
            licInfoStr = String.format("%s,%s: %s,%s,%s", i18n, brand, this.buildEleDcsBrand(moduleBean.getDefaultControlCount()), licensePeriod, moduleCode.getSort());
        } else if (module == Module.MODULE_VID && LicenseCheckUtil.isSupportOnvif()) {
            licInfoStr = String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit + " (" + "${auth_license_support_onvif}" + ")", licensePeriod, moduleCode.getSort());
        } else if (module == Module.MODULE_VMS && LicenseCheckUtil.isVmsSupportOnvif()) {
            licInfoStr = String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit + " (" + "${auth_license_support_onvif}" + ")", licensePeriod, moduleCode.getSort());
        } else if (!LicenseUtil.isLocal() && module == Module.MODULE_ACC_PUSH) {
            String commonDeviceStr = "${common_devices}";
            int pullCount = LicenseUtil.getLicenseContext().getControlCount(Module.MODULE_ACC_PULL.getCode());
            licInfoStr = pullCount > 0 ? String.format("%s,%s%s(${auth_license_include_max} %s PULL %s),%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit, pullCount, commonDeviceStr, licensePeriod, moduleCode.getSort()) : String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit, licensePeriod, moduleCode.getSort());
        } else {
            licInfoStr = (module == Module.MODULE_VID || module == Module.MODULE_VMS) && !LicenseUtil.isLocal() && moduleBean.isTrial() ? String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit + " (" + "${auth_license_support_onvif}" + ")", licensePeriod, moduleCode.getSort()) : String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit, licensePeriod, moduleCode.getSort());
            if (moduleBean.licenseAvaiable()) {
                if (module == Module.MODULE_SYSTEM_PERS) {
                    licInfoStr = "ZKBioCVSecurityFoundation".equals(productCode) ? String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit, licensePeriod, moduleCode.getSort()) : String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount() * 1000, pointUnit, licensePeriod, moduleCode.getSort());
                } else if (module == Module.MODULE_SYSTEM_AREA || module == Module.MODULE_SYSTEM_DEPARTMENT) {
                    licInfoStr = "ZKBioCVSecurityFoundation".equals(productCode) ? String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount(), pointUnit, licensePeriod, moduleCode.getSort()) : String.format("%s,%s%s,%s,%s", i18n, moduleBean.getDefaultControlCount() * 100, pointUnit, licensePeriod, moduleCode.getSort());
                }
            }
        }
        return licInfoStr;
    }

    public String buildEleDcsBrand(Integer controlCount) {
        EleDcsBrand eleDcsBrand = EleDcsBrand.getEleDcsBrand(controlCount);
        if (Objects.nonNull((Object)eleDcsBrand)) {
            return eleDcsBrand.getBrand();
        }
        return "<span style='color:red;'>x</span>";
    }

    public static enum EleDcsBrand {
        All(31, "Kone Mitsubishi Hitachi OTis Schindler"),
        Kone(1, "Kone"),
        Mitsubishi(2, "Mitsubishi"),
        Hitachi(4, "Hitachi"),
        OTis(8, "OTis"),
        Schindler(16, "Schindler"),
        CONTAINSTWO1(3, "Kone Mitsubishi"),
        CONTAINSTWO2(5, "Kone Hitachi"),
        CONTAINSTWO3(9, "Kone OTis"),
        CONTAINSTWO4(17, "Kone Schindler"),
        CONTAINSTWO5(6, "Mitsubishi Hitachi"),
        CONTAINSTWO6(10, "Mitsubishi OTis"),
        CONTAINSTWO7(18, "Mitsubishi Schindler"),
        CONTAINSTWO8(12, "Hitachi OTis"),
        CONTAINSTWO9(20, "Hitachi Schindler"),
        CONTAINSTWO10(24, "OTis Schindler"),
        CONTAINSTHREE1(7, "Kone Mitsubishi Hitachi"),
        CONTAINSTHREE2(11, "Kone Mitsubishi OTis"),
        CONTAINSTHREE3(19, "Kone Mitsubishi Schindler"),
        CONTAINSTHREE4(13, "Kone Hitachi OTis"),
        CONTAINSTHREE5(21, "Kone Hitachi Schindler"),
        CONTAINSTHREE6(25, "Kone OTis Schindler"),
        CONTAINSTHREE7(14, "Mitsubishi Hitachi OTis"),
        CONTAINSTHREE8(22, "Mitsubishi Hitachi Schindler"),
        CONTAINSTHREE9(26, "Mitsubishi OTis Schindler"),
        CONTAINSTHREE10(28, "Hitachi OTis Schindler"),
        CONTAINSFOUR1(15, "Kone Mitsubishi Hitachi OTis"),
        CONTAINSFOUR2(29, "Kone Hitachi OTis Schindler"),
        CONTAINSFOUR3(30, "Mitsubishi Hitachi OTis Schindler"),
        CONTAINSFOUR4(27, "Kone Mitsubishi OTis Schindler"),
        CONTAINSFOUR5(23, "Kone Mitsubishi Hitachi Schindler");

        private Integer controlCount;
        private String brand;

        private EleDcsBrand(Integer controlCount, String brand) {
            this.controlCount = controlCount;
            this.brand = brand;
        }

        public String getBrand() {
            return this.brand;
        }

        public Integer getControlCount() {
            return this.controlCount;
        }

        public static EleDcsBrand getEleDcsBrand(Integer controlCount) {
            for (EleDcsBrand eleDcsBrand : EleDcsBrand.values()) {
                if (!eleDcsBrand.getControlCount().equals(controlCount)) continue;
                return eleDcsBrand;
            }
            return null;
        }
    }
}

