/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.biz;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.zkteco.guard.foldex.helper.MD5Helper;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.HttpUtil;
import com.zkteco.zkbiosecurity.guard.LicenseContextUtil;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.Continent;
import com.zkteco.zkbiosecurity.guard.license.bean.LicCompany;
import com.zkteco.zkbiosecurity.guard.license.bean.LicError;
import com.zkteco.zkbiosecurity.guard.license.bean.LicInfo;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.guard.license.util.LicCheckUtilFacade;
import com.zkteco.zkbiosecurity.guard.license.util.LicFileHelper;
import com.zkteco.zkbiosecurity.guard.license.util.LicResetUtil;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class LicenseFileBiz {
    private static final Logger log = LoggerFactory.getLogger(LicenseFileBiz.class);
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    @Autowired(required=false)
    private LicenseCheckInnerInvoke[] licenseCheckInnerInvoke;
    @Autowired
    private Environment environment;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${system.version:1.0.0_R}")
    private String systemVersion;
    @Value(value="${system.productCode:ZKBioSecurity}")
    private String productCode;
    @Value(value="${system.licAuthUrl:/authController.do?fileOnlineActiveAuth}")
    private String licAuthUrl;
    @Value(value="${system.licUpdateUrl:/downloadController.do?updateLicense}")
    private String licUpdateUrl;
    @Value(value="${system.licUnbindOnlineUrl:/authController.do?fileOnlineReset}")
    private String licUnbindOnlineUrl;

    public void cancelLicense() {
        LicFileHelper.deleteLicFile();
        LicenseUtil.reloadLicense(this.moduleAuths);
        LicenseContextUtil.setValue("companyName", "");
        LicenseContextUtil.setValue("companyEmailToken", "");
        try {
            if (this.licenseCheckInnerInvoke != null) {
                for (LicenseCheckInnerInvoke checkInnerInvoke : this.licenseCheckInnerInvoke) {
                    checkInnerInvoke.cancelLicence();
                }
            }
        }
        catch (ZKBusinessException e) {
            log.info(e.getMessage());
        }
    }

    public boolean hasLicenseId() {
        String id = LicFileHelper.readLicId(LicFileHelper.getLicPath());
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id});
    }

    public String combineModuleVersion() {
        return "base:" + this.systemVersion;
    }

    public void validateLicense(boolean isValidate, String companyName, String license) {
        this.validateLicenseInfo(isValidate, companyName, license, false);
    }

    public void validateSn(boolean isValidate, String companyName, String sn) {
        this.validateLicenseInfo(isValidate, companyName, sn, true);
    }

    public void validateLicenseInfo(boolean isValidate, String companyName, String licInfo, boolean isSn) {
        String platFormVersion = this.environment.getProperty("base.version");
        ModuleBean moduleBean = null;
        moduleBean = isSn ? LicCheckUtilFacade.getSnModuleBean(licInfo) : LicCheckUtilFacade.getLicenseModuleBean(licInfo);
        if (moduleBean != null) {
            int crcSn;
            int crcM;
            Boolean flag = false;
            try {
                if (this.applicationContext.containsBean("industryCodeUtil")) {
                    Object object = this.applicationContext.getBean("industryCodeUtil");
                    Method method = object.getClass().getDeclaredMethod("getIndustryCode", new Class[0]);
                    method.setAccessible(true);
                    if (moduleBean.getExtCode() != 1 && moduleBean.getExtCode() != ((Integer)method.invoke(object, new Object[0])).intValue()) {
                        flag = true;
                    }
                }
            }
            catch (Exception object) {
                // empty catch block
            }
            if (flag.booleanValue()) {
                throw new ZKBusinessException("LicenseError:E0011");
            }
            if ("ZKBioCVServerV6000".equals(this.productCode) && "devtotalcount".equals(Module.getById(moduleBean.getModule()).getCode()) && moduleBean.getSystemOperInfo() != moduleBean.getMajor()) {
                log.error("The license information does not match " + moduleBean.getSystemProcessor() + ",and license need match " + ModuleCode.processor);
                throw new ZKBusinessException("LicenseError:E0011");
            }
            if (!isValidate && LicenseUtil.isLocal() && !"ZKBioCVServerV6600".equals(this.productCode) && !"ZKBioCVServerV6000".equals(this.productCode) && (crcM = LicCheckUtilFacade.genCRC16(companyName)) != (crcSn = moduleBean.getCompanyNameCrc16())) {
                throw new ZKBusinessException("auth_license_companyNameCheckError");
            }
            if (!LicenseUtil.langMatch(moduleBean.getLanguagePack())) {
                throw new ZKBusinessException("LicenseError:E0011");
            }
            return;
        }
        throw new ZKBusinessException("LicenseError:E0008");
    }

    public void postLicinfoRecept(LicInfo licInfoRece, boolean validate) {
        String licID = LicFileHelper.readLicId(LicFileHelper.getLicPath());
        if (licID != null && !"".equals(licID) && !licInfoRece.getId().replaceAll("\r|\n", "").equals(licID)) {
            throw ZKBusinessException.warnException((String)"auth_license_erretxt_repeatid", (Object[])new Object[]{licID, licInfoRece.getId().replaceAll("\r|\n", "")});
        }
        String errorMsg = this.processLicenseError(licInfoRece);
        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
            throw new ZKBusinessException(errorMsg);
        }
        if (licInfoRece == null || licInfoRece.getModules() == null || licInfoRece.getModules().isEmpty()) {
            throw new ZKBusinessException("auth_license_moduleEmpty");
        }
        LicCompany company = licInfoRece.getCompany();
        if (StringUtils.isBlank((CharSequence)company.getName())) {
            throw new ZKBusinessException("auth_license_incompleteCompanyInfo");
        }
        List<LicModule> modules = licInfoRece.getModules();
        for (LicModule module : modules) {
            this.validateLicense(validate, company.getName(), module.getLicenseNumber());
        }
        LicFileHelper.updateModules(LicFileHelper.getLicPath(), modules);
        company.setValidate(true);
        LicFileHelper.writeLicCompany(LicFileHelper.getLicPath(), company);
        LicFileHelper.writeLicUidCard(LicFileHelper.getLicPath(), licInfoRece.getUidcard());
        LicFileHelper.writeLicId(LicFileHelper.getLicPath(), licInfoRece.getId());
        LicFileHelper.writeLicDns(LicFileHelper.getLicPath(), licInfoRece.getDns());
        LicFileHelper.writeLicFlag(LicFileHelper.getLicPath(), licInfoRece.getFlag());
        this.postLicRsainfoRecept(licInfoRece);
        log.info("update license info to lic file ....");
        try {
            LicenseUtil.reloadLicense(this.moduleAuths);
            LicenseContextUtil.setValue("companyName", company.getName());
            LicenseContextUtil.setValue("client_licenseId", LicFileHelper.readLicId(LicFileHelper.getLicPath()));
            LicenseContextUtil.setValue("client_company", company);
            LicenseContextUtil.setValue("companyEmailToken", company.getEmail());
            try {
                if (this.licenseCheckInnerInvoke != null) {
                    for (LicenseCheckInnerInvoke checkInnerInvoke : this.licenseCheckInnerInvoke) {
                        checkInnerInvoke.activateSuccess();
                    }
                }
            }
            catch (ZKBusinessException e) {
                log.info(e.getMessage());
            }
            log.info("reload license to system ....");
        }
        catch (Exception ex) {
            throw new ZKBusinessException("auth_license_reloadFailed", (Throwable)ex);
        }
    }

    private String processLicenseError(LicInfo licInfoRece) {
        if (licInfoRece != null && licInfoRece.getErrors() != null) {
            List<LicError> errors = licInfoRece.getErrors();
            String errMsg = null;
            if (!errors.isEmpty()) {
                errMsg = "LicenseError:";
                HashSet es = Sets.newHashSet();
                if (!errors.isEmpty()) {
                    for (LicError error : errors) {
                        if (StringUtils.isNotBlank((CharSequence)error.getMessage())) {
                            es.add(error.getCode() + "[" + error.getMessage() + "]");
                        } else {
                            es.add(error.getCode());
                        }
                        es.add(error.getCode() + "[" + error.getMessage() + "]");
                    }
                }
                for (String e : es) {
                    errMsg = errMsg + e + ",";
                }
                errMsg = errMsg.substring(0, errMsg.length() - 1);
            }
            return errMsg;
        }
        return null;
    }

    public List<SelectItem> getLicenseContinents(String ... continentCode) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        Object item = null;
        Object pItem = null;
        String code = null;
        if (continentCode != null && continentCode.length > 0) {
            code = continentCode[0];
        }
        for (Continent continent : Continent.values()) {
            SelectItem selectBean = new SelectItem();
            selectBean.setValue(continent.getCode());
            selectBean.setText((Object)continent.getI18n());
            items.add(selectBean);
        }
        return items;
    }

    public boolean noNeedToPrompt() {
        String promptDaysStr = this.environment.getProperty("license.prompt.days");
        int promptDays = Integer.parseInt(StringUtils.isBlank((CharSequence)promptDaysStr) ? "3" : promptDaysStr);
        int maxLicenseLeft = LicenseUtil.getLicenseContext().getMaxLicenseLeft();
        if (maxLicenseLeft > promptDays) {
            return true;
        }
        int trialLeft = LicenseUtil.getLicenseContext().getTrialLeft();
        return trialLeft > promptDays;
    }

    public String getEmailValidateCode(String email) {
        String emailSendUrl = this.environment.getProperty("licenseEmailUrl");
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("email", email);
        String rsp = HttpUtil.post((String)emailSendUrl, (Map)params);
        return rsp;
    }

    public String postUpk(LicInfo licInfo) {
        ConcurrentMap params = Maps.newConcurrentMap();
        String req = JSONObject.toJSONString((Object)licInfo);
        log.debug("req of post upk to license server: " + req);
        params.put("xmlInfo", req);
        String url = this.environment.getProperty("licenseAuthUrl");
        if (StringUtils.isNotBlank((CharSequence)licInfo.getDns())) {
            url = licInfo.getDns() + this.licAuthUrl;
        }
        log.debug(url);
        try {
            HttpUtil.Response rsp = HttpUtil.postAsResponse((String)url, (Map)params);
            log.debug("rsp of post upk from license server:\r\n " + rsp.getStringContent());
            if (rsp.getStatusLine().getStatusCode() != 200) {
                log.error("get upk exception in license server!");
                throw new ZKBusinessException("400", "auth_license_serverError");
            }
            return rsp.getStringContent();
        }
        catch (Exception e) {
            throw new ZKBusinessException("auth_login_licenseConnError4", (Throwable)e);
        }
    }

    public String getLicenseUpdate() {
        String id = LicFileHelper.readLicId(LicFileHelper.getLicPath());
        HashMap params = Maps.newHashMap();
        params.put("licenseID", id);
        log.info("licenseID of getLicenseUpdate: " + id);
        String url = this.environment.getProperty("licenseUpdateUrl");
        String licDns = LicFileHelper.readLicDns(LicFileHelper.getLicPath());
        if (StringUtils.isNotBlank((CharSequence)licDns)) {
            url = licDns + this.licUpdateUrl;
        }
        HttpUtil.Response rsp = HttpUtil.postAsResponse((String)url, (Map)params);
        log.info("rsp of getLicenseUpdate: \r\n" + rsp.getStringContent());
        if (rsp.getStatusLine().getStatusCode() != 200) {
            log.error("getLicenseUpdate exception in license server!");
            throw new ZKBusinessException("400", "auth_license_serverError");
        }
        return rsp.getStringContent();
    }

    public void postLicRsainfoRecept(LicInfo licInfo) {
        if ("ZKBioCVServerV6000".equals(this.productCode) || "ZKBioCVServerV6600".equals(this.productCode)) {
            if (StringUtils.isBlank((CharSequence)licInfo.getLicensePrivateKey()) || StringUtils.isBlank((CharSequence)licInfo.getLicensePublicKey())) {
                throw new ZKBusinessException("LicenseError:E0011");
            }
            String enPriKey = StringUtils.trimToNull((String)licInfo.getLicensePrivateKey());
            String enPubKey = StringUtils.trimToNull((String)licInfo.getLicensePublicKey());
            try {
                String licenseId = MD5Helper.encrypt32((String)StringUtils.trimToNull((String)licInfo.getId()));
                FoldexUtil.decryptAESB64((String)licenseId, (String)licenseId.substring(8, 24), (String)enPriKey);
                FoldexUtil.decryptAESB64((String)licenseId, (String)licenseId.substring(8, 24), (String)enPubKey);
            }
            catch (Exception e) {
                log.error(" The license file RSA key was tampered");
                throw new ZKBusinessException("LicenseError:E0011");
            }
            LicFileHelper.writeLicPrivateKey(LicFileHelper.getLicPath(), enPriKey);
            LicFileHelper.writeLicPublicKey(LicFileHelper.getLicPath(), enPubKey);
        }
    }

    public void postLicRsaCheck(LicInfo licInfo) {
        if ("ZKBioCVServerV6000".equals(this.productCode) || "ZKBioCVServerV6600".equals(this.productCode)) {
            if (StringUtils.isBlank((CharSequence)licInfo.getLicensePrivateKey()) || StringUtils.isBlank((CharSequence)licInfo.getLicensePublicKey())) {
                throw new ZKBusinessException("LicenseError:E0011");
            }
            try {
                String licenseId = MD5Helper.encrypt32((String)StringUtils.trimToNull((String)licInfo.getId()));
                FoldexUtil.decryptAESB64((String)licenseId, (String)licenseId.substring(8, 24), (String)licInfo.getLicensePrivateKey());
                FoldexUtil.decryptAESB64((String)licenseId, (String)licenseId.substring(8, 24), (String)licInfo.getLicensePublicKey());
            }
            catch (Exception e) {
                log.error(" The license file RSA key was tampered");
                throw new ZKBusinessException("LicenseError:E0011");
            }
        }
    }

    public void validateLicenseReset(String licId, LicInfo licInfoRece) {
        String flag;
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{licId}) && LicResetUtil.getLicResetIdentity(licId) && (StringUtils.isBlank((CharSequence)(flag = LicFileHelper.decrypt(licInfoRece.getFlag(), "ZKTeco#.2022@Lic"))) || LicResetUtil.checkLicenseIsDisable(licId, flag))) {
            log.error("validateLicenseReset: The license file has been marked as invalid!  licenseId:" + licId + " flag:" + flag);
            throw new ZKBusinessException("LicenseError:E0011");
        }
    }

    public LicInfo unbindOnline(LicInfo licInfo) {
        ConcurrentMap params = Maps.newConcurrentMap();
        String req = JSONObject.toJSONString((Object)licInfo);
        params.put("xmlInfo", req);
        String url = this.environment.getProperty("licenseUnbindOnlineUrl");
        String licDns = LicFileHelper.readLicDns(LicFileHelper.getLicPath());
        if (StringUtils.isNotBlank((CharSequence)licDns)) {
            url = licDns + this.licUnbindOnlineUrl;
        }
        HttpUtil.Response rsp = HttpUtil.postAsResponse((String)url, (Map)params);
        log.info("rsp of unbindOnline: \r\n" + rsp.getStringContent());
        if (rsp.getStatusLine().getStatusCode() != 200) {
            log.error("unbindOnline exception in license server!");
            throw new ZKBusinessException("400", "auth_license_serverError");
        }
        String rspStr = rsp.getStringContent();
        LicInfo licInfoRece = (LicInfo)JSONObject.parseObject((String)rspStr, LicInfo.class);
        String errorMsg = this.processLicenseError(licInfoRece);
        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
            throw new ZKBusinessException(errorMsg);
        }
        return licInfoRece;
    }
}

