/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.biz;

import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.core.utils.HttpUtil;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.util.LicFileHelper;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class LicenseCheckBiz
implements SchedulingConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(LicenseCheckBiz.class);
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    @Autowired(required=false)
    private LicenseCheckInnerInvoke[] licenseCheckInnerInvoke;
    @Value(value="${licenseCheckLicenseUrl}")
    private String licenseCheckLicenseUrl;
    private static String LICENSE_CHECK_TASK = "59 59 23 * * ?";

    public void check() {
        logger.info("start license check-------------");
        List<LicModule> modules = LicFileHelper.readLicModules(LicFileHelper.getLicPath());
        if (modules != null && !modules.isEmpty()) {
            for (LicModule module : modules) {
                if (StringUtils.isBlank((CharSequence)module.getLicenseNumber()) || this.checkLicenseNumber(module.getLicenseNumber())) continue;
                logger.info(String.format("check licenseNumber:%s  failed", module.getLicenseNumber()));
                logger.info("cancel other operate after license delate...");
                LicenseUtil.cancelOtherOperate(this.licenseCheckInnerInvoke);
                logger.info("expired license...");
                LicenseUtil.expiredLicense();
                LicenseUtil.licenseCheckExpired(this.licenseCheckInnerInvoke);
                logger.info("clean license info...");
                LicFileHelper.cleanLicCompanyAndLicense();
                logger.info("reload license");
                LicenseUtil.reloadLicense(this.moduleAuths);
                break;
            }
        }
    }

    public void checkLicense() {
        logger.info("start license check-------------");
        List<LicModule> modules = LicFileHelper.readLicModules(LicFileHelper.getLicPath());
        if (modules != null && !modules.isEmpty()) {
            LicenseUtil.reloadLicense(this.moduleAuths);
        }
    }

    private boolean checkLicenseNumber(String licenseNumber) {
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("license", licenseNumber);
        try {
            String rsp = HttpUtil.post((String)this.licenseCheckLicenseUrl, (Map)params);
            if (StringUtils.equalsIgnoreCase((CharSequence)rsp, (CharSequence)"false")) {
                return false;
            }
            logger.debug(String.format("check licenseNumber:%s ol success", licenseNumber));
        }
        catch (Exception e) {
            logger.info("check licenseNumber Exception");
        }
        return true;
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(() -> this.checkLicense(), triggerContext -> {
            logger.info(" trigger cron config " + LICENSE_CHECK_TASK);
            CronTrigger trigger = new CronTrigger(LICENSE_CHECK_TASK);
            return trigger.nextExecutionTime(triggerContext);
        });
    }
}

