/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.client.service;

import com.zkteco.business.sdk.request.auth.ApiAuthAreaAddListRequest;
import com.zkteco.business.sdk.request.auth.ApiAuthAreaDeleteRequest;
import com.zkteco.business.sdk.request.auth.ApiAuthDepartmentAddListRequest;
import com.zkteco.business.sdk.request.auth.ApiAuthDepartmentDeleteRequest;
import com.zkteco.business.sdk.request.auth.ApiAuthDepartmentGetListRequest;
import com.zkteco.business.sdk.request.pers.ApiPersParamsAddRequest;
import com.zkteco.business.sdk.vo.ApiAuthAreaItem;
import com.zkteco.business.sdk.vo.ApiAuthDepartmentItem;
import com.zkteco.business.sdk.vo.ApiPersParamsItem;
import com.zkteco.cloud.sdk.BaseRequest;
import com.zkteco.cloud.sdk.DefaultZKCloudClient;
import com.zkteco.cloud.sdk.ZKCouldClient;
import com.zkteco.cloud.sdk.resp.ListResponse;
import com.zkteco.cloud.sdk.resp.ObjectResponse;
import com.zkteco.cloud.sdk.response.ApiAuthTokenResponse;
import com.zkteco.cloud.sdk.util.ZKCloudApiTokenUtil;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ModelUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.SystemPersInfo2CloudService;
import com.zkteco.zkbiosecurity.system.utils.ConnectUtil;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BaseAuthCloudMessageSendServiceImpl
implements BaseAuthCloudMessageSendService {
    private static final Logger log = LoggerFactory.getLogger(BaseAuthCloudMessageSendServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired(required=false)
    private SystemPersInfo2CloudService pers2CloudService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Value(value="${cloud.server.upload.url:https://zkcloud.xmzkteco.com/BiosecurityApp/router/rest}")
    private String serverUrl;

    public ZKCouldClient getSendMsgClient() {
        String appId = this.baseLicenseService.getAppId();
        String appKey = this.baseSysParamService.getValByName("zkteco:cloud:appkey");
        DefaultZKCloudClient couldClient = new DefaultZKCloudClient(this.serverUrl, appId, appKey);
        return couldClient;
    }

    public ZKResultMsg sendAuthDepartmentToCloud(List<ApiAuthDepartmentItem> apiAuthDepartmentItemList) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (this.isMasterApp() && !CollectionUtil.isEmpty(apiAuthDepartmentItemList)) {
            StringBuffer msg = new StringBuffer();
            String token = this.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            List authDepartmentList = CollectionUtil.split(apiAuthDepartmentItemList, (int)100);
            for (List apiAuthDepartmentItems : authDepartmentList) {
                ApiAuthDepartmentAddListRequest apiAuthDepartmentAddListRequest = new ApiAuthDepartmentAddListRequest();
                apiAuthDepartmentAddListRequest.setApiAuthDepartmentItems(apiAuthDepartmentItems);
                try {
                    ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthDepartmentAddListRequest, token);
                    Integer ret = Integer.parseInt(rsp.getCode());
                    log.info("sendAuthDepartmentToCloud ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                    if (ret == -27) {
                        token = this.refreshToken();
                        rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthDepartmentAddListRequest, token);
                        ret = Integer.parseInt(rsp.getCode());
                    }
                    if (ret >= 0) continue;
                    String codes = CollectionUtil.getPropertys((Collection)apiAuthDepartmentItems, ApiAuthDepartmentItem::getCode);
                    msg.append(String.valueOf(codes) + ", " + "ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
                }
                catch (Exception e) {
                    log.error("sendAuthDepartmentToCloud error !", (Throwable)e);
                    String codes = CollectionUtil.getPropertys((Collection)apiAuthDepartmentItems, ApiAuthDepartmentItem::getCode);
                    msg.append(String.valueOf(codes) + ", " + I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
        }
        return resultMsg;
    }

    public ZKResultMsg delAuthDepartmentToCloud(List<String> authDeptCodeList) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (this.isMasterApp() && !CollectionUtil.isEmpty(authDeptCodeList)) {
            StringBuffer msg = new StringBuffer();
            String token = this.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            List authDeptCodes = CollectionUtil.split(authDeptCodeList, (int)100);
            for (List codes : authDeptCodes) {
                ArrayList<ApiAuthDepartmentItem> items = new ArrayList<ApiAuthDepartmentItem>();
                for (String code : codes) {
                    ApiAuthDepartmentItem apiAuthDepartmentItem = new ApiAuthDepartmentItem();
                    apiAuthDepartmentItem.setCode(code);
                    items.add(apiAuthDepartmentItem);
                }
                ApiAuthDepartmentDeleteRequest apiAuthDepartmentDeleteRequest = new ApiAuthDepartmentDeleteRequest();
                apiAuthDepartmentDeleteRequest.setApiAuthDepartmentItems(items);
                try {
                    ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthDepartmentDeleteRequest, token);
                    Integer ret = Integer.parseInt(rsp.getCode());
                    log.info("delAuthDepartmentToCloud ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                    if (ret == -27) {
                        token = this.refreshToken();
                        rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthDepartmentDeleteRequest, token);
                        ret = Integer.parseInt(rsp.getCode());
                    }
                    if (ret >= 0) continue;
                    String codeStr = CollectionUtil.getPropertys(items, ApiAuthDepartmentItem::getCode);
                    msg.append(String.valueOf(codeStr) + ", " + "ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
                }
                catch (Exception e) {
                    log.error("delAuthDepartmentToCloud error !", (Throwable)e);
                    String codeStr = CollectionUtil.getPropertys(items, ApiAuthDepartmentItem::getCode);
                    msg.append(String.valueOf(codeStr) + ", " + I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
        }
        return resultMsg;
    }

    public ZKResultMsg syncAuthDepartmentFromCloud(ApiAuthDepartmentItem apiAuthDepartmentItem) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        String token = this.createToken();
        log.info("------ getDepartment access_token ------- " + token);
        ZKCouldClient couldClient = this.getSendMsgClient();
        StringBuffer msg = new StringBuffer();
        ApiAuthDepartmentGetListRequest apiAuthDepartmentGetListRequest = new ApiAuthDepartmentGetListRequest();
        apiAuthDepartmentGetListRequest.setApiAuthDepartmentItem(apiAuthDepartmentItem);
        try {
            ListResponse rsp = (ListResponse)couldClient.execute((BaseRequest)apiAuthDepartmentGetListRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("getDepartment ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.refreshToken();
                rsp = (ListResponse)couldClient.execute((BaseRequest)apiAuthDepartmentGetListRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret < 0) {
                msg.append("ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
            } else {
                log.info("response : " + rsp.getList());
                if (!CollectionUtil.isEmpty((Collection)rsp.getList())) {
                    List authDepartmentItems = ModelUtil.copyListProperties((Collection)rsp.getList(), AuthDepartmentItem.class);
                    this.authDepartmentService.batchSaveItemFromCloud(authDepartmentItems);
                }
            }
        }
        catch (Exception e) {
            log.error("getDepartment error !", (Throwable)e);
            msg.append(String.valueOf(I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0])) + "!").append("</br>");
        }
        if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
            resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
        }
        return resultMsg;
    }

    public boolean isMasterApp() {
        return "1".equals(this.baseSysParamService.getValByName("zkteco:cloud:app:relation"));
    }

    public boolean isAllowSendBasicData() {
        boolean existAppId = StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId());
        return existAppId && this.isMasterApp();
    }

    public boolean isAllowSendBusinessData() {
        boolean isUploadBasic = this.baseSysParamService.getAlreadyInitModule("BasicData");
        return this.isExistAppId() && isUploadBasic;
    }

    public boolean isExistAppId() {
        return StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId());
    }

    public ZKResultMsg syncAllDepartmentToCloud() {
        List authDepartmentItemList = this.authDepartmentService.getByCondition(new AuthDepartmentItem());
        List<ApiAuthDepartmentItem> apiAuthDepartmentItems = this.buildApiDept(authDepartmentItemList);
        return this.sendAuthDepartmentToCloud(apiAuthDepartmentItems);
    }

    public ZKResultMsg syncAllAreaToCloud() {
        ArrayList rootAreaList = new ArrayList();
        List authAreaItemList = this.authAreaService.getByCondition(new AuthAreaItem());
        List deptCode = (List)CollectionUtil.getPropertyList((Collection)authAreaItemList, AuthAreaItem::getCode, (Object)"-1");
        Map<String, List<AuthAreaItem>> deptMap = authAreaItemList.stream().filter(item -> {
            if (StringUtils.isBlank((CharSequence)item.getParentAreaCode()) || !deptCode.contains(item.getParentAreaCode())) {
                rootAreaList.add(item);
                return false;
            }
            return true;
        }).collect(Collectors.groupingBy(AuthAreaItem::getParentAreaCode));
        List apiAuthDepartmentItems = ModelUtil.copyListProperties(rootAreaList, ApiAuthAreaItem.class);
        for (AuthAreaItem authAreaItem : rootAreaList) {
            if (deptMap.get(authAreaItem.getCode()) == null || deptMap.get(authAreaItem.getCode()).isEmpty()) continue;
            apiAuthDepartmentItems.addAll(this.buildChildArea(authAreaItem, deptMap));
        }
        this.sendAuthAreaToCloud(apiAuthDepartmentItems);
        return ZKResultMsg.successMsg();
    }

    private List<ApiAuthAreaItem> buildChildArea(AuthAreaItem authAreaItem, Map<String, List<AuthAreaItem>> deptMap) {
        List<AuthAreaItem> childrenAreaList = deptMap.get(authAreaItem.getCode());
        ArrayList<ApiAuthAreaItem> apiAuthDepartmentItems = new ArrayList<ApiAuthAreaItem>();
        if (childrenAreaList == null || childrenAreaList.isEmpty()) {
            return apiAuthDepartmentItems;
        }
        for (AuthAreaItem item : childrenAreaList) {
            ArrayList<ApiAuthAreaItem> authAreaItems = new ArrayList<ApiAuthAreaItem>();
            ApiAuthAreaItem apiAuthAreaItem = new ApiAuthAreaItem();
            apiAuthAreaItem.setCode(item.getCode());
            apiAuthAreaItem.setName(item.getName());
            apiAuthAreaItem.setParentAreaCode(item.getParentAreaCode());
            authAreaItems.add(apiAuthAreaItem);
            if (deptMap.get(item.getCode()) != null && !deptMap.get(item.getCode()).isEmpty()) {
                authAreaItems.addAll(this.buildChildArea(item, deptMap));
            }
            apiAuthDepartmentItems.addAll(authAreaItems);
        }
        return apiAuthDepartmentItems;
    }

    public List<ApiAuthDepartmentItem> getUploadDepartmentBytime(Date lastUpdate) {
        AuthDepartmentItem authDepartmentItem = new AuthDepartmentItem();
        authDepartmentItem.setUpdateAfter(lastUpdate);
        List authDepartmentItems = this.authDepartmentService.getByCondition(authDepartmentItem);
        return this.buildApiDept(authDepartmentItems);
    }

    public ZKResultMsg sendAuthAreaToCloud(List<ApiAuthAreaItem> apiAuthAreaItemList) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        boolean isUploadBasic = this.baseSysParamService.getAlreadyInitModule("BasicData");
        if (!CollectionUtil.isEmpty(apiAuthAreaItemList)) {
            StringBuffer msg = new StringBuffer();
            String token = this.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            List authAreaList = CollectionUtil.split(apiAuthAreaItemList, (int)100);
            for (List apiAuthAreaItems : authAreaList) {
                ApiAuthAreaAddListRequest apiAuthAreaAddListRequest = new ApiAuthAreaAddListRequest();
                apiAuthAreaAddListRequest.setApiAuthAreaItemList(apiAuthAreaItems);
                try {
                    ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthAreaAddListRequest, token);
                    Integer ret = Integer.parseInt(rsp.getCode());
                    log.info("sendAuthAreaToCloud ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                    if (ret == -27) {
                        token = this.refreshToken();
                        rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthAreaAddListRequest, token);
                        ret = Integer.parseInt(rsp.getCode());
                    }
                    if (ret >= 0) continue;
                    String codes = CollectionUtil.getPropertys((Collection)apiAuthAreaItems, ApiAuthAreaItem::getCode);
                    msg.append(String.valueOf(codes) + ", " + "ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
                }
                catch (Exception e) {
                    log.error("sendAuthAreaToCloud error !", (Throwable)e);
                    String codes = CollectionUtil.getPropertys((Collection)apiAuthAreaItems, ApiAuthAreaItem::getCode);
                    msg.append(String.valueOf(codes) + ", " + I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
        }
        return resultMsg;
    }

    private List<ApiAuthDepartmentItem> buildApiDept(List<AuthDepartmentItem> authDepartmentItemList) {
        List<Object> apiAuthDepartmentItems = new ArrayList<ApiAuthDepartmentItem>();
        if (!CollectionUtil.isEmpty(authDepartmentItemList)) {
            ArrayList rootDeptList = new ArrayList();
            List deptCode = (List)CollectionUtil.getPropertyList(authDepartmentItemList, AuthDepartmentItem::getCode, (Object)"-1");
            Map<String, List<AuthDepartmentItem>> deptMap = authDepartmentItemList.stream().filter(item -> {
                if (StringUtils.isBlank((CharSequence)item.getParentCode()) || !deptCode.contains(item.getParentCode())) {
                    rootDeptList.add(item);
                    return false;
                }
                return true;
            }).collect(Collectors.groupingBy(AuthDepartmentItem::getParentCode));
            apiAuthDepartmentItems = ModelUtil.copyListProperties(rootDeptList, ApiAuthDepartmentItem.class);
            for (AuthDepartmentItem departmentItem : rootDeptList) {
                if (deptMap.get(departmentItem.getCode()) == null || deptMap.get(departmentItem.getCode()).isEmpty()) continue;
                apiAuthDepartmentItems.addAll(this.buildChildDeptTree(departmentItem, deptMap));
            }
        }
        return apiAuthDepartmentItems;
    }

    private List<ApiAuthDepartmentItem> buildChildDeptTree(AuthDepartmentItem departmentItem, Map<String, List<AuthDepartmentItem>> deptMap) {
        List<AuthDepartmentItem> childrenDeptList = deptMap.get(departmentItem.getCode());
        ArrayList<ApiAuthDepartmentItem> apiAuthDepartmentItems = new ArrayList<ApiAuthDepartmentItem>();
        if (childrenDeptList == null || childrenDeptList.isEmpty()) {
            return apiAuthDepartmentItems;
        }
        for (AuthDepartmentItem item : childrenDeptList) {
            ArrayList<ApiAuthDepartmentItem> departmentItems = new ArrayList<ApiAuthDepartmentItem>();
            ApiAuthDepartmentItem apiAuthDepartmentItem = new ApiAuthDepartmentItem();
            apiAuthDepartmentItem.setCode(item.getCode());
            apiAuthDepartmentItem.setName(item.getName());
            apiAuthDepartmentItem.setParentCode(item.getParentCode());
            departmentItems.add(apiAuthDepartmentItem);
            if (deptMap.get(item.getCode()) != null && !deptMap.get(item.getCode()).isEmpty()) {
                departmentItems.addAll(this.buildChildDeptTree(item, deptMap));
            }
            apiAuthDepartmentItems.addAll(departmentItems);
        }
        return apiAuthDepartmentItems;
    }

    public ZKResultMsg delAuthAreaToCloud(List<String> authAreaCodeList) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        boolean isUploadBasic = this.baseSysParamService.getAlreadyInitModule("BasicData");
        if (isUploadBasic && !CollectionUtil.isEmpty(authAreaCodeList)) {
            StringBuffer msg = new StringBuffer();
            String token = this.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            List authAreaCodes = CollectionUtil.split(authAreaCodeList, (int)100);
            for (List codes : authAreaCodes) {
                ArrayList<ApiAuthAreaItem> items = new ArrayList<ApiAuthAreaItem>();
                for (String code : codes) {
                    ApiAuthAreaItem apiAuthAreaItem = new ApiAuthAreaItem();
                    apiAuthAreaItem.setCode(code);
                    items.add(apiAuthAreaItem);
                }
                ApiAuthAreaDeleteRequest apiAuthAreaDeleteRequest = new ApiAuthAreaDeleteRequest();
                apiAuthAreaDeleteRequest.setApiAuthAreaItemList(items);
                try {
                    ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthAreaDeleteRequest, token);
                    Integer ret = Integer.parseInt(rsp.getCode());
                    log.info("delAuthAreaToCloud ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                    if (ret == -27) {
                        token = this.refreshToken();
                        rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiAuthAreaDeleteRequest, token);
                        ret = Integer.parseInt(rsp.getCode());
                    }
                    if (ret >= 0) continue;
                    String codeStr = CollectionUtil.getPropertys(items, ApiAuthAreaItem::getCode);
                    msg.append(String.valueOf(codeStr) + ", " + "ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
                }
                catch (Exception e) {
                    log.error("delAuthAreaToCloud error !", (Throwable)e);
                    String codeStr = CollectionUtil.getPropertys(items, ApiAuthAreaItem::getCode);
                    msg.append(String.valueOf(codeStr) + ", " + I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
        }
        return resultMsg;
    }

    public String createToken() {
        String accessToken = this.baseSysParamService.getValByName("base.accessToken");
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            accessToken = this.createNewToken();
        }
        return accessToken;
    }

    public String createNewToken() {
        String appKey;
        ZKCouldClient couldClient = this.getSendMsgClient();
        ApiAuthTokenResponse apiAuthTokenResponse = ZKCloudApiTokenUtil.authTokenCreateRequest((ZKCouldClient)couldClient, (String)(appKey = this.baseSysParamService.getValByName("zkteco:cloud:appkey")), (String)"client_credential");
        if (apiAuthTokenResponse == null) {
            throw ZKBusinessException.errorException((String)"system_connect_server_fail", (Object[])new Object[0]);
        }
        String accessToken = apiAuthTokenResponse.getAccess_token();
        this.baseSysParamService.saveValueByName("base.accessToken", accessToken);
        this.baseSysParamService.saveValueByName("base.refreshToken", apiAuthTokenResponse.getRefresh_token());
        return accessToken;
    }

    public String refreshToken() {
        ZKCouldClient couldClient = this.getSendMsgClient();
        String accessToken = null;
        String refreshToken = this.baseSysParamService.getValByName("base.accessToken");
        if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
            ApiAuthTokenResponse apiAuthTokenResponse = ZKCloudApiTokenUtil.authTokenRefreshRequest((ZKCouldClient)couldClient, (String)"refresh_token", (String)refreshToken);
            if (apiAuthTokenResponse == null) {
                accessToken = this.createNewToken();
            } else {
                accessToken = apiAuthTokenResponse.getAccess_token();
                refreshToken = apiAuthTokenResponse.getRefresh_token();
                this.baseSysParamService.saveValueByName("base.accessToken", accessToken);
                this.baseSysParamService.saveValueByName("base.refreshToken", refreshToken);
            }
        } else {
            accessToken = this.createNewToken();
        }
        return accessToken;
    }

    public ZKResultMsg syncBasicDataToCloud() {
        if (this.baseAuthCloudMessageSendService.isAllowSendBasicData()) {
            ZKResultMsg resultMsg = this.syncAllDepartmentToCloud();
            if (!"ok".equals(resultMsg.getRet())) {
                resultMsg.setMsg("system_api_upload_deptFail");
                return resultMsg;
            }
            if (this.pers2CloudService == null) {
                resultMsg.setMsg("system_api_upload_positionFail");
                return resultMsg;
            }
            resultMsg = this.pers2CloudService.syncAllPositionToCloud();
            if (!"ok".equals(resultMsg.getRet())) {
                resultMsg.setMsg("system_api_upload_positionFail");
                return resultMsg;
            }
            resultMsg = this.pers2CloudService.syncPersParamToCloud();
            if (!"ok".equals(resultMsg.getRet())) {
                resultMsg.setMsg("system_api_sync_paramFail");
                return resultMsg;
            }
            this.pers2CloudService.syncAllPersonToCloud();
            this.pers2CloudService.setPersonLastPushTime();
            this.syncSysParamToCloud();
            if (!this.baseSysParamService.getAlreadyInitModule("BasicData")) {
                this.baseSysParamService.setAlreadyInitModule("BasicData");
            }
        } else {
            return ZKResultMsg.failMsg((String)"system_not_register_cloud", (Object[])new Object[0]);
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg syncBasicDataFromCloud() {
        ZKResultMsg resultMsg;
        if (!this.isMasterApp() && this.isExistAppId()) {
            resultMsg = this.syncAuthDepartmentFromCloud(new ApiAuthDepartmentItem());
            if (!"ok".equals(resultMsg.getRet())) {
                resultMsg.setMsg("system_api_sync_deptFail");
                return resultMsg;
            }
            resultMsg = this.pers2CloudService.syncAllPositionFromCloud();
            if (!"ok".equals(resultMsg.getRet())) {
                resultMsg.setMsg("system_api_sync_positionFail");
                return resultMsg;
            }
            resultMsg = this.pers2CloudService.syncPersParamFromCloud();
            if (!"ok".equals(resultMsg.getRet())) {
                resultMsg.setMsg("system_api_sync_paramFail");
                return resultMsg;
            }
        } else {
            return ZKResultMsg.failMsg((String)"system_not_register_cloud", (Object[])new Object[0]);
        }
        this.pers2CloudService.notifyCloudSyncPersonData();
        this.syncSysParamToCloud();
        this.baseSysParamService.setAlreadyInitModule("BasicData");
        resultMsg = ZKResultMsg.successMsg();
        resultMsg.setMsg("system_sync_successAndWaitPersonData");
        return resultMsg;
    }

    public Boolean getwebsocketStaus() {
        return this.baseLicenseClientService.getwebsocketStaus();
    }

    public String getCloudChannelStatus() {
        String status = "0";
        if (!this.baseLicenseClientService.getwebsocketStaus().booleanValue()) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("zkteco:cloud:websocket:url");
            status = baseSysParamItem != null && StringUtils.isNotBlank((CharSequence)baseSysParamItem.getParamValue()) ? (!ConnectUtil.checkConnected((String)baseSysParamItem.getParamValue()) ? "2" : "1") : "1";
        }
        return status;
    }

    public ZKResultMsg syncSysParamToCloud() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId())) {
            ZKResultMsg resultMsg = ZKResultMsg.successMsg();
            StringBuffer msg = new StringBuffer();
            String token = this.baseAuthCloudMessageSendService.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            try {
                ApiPersParamsItem apiPersParamsItem = new ApiPersParamsItem();
                String algorithm = this.baseSysParamService.getValByName("qrcode.algorithm");
                String publicKey = this.baseSysParamService.getValByName("qrcode.publicKey");
                if (BaseDataConstants.QRCODE_ALGORITHM_ECIES.equals(algorithm)) {
                    publicKey = this.baseSysParamService.getValByName("qrcode.ECIES256PublicKey");
                }
                apiPersParamsItem.setQrcodeAlgorithm(algorithm);
                apiPersParamsItem.setQrcodePublicKey(publicKey);
                apiPersParamsItem.setQrcodeType(this.baseSysParamService.getValByName("qrcode.type"));
                apiPersParamsItem.setQrcodeValidTime(this.baseSysParamService.getValByName("qrcode.validTime"));
                apiPersParamsItem.setCheckMasterApp("false");
                ApiPersParamsAddRequest apiPersParamsAddRequest = new ApiPersParamsAddRequest();
                apiPersParamsAddRequest.setApiPersParamsItem(apiPersParamsItem);
                ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPersParamsAddRequest, token);
                Integer ret = Integer.parseInt(rsp.getCode());
                log.info("uploadSysParams ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                if (ret == -27) {
                    token = this.baseAuthCloudMessageSendService.refreshToken();
                    rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPersParamsAddRequest, token);
                    ret = Integer.parseInt(rsp.getCode());
                }
                if (ret < 0) {
                    msg.append("ret \uff1a").append(rsp.getCode()).append(", msg: ").append(rsp.getMsg()).append("</br>");
                } else if (StringUtils.isNotEmpty((CharSequence)rsp.getBody())) {
                    resultMsg.setData((Object)rsp.getBody());
                } else {
                    msg.append("msg:").append(I18nUtil.i18nCode((String)"system_api_upload_paramFail", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                log.error("-----upload base sysparams error---", (Throwable)e);
                msg.append(I18nUtil.i18nCode((String)"system_api_upload_paramFail", (Object[])new Object[0])).append("!").append("</br>");
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
            return resultMsg;
        }
        return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
    }
}

