/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.client.service;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.business.sdk.vo.ApiAuthDepartmentItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.ModelUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthCloudMessageSendServiceImpl {
    @Autowired
    private AuthDepartmentService authDepartmentService;

    public ZKResultMsg updateAuthDepartment(ZKMessage zkMessage) {
        List authDeptList = zkMessage.getListContent();
        if (authDeptList != null && authDeptList.size() > 0) {
            List authDepartmentItems = JSONArray.parseArray((String)authDeptList.toString(), ApiAuthDepartmentItem.class);
            this.batchSaveItemFromCloud(authDepartmentItems);
        }
        return ZKResultMsg.successMsg();
    }

    private void batchSaveItemFromCloud(List<ApiAuthDepartmentItem> authDepartmentItems) {
        if (!CollectionUtil.isEmpty(authDepartmentItems)) {
            Set codes = CollectionUtil.listToPropertySet(authDepartmentItems, ApiAuthDepartmentItem::getCode);
            codes.addAll(CollectionUtil.listToPropertySet(authDepartmentItems, ApiAuthDepartmentItem::getParentCode));
            AuthDepartmentItem authDepartmentItem = new AuthDepartmentItem();
            authDepartmentItem.setInCode(StringUtils.join((Iterable)codes, (String)","));
            List authDepartmentItemList = this.authDepartmentService.getByCondition(authDepartmentItem);
            Map authDepartmentItemMap = new HashMap();
            if (!CollectionUtil.isEmpty((Collection)authDepartmentItemList)) {
                authDepartmentItemMap = CollectionUtil.listToKeyMap((Collection)authDepartmentItemList, AuthDepartmentItem::getCode);
            }
            for (ApiAuthDepartmentItem apiAuthDepartmentItem : authDepartmentItems) {
                AuthDepartmentItem item = (AuthDepartmentItem)authDepartmentItemMap.get(apiAuthDepartmentItem.getCode());
                if (item == null) {
                    item = new AuthDepartmentItem();
                    item.setSortNo(Integer.valueOf(99999));
                }
                ModelUtil.copyPropertiesIgnoreNull((Object)apiAuthDepartmentItem, (Object)item);
                if (StringUtils.isNotBlank((CharSequence)apiAuthDepartmentItem.getParentCode())) {
                    AuthDepartmentItem parentItem = (AuthDepartmentItem)authDepartmentItemMap.get(apiAuthDepartmentItem.getParentCode());
                    if (parentItem != null) {
                        item.setParentId(parentItem.getId());
                    } else {
                        item.setParentId(null);
                    }
                } else {
                    item.setParentId(null);
                }
                this.authDepartmentService.saveItem(item);
            }
        }
    }
}

