/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo.patrol;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="IVS_PATROL_REPORT t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=550, winWidth=900, operates={@GridOperate(type="custom", click="ivsPatrolReport.viewReportDetails", label="vid_common_details")})
public class IvsPatrolReportItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PLAN_ID")
    private String planId;
    @Column(name="t.PLAN_NAME")
    @GridColumn(label="ivs_patrolPlan_name", width="200")
    private String planName;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="common_time", width="200")
    private Date createTime;
    @Column(name="t.USER_NAME")
    @GridColumn(label="ivs_patrolReport_reporter", width="100")
    private String userName;
    @Column(name="t.USER_FITST_NAME")
    @GridColumn(label="ivs_patrolPlan_firstname", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String userFirstName;
    @Column(name="t.USER_LAST_NAME")
    @GridColumn(label="ivs_patrolPlan_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String userLastName;
    @Column(name="t.GROUP_NAME")
    @GridColumn(label="ivs_patrolGroup_name", width="200")
    private String groupName;
    @Column(name="t.SHIFT_ID")
    private String shiftId;
    @Column(name="t.SHIFT_NAME")
    @GridColumn(label="ivs_patrolReport_shiftTime", width="130")
    private String shiftName;
    @Column(name="t.VIDEO_COUNT")
    @GridColumn(label="ivs_patrolReport_videoTotal", width="80")
    private Integer videoCount;
    @Column(name="t.ALARM_COUNT")
    @GridColumn(label="ivs_patrolReport_alarmCount", width="80")
    private Integer alarmCount;
    @Column(name="t.CHECK_IN_COUNT")
    @GridColumn(label="ivs_patrolReport_checkInCount", width="80")
    private Integer checkInCount;
    @Column(name="t.MISS_CARD_COUNT")
    @GridColumn(label="ivs_patrolReport_missCardCount", width="80")
    private Integer missCardCount;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", columnType="custom", convert="ivsPatrolReport.setIvsPatrolReportStatus", format="0=common_normal,1=common_exception")
    private String status;
    @Column(name="t.REPORT_DATE")
    private String reportDate;
    @Column(name="t.DESCRIPTION")
    @GridColumn(label="ivs_ivsPatrolAlarm_content", width="200", i18n=true)
    private String description;
    @Condition(value="t.CREATE_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.CREATE_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="(LOWER(t.USER_FITST_NAME) LIKE LOWER(''%{0}%'') OR LOWER(t.USER_LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;

    public String getId() {
        return this.id;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getPlanName() {
        return this.planName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getShiftId() {
        return this.shiftId;
    }

    public String getShiftName() {
        return this.shiftName;
    }

    public Integer getVideoCount() {
        return this.videoCount;
    }

    public Integer getAlarmCount() {
        return this.alarmCount;
    }

    public Integer getCheckInCount() {
        return this.checkInCount;
    }

    public Integer getMissCardCount() {
        return this.missCardCount;
    }

    public String getStatus() {
        return this.status;
    }

    public String getReportDate() {
        return this.reportDate;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public IvsPatrolReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsPatrolReportItem setPlanId(String planId) {
        this.planId = planId;
        return this;
    }

    public IvsPatrolReportItem setPlanName(String planName) {
        this.planName = planName;
        return this;
    }

    public IvsPatrolReportItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public IvsPatrolReportItem setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public IvsPatrolReportItem setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
        return this;
    }

    public IvsPatrolReportItem setUserLastName(String userLastName) {
        this.userLastName = userLastName;
        return this;
    }

    public IvsPatrolReportItem setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public IvsPatrolReportItem setShiftId(String shiftId) {
        this.shiftId = shiftId;
        return this;
    }

    public IvsPatrolReportItem setShiftName(String shiftName) {
        this.shiftName = shiftName;
        return this;
    }

    public IvsPatrolReportItem setVideoCount(Integer videoCount) {
        this.videoCount = videoCount;
        return this;
    }

    public IvsPatrolReportItem setAlarmCount(Integer alarmCount) {
        this.alarmCount = alarmCount;
        return this;
    }

    public IvsPatrolReportItem setCheckInCount(Integer checkInCount) {
        this.checkInCount = checkInCount;
        return this;
    }

    public IvsPatrolReportItem setMissCardCount(Integer missCardCount) {
        this.missCardCount = missCardCount;
        return this;
    }

    public IvsPatrolReportItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IvsPatrolReportItem setReportDate(String reportDate) {
        this.reportDate = reportDate;
        return this;
    }

    public IvsPatrolReportItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public IvsPatrolReportItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public IvsPatrolReportItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public IvsPatrolReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }
}

