/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo.patrol;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="IVS_PATROLPLAN t LEFT JOIN IVS_PATROLGROUP vp ON t.PATROL_GROUPID = vp.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=550, winWidth=800, operates={@GridOperate(type="edit", permission="ivs:patrolPlan:edit", url="ivsPatrolPlan.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="ivs:patrolPlan:del", url="ivsPatrolPlan.do?del", label="common_op_del"), @GridOperate(type="custom", showConvertor="hasMailSetting", click="showMailSetting", label="base_mail_paramSetting")})
public class IvsPatrolPlanItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="ivs_patrolPlan_name", width="150", editPermission="ivs:patrolPlan:edit", editUrl="ivsPatrolPlan.do?edit", sortNo=1)
    private String name;
    @Column(name="t.START_DATE")
    @DateType(type="date")
    @GridColumn(label="common_startDate", width="100", sortNo=2)
    private Date startDate;
    @Column(name="t.END_DATE")
    @DateType(type="date")
    @GridColumn(label="common_endDate", width="100", sortNo=3)
    private Date endDate;
    @Column(name="t.PATROL_GROUPID")
    private String patrolGroupId;
    @Condition(value="t.PATROL_GROUPID", equalTag="in")
    private String inPatrolGroupId;
    @Column(name="vp.NAME")
    @GridColumn(label="ivs_patrolGroup_name", width="160", sortNo=4)
    private String patrolGroupName;
    @Column(name="t.IVS_ANSWER_COUNT")
    @GridColumn(label="ivs_patrolPlan_ivsAnswerCount", width="240", sortNo=6)
    private Integer ivsAnswerCount;
    @Column(name="t.MAP_ID")
    private String mapId;
    @Column(name="t.IVS_AUTO_PLAY")
    @GridColumn(label="ivs_patrol_way", width="240", format="true=ivs_patrol_auto,false=ivs_patrol_manual", sortNo=6)
    private String ivsAutoPlay;
    private String patrolShiftJson;
    private String ivsChannelIds;
    private String ivsPatrolTimes;
    private String status;
    private boolean mailSetting;

    public boolean hasMailSetting() {
        return this.mailSetting;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getPatrolGroupId() {
        return this.patrolGroupId;
    }

    public String getInPatrolGroupId() {
        return this.inPatrolGroupId;
    }

    public String getPatrolGroupName() {
        return this.patrolGroupName;
    }

    public Integer getIvsAnswerCount() {
        return this.ivsAnswerCount;
    }

    public String getMapId() {
        return this.mapId;
    }

    public String getIvsAutoPlay() {
        return this.ivsAutoPlay;
    }

    public String getPatrolShiftJson() {
        return this.patrolShiftJson;
    }

    public String getIvsChannelIds() {
        return this.ivsChannelIds;
    }

    public String getIvsPatrolTimes() {
        return this.ivsPatrolTimes;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isMailSetting() {
        return this.mailSetting;
    }

    public IvsPatrolPlanItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsPatrolPlanItem setName(String name) {
        this.name = name;
        return this;
    }

    public IvsPatrolPlanItem setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public IvsPatrolPlanItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public IvsPatrolPlanItem setPatrolGroupId(String patrolGroupId) {
        this.patrolGroupId = patrolGroupId;
        return this;
    }

    public IvsPatrolPlanItem setInPatrolGroupId(String inPatrolGroupId) {
        this.inPatrolGroupId = inPatrolGroupId;
        return this;
    }

    public IvsPatrolPlanItem setPatrolGroupName(String patrolGroupName) {
        this.patrolGroupName = patrolGroupName;
        return this;
    }

    public IvsPatrolPlanItem setIvsAnswerCount(Integer ivsAnswerCount) {
        this.ivsAnswerCount = ivsAnswerCount;
        return this;
    }

    public IvsPatrolPlanItem setMapId(String mapId) {
        this.mapId = mapId;
        return this;
    }

    public IvsPatrolPlanItem setIvsAutoPlay(String ivsAutoPlay) {
        this.ivsAutoPlay = ivsAutoPlay;
        return this;
    }

    public IvsPatrolPlanItem setPatrolShiftJson(String patrolShiftJson) {
        this.patrolShiftJson = patrolShiftJson;
        return this;
    }

    public IvsPatrolPlanItem setIvsChannelIds(String ivsChannelIds) {
        this.ivsChannelIds = ivsChannelIds;
        return this;
    }

    public IvsPatrolPlanItem setIvsPatrolTimes(String ivsPatrolTimes) {
        this.ivsPatrolTimes = ivsPatrolTimes;
        return this;
    }

    public IvsPatrolPlanItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IvsPatrolPlanItem setMailSetting(boolean mailSetting) {
        this.mailSetting = mailSetting;
        return this;
    }
}

