/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@From(after="IVS_GLOBALLINKAGE_TRANSACTION t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id")
public class IvsGlobalLinkageTransactionItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.START_TIME", equalTag=">=")
    @GridColumn(label="common_op_startTime", width="150")
    private Date startTime;
    @Column(name="t.END_TIME", equalTag="<=")
    @GridColumn(label="common_op_endTime", width="150")
    private Date endTime;
    @Column(name="t.AUTH_AREA_ID")
    private String areaId;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="base_area_name", width="130")
    private String areaName;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="140")
    private String alias;
    @Column(name="t.CHANNEL_NAME")
    @GridColumn(label="ivs_channel_name", width="130")
    private String channelName;
    @Column(name="t.CHANNEL_NO")
    @GridColumn(label="ivs_channel_num", width="100", show=false)
    private String channelNo;
    @Column(name="t.FILE_TYPE")
    @GridColumn(show=false)
    private Short fileType;
    @Condition(value="(t.FILE_TYPE = %s or t.FILE_TYPE = 3)")
    private Short fileTypeQuery;
    @GridColumn(label="common_mediaFile", align="center", width="80", convert="fileTypeToIcon", columnType="custom", sort="na")
    private String fileTypeValue;
    private String personInformation;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.PERSON_LAST_NAME")
    private String lastName;
    @Column(name="t.EVENT_NAME")
    @GridColumn(label="common_event_name", width="250")
    private String eventName;
    @Column(name="EVENT_TYPE")
    @GridColumn(label="ivs_globalLinkage_eventOrigin", sort="na", format="VMS=ivs_module,ACC=acc_module,ELE=ele_module,ASS=ass_module,FEN=fence_module")
    private String eventType;
    @Column(name="t.STATUS", equalTag="=")
    @GridColumn(show=false)
    private Short status;
    @Condition(value="t.STATUS IN (%s)", formatType="quote")
    private String statusIn;
    private String statusValue;
    @Column(name="t.DESCRIPTION")
    @GridColumn(label="common_remark", i18n=true, width="*")
    private String description;
    @Column(name="t.FILE_PATH")
    @GridColumn(show=false)
    private String filePath;
    private String fileThumbBase64;
    @Column(name="t.SN")
    @GridColumn(show=false)
    private String sn;
    @Column(name="t.EVENT_NO")
    @GridColumn(show=false)
    private Short eventNo;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    private String startTimeStr;
    protected Map<String, Object> popUpVideoInfo;
    private Integer captureTime;
    private Boolean popUpInPreviewPage;
    private Object capturePhotoData;
    private String recordVideoJsonInfo;
    private Map<String, List<String>> linkagesDescriptionMap = new HashMap<String, List<String>>();

    public IvsGlobalLinkageTransactionItem() {
    }

    public IvsGlobalLinkageTransactionItem(Boolean equals) {
        super(equals);
    }

    public IvsGlobalLinkageTransactionItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public IvsGlobalLinkageTransactionItem(String id, Date startTime, Date endTime, String filePath, Short fileType, String areaId, String areaName, String sn, String alias, String channelName, Short eventNo, Short status, String description, String channelNo, String eventType) {
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filePath = filePath;
        this.fileType = fileType;
        this.areaId = areaId;
        this.areaName = areaName;
        this.sn = sn;
        this.alias = alias;
        this.channelName = channelName;
        this.eventNo = eventNo;
        this.status = status;
        this.description = description;
        this.channelNo = channelNo;
        this.eventType = eventType;
    }

    public String getId() {
        return this.id;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getChannelNo() {
        return this.channelNo;
    }

    public Short getFileType() {
        return this.fileType;
    }

    public Short getFileTypeQuery() {
        return this.fileTypeQuery;
    }

    public String getFileTypeValue() {
        return this.fileTypeValue;
    }

    public String getPersonInformation() {
        return this.personInformation;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getStatusIn() {
        return this.statusIn;
    }

    public String getStatusValue() {
        return this.statusValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileThumbBase64() {
        return this.fileThumbBase64;
    }

    public String getSn() {
        return this.sn;
    }

    public Short getEventNo() {
        return this.eventNo;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getStartTimeStr() {
        return this.startTimeStr;
    }

    public Map<String, Object> getPopUpVideoInfo() {
        return this.popUpVideoInfo;
    }

    public Integer getCaptureTime() {
        return this.captureTime;
    }

    public Boolean getPopUpInPreviewPage() {
        return this.popUpInPreviewPage;
    }

    public Object getCapturePhotoData() {
        return this.capturePhotoData;
    }

    public String getRecordVideoJsonInfo() {
        return this.recordVideoJsonInfo;
    }

    public Map<String, List<String>> getLinkagesDescriptionMap() {
        return this.linkagesDescriptionMap;
    }

    public IvsGlobalLinkageTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setChannelName(String channelName) {
        this.channelName = channelName;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setChannelNo(String channelNo) {
        this.channelNo = channelNo;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setFileType(Short fileType) {
        this.fileType = fileType;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setFileTypeQuery(Short fileTypeQuery) {
        this.fileTypeQuery = fileTypeQuery;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setFileTypeValue(String fileTypeValue) {
        this.fileTypeValue = fileTypeValue;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setPersonInformation(String personInformation) {
        this.personInformation = personInformation;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setName(String name) {
        this.name = name;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setStatusIn(String statusIn) {
        this.statusIn = statusIn;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setStatusValue(String statusValue) {
        this.statusValue = statusValue;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setFileThumbBase64(String fileThumbBase64) {
        this.fileThumbBase64 = fileThumbBase64;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setEventNo(Short eventNo) {
        this.eventNo = eventNo;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setStartTimeStr(String startTimeStr) {
        this.startTimeStr = startTimeStr;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setPopUpVideoInfo(Map<String, Object> popUpVideoInfo) {
        this.popUpVideoInfo = popUpVideoInfo;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setCaptureTime(Integer captureTime) {
        this.captureTime = captureTime;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setPopUpInPreviewPage(Boolean popUpInPreviewPage) {
        this.popUpInPreviewPage = popUpInPreviewPage;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setCapturePhotoData(Object capturePhotoData) {
        this.capturePhotoData = capturePhotoData;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setRecordVideoJsonInfo(String recordVideoJsonInfo) {
        this.recordVideoJsonInfo = recordVideoJsonInfo;
        return this;
    }

    public IvsGlobalLinkageTransactionItem setLinkagesDescriptionMap(Map<String, List<String>> linkagesDescriptionMap) {
        this.linkagesDescriptionMap = linkagesDescriptionMap;
        return this;
    }

    public String toString() {
        return "IvsGlobalLinkageTransactionItem(id=" + this.getId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", areaId=" + this.getAreaId() + ", areaName=" + this.getAreaName() + ", alias=" + this.getAlias() + ", channelName=" + this.getChannelName() + ", channelNo=" + this.getChannelNo() + ", fileType=" + this.getFileType() + ", fileTypeQuery=" + this.getFileTypeQuery() + ", fileTypeValue=" + this.getFileTypeValue() + ", personInformation=" + this.getPersonInformation() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", eventName=" + this.getEventName() + ", eventType=" + this.getEventType() + ", status=" + this.getStatus() + ", statusIn=" + this.getStatusIn() + ", statusValue=" + this.getStatusValue() + ", description=" + this.getDescription() + ", filePath=" + this.getFilePath() + ", fileThumbBase64=" + this.getFileThumbBase64() + ", sn=" + this.getSn() + ", eventNo=" + this.getEventNo() + ", areaIdIn=" + this.getAreaIdIn() + ", startTimeStr=" + this.getStartTimeStr() + ", popUpVideoInfo=" + this.getPopUpVideoInfo() + ", captureTime=" + this.getCaptureTime() + ", popUpInPreviewPage=" + this.getPopUpInPreviewPage() + ", capturePhotoData=" + this.getCapturePhotoData() + ", recordVideoJsonInfo=" + this.getRecordVideoJsonInfo() + ", linkagesDescriptionMap=" + this.getLinkagesDescriptionMap() + ")";
    }
}

