/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelItem;
import java.io.Serializable;
import java.util.List;

@From(after="IVS_DEVICE t LEFT JOIN IVS_EDGE_DEVICE pd ON pd.ID = t.PARENT_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", operates={})
public class IvsExtDeviceItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @GridColumn(label="ivs_acc_code", width="100", show=false)
    @Column(name="t.CODE")
    private String code;
    @Column(name="t.NAME")
    @GridColumn(label="common_dev_name", width="120", sort="na")
    private String name;
    @Column(name="pd.NAME")
    @GridColumn(label="ivs_ext_device_manager", width="120", sort="na")
    private String alias;
    @GridColumn(label="ivs_channelCode", width="60", show=false)
    private String channel;
    @Column(name="t.AUTH_AREA_ID")
    private String areaId;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @GridColumn(label="base_area_name", width="100", sort="na")
    private String areaName;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", width="60", convert="ivsConvertToString", columnType="custom", sort="na")
    private String status;
    @Column(name="t.DEV_FORM_TYPE", equalTag="=")
    @GridColumn(label="ivs_device_form_type", width="80", format="1=IPC,2=DVS,3=DVR,4=eNVR,5=SDC", show=false)
    private String devFormType;
    @Column(name="t.MODEL_TYPE")
    @GridColumn(label="ivs_deviceType", width="120", show=false)
    private String devModelType;
    private List<IvsChannelItem> ivsChannelItems;

    public IvsExtDeviceItem() {
    }

    public IvsExtDeviceItem(String id) {
        this.id = id;
    }

    public boolean showConvertor() {
        return "5".equals(this.devFormType);
    }

    public IvsExtDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsExtDeviceItem setCode(String code) {
        this.code = code;
        return this;
    }

    public IvsExtDeviceItem setName(String name) {
        this.name = name;
        return this;
    }

    public IvsExtDeviceItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public IvsExtDeviceItem setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public IvsExtDeviceItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public IvsExtDeviceItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public IvsExtDeviceItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public IvsExtDeviceItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IvsExtDeviceItem setDevFormType(String devFormType) {
        this.devFormType = devFormType;
        return this;
    }

    public IvsExtDeviceItem setDevModelType(String devModelType) {
        this.devModelType = devModelType;
        return this;
    }

    public IvsExtDeviceItem setIvsChannelItems(List<IvsChannelItem> ivsChannelItems) {
        this.ivsChannelItems = ivsChannelItems;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDevFormType() {
        return this.devFormType;
    }

    public String getDevModelType() {
        return this.devModelType;
    }

    public List<IvsChannelItem> getIvsChannelItems() {
        return this.ivsChannelItems;
    }
}

