/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsPersonnelListItem;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@From(after="IVS_EDGE_DEVICE t ")
@OrderBy(after="t.TYPE ASC, t.NAME ASC")
@GridConfig(operate=true, idField="id", winHeight=450)
public class IvsEdgeDeviceItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Condition(equalTag="in", value="t.ID")
    private String inId;
    @GridColumn(width="40", sort="na", columnType="ra")
    private String ra;
    @Column(name="t.NAME")
    @GridColumn(label="common_name", width="120")
    private String name;
    @Column(name="t.PORT")
    @GridColumn(label="base_db_port", width="100", show=false)
    private String port;
    @Column(name="t.USER_NAME")
    @GridColumn(label="ivs_user_name", width="100", show=false)
    private String userName;
    @Column(name="t.IP", equalTag="=")
    @GridColumn(label="ivs_parent_device_address", width="120")
    private String ip;
    @Column(name="t.PASS_WORD", encryptConverter=true)
    @GridColumn(label="base_login_password", width="100", show=false)
    private String passWord;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", width="50", convert="hwConvertToIcon", columnType="custom")
    private String status;
    @Column(name="t.TYPE", equalTag="=")
    @GridColumn(label="ivs_parent_device_model", width="100", format="0=ivs_parent_device_IVS1800,1=ivs_parent_device_IVS3800,2=ivs_parent_device_NVR800,5=ivs_parent_device_SDC,4=ivs_parent_device_CLOUD,7=ivs_parent_device_ZKNVR")
    private String type;
    @Condition(value="t.TYPE", equalTag="not in")
    private String notInType;
    @GridColumn(label="ivs_channel_is_subscribe", width="80", convert="hwConvertToIcon", columnType="custom")
    private String subStatus;
    private String securitySession;
    private String token;
    @GridColumn(label="ivs_domainCode", width="100")
    @Column(name="t.DOMAIN_CODE")
    private String domainCode;
    @Condition(value="t.DOMAIN_CODE", equalTag="in")
    private String inDomainCode;
    private String isHttps;
    private String jsServerPort;
    private String jsSessionId;
    private String deviceType;
    private String isCertificate;
    @Column(name="t.MODEL_TYPE")
    private String modelType;
    @Column(name="t.VERSION")
    private String version;
    @Column(name="t.CREATE_Time")
    private Date createTime;
    private String areaId;
    private String areaName;
    private String inAreaId;
    @GridColumn(label="ivs_isFrom", width="100", format="0=ivs_local,1=ivs_cloud")
    private String isFrom;
    private String isFromType;
    private String code;
    @Column(name="t.COMPANY_ID")
    private String companyId;
    @Column(name="t.VENDOR")
    private String vendor;
    @Column(name="t.COMPANY_ID", equalTag="in")
    private String companyIds;
    private String productName;
    private List<IvsPersonnelListItem> personnelListItemList;
    private List<IvsDeviceItem> ivsDeviceItemList;
    private JSONArray algorithms;
    private String userId;
    private String enterpriseId;

    public IvsEdgeDeviceItem() {
    }

    public IvsEdgeDeviceItem(String id) {
        this.id = id;
    }

    public IvsEdgeDeviceItem(String code, String name, String domainCode, String status, String type, String isFrom, String isFromType) {
        this.code = code;
        this.name = name;
        this.domainCode = domainCode;
        this.status = status;
        this.type = type;
        this.isFrom = isFrom;
        this.isFromType = isFromType;
    }

    public IvsEdgeDeviceItem(String isFrom, String isFromType) {
        this.isFrom = isFrom;
        this.isFromType = isFromType;
    }

    public IvsEdgeDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsEdgeDeviceItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public IvsEdgeDeviceItem setRa(String ra) {
        this.ra = ra;
        return this;
    }

    public IvsEdgeDeviceItem setName(String name) {
        this.name = name;
        return this;
    }

    public IvsEdgeDeviceItem setPort(String port) {
        this.port = port;
        return this;
    }

    public IvsEdgeDeviceItem setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public IvsEdgeDeviceItem setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public IvsEdgeDeviceItem setPassWord(String passWord) {
        this.passWord = passWord;
        return this;
    }

    public IvsEdgeDeviceItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IvsEdgeDeviceItem setType(String type) {
        this.type = type;
        return this;
    }

    public IvsEdgeDeviceItem setNotInType(String notInType) {
        this.notInType = notInType;
        return this;
    }

    public IvsEdgeDeviceItem setSubStatus(String subStatus) {
        this.subStatus = subStatus;
        return this;
    }

    public IvsEdgeDeviceItem setSecuritySession(String securitySession) {
        this.securitySession = securitySession;
        return this;
    }

    public IvsEdgeDeviceItem setToken(String token) {
        this.token = token;
        return this;
    }

    public IvsEdgeDeviceItem setDomainCode(String domainCode) {
        this.domainCode = domainCode;
        return this;
    }

    public IvsEdgeDeviceItem setInDomainCode(String inDomainCode) {
        this.inDomainCode = inDomainCode;
        return this;
    }

    public IvsEdgeDeviceItem setIsHttps(String isHttps) {
        this.isHttps = isHttps;
        return this;
    }

    public IvsEdgeDeviceItem setJsServerPort(String jsServerPort) {
        this.jsServerPort = jsServerPort;
        return this;
    }

    public IvsEdgeDeviceItem setJsSessionId(String jsSessionId) {
        this.jsSessionId = jsSessionId;
        return this;
    }

    public IvsEdgeDeviceItem setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public IvsEdgeDeviceItem setIsCertificate(String isCertificate) {
        this.isCertificate = isCertificate;
        return this;
    }

    public IvsEdgeDeviceItem setModelType(String modelType) {
        this.modelType = modelType;
        return this;
    }

    public IvsEdgeDeviceItem setVersion(String version) {
        this.version = version;
        return this;
    }

    public IvsEdgeDeviceItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public IvsEdgeDeviceItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public IvsEdgeDeviceItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public IvsEdgeDeviceItem setInAreaId(String inAreaId) {
        this.inAreaId = inAreaId;
        return this;
    }

    public IvsEdgeDeviceItem setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public IvsEdgeDeviceItem setIsFromType(String isFromType) {
        this.isFromType = isFromType;
        return this;
    }

    public IvsEdgeDeviceItem setCode(String code) {
        this.code = code;
        return this;
    }

    public IvsEdgeDeviceItem setCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    public IvsEdgeDeviceItem setVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public IvsEdgeDeviceItem setCompanyIds(String companyIds) {
        this.companyIds = companyIds;
        return this;
    }

    public IvsEdgeDeviceItem setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public IvsEdgeDeviceItem setPersonnelListItemList(List<IvsPersonnelListItem> personnelListItemList) {
        this.personnelListItemList = personnelListItemList;
        return this;
    }

    public IvsEdgeDeviceItem setIvsDeviceItemList(List<IvsDeviceItem> ivsDeviceItemList) {
        this.ivsDeviceItemList = ivsDeviceItemList;
        return this;
    }

    public IvsEdgeDeviceItem setAlgorithms(JSONArray algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    public IvsEdgeDeviceItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public IvsEdgeDeviceItem setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getInId() {
        return this.inId;
    }

    public String getRa() {
        return this.ra;
    }

    public String getName() {
        return this.name;
    }

    public String getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getNotInType() {
        return this.notInType;
    }

    public String getSubStatus() {
        return this.subStatus;
    }

    public String getSecuritySession() {
        return this.securitySession;
    }

    public String getToken() {
        return this.token;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public String getInDomainCode() {
        return this.inDomainCode;
    }

    public String getIsHttps() {
        return this.isHttps;
    }

    public String getJsServerPort() {
        return this.jsServerPort;
    }

    public String getJsSessionId() {
        return this.jsSessionId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getIsCertificate() {
        return this.isCertificate;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getInAreaId() {
        return this.inAreaId;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public String getIsFromType() {
        return this.isFromType;
    }

    public String getCode() {
        return this.code;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getCompanyIds() {
        return this.companyIds;
    }

    public String getProductName() {
        return this.productName;
    }

    public List<IvsPersonnelListItem> getPersonnelListItemList() {
        return this.personnelListItemList;
    }

    public List<IvsDeviceItem> getIvsDeviceItemList() {
        return this.ivsDeviceItemList;
    }

    public JSONArray getAlgorithms() {
        return this.algorithms;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }
}

