/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelItem;
import java.io.Serializable;
import java.util.List;

@From(after="IVS_DEVICE t LEFT JOIN IVS_EDGE_DEVICE pd ON pd.ID = t.PARENT_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=250, winWidth=400, operates={@GridOperate(type="edit", url="skip.do?page=ivs_parentdevice_editDeviceOfflinePassword&&deviceId=(id)", label="common_op_edit", showConvertor="showUpdatePassword")})
public class IvsDeviceItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.AUTH_AREA_ID")
    private String areaId;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @GridColumn(label="ivs_acc_code", width="100", show=false)
    @Column(name="t.CODE")
    private String code;
    @Column(name="t.NAME")
    @GridColumn(label="common_dev_name", width="120", sort="na", columnType="edit", editUrl="/ivsDevice.do?editDeviceName&id=(id)")
    private String name;
    @GridColumn(label="ivs_channelCode", width="120", sort="na")
    private String channel;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", width="60", convert="ivsConvertToString", columnType="custom", sort="na")
    private String status;
    @Column(name="t.DEV_FORM_TYPE", equalTag="=")
    @GridColumn(label="ivs_device_form_type", width="80", format="1=IPC,2=DVS,3=DVR,4=eNVR,5=SDC,9=INTERCOM", show=false)
    private String devFormType;
    @Column(name="t.CAMERA_TYPE")
    @GridColumn(label="ivs_ext_camera_type", width="120", format="FIX=ivs_fixedCamera,PTZ=ivs_withGimbal,DOME=ivs_ballMachine,HALFDOME=ivs_halfdome,BULLET=ivs_tubeMachine", sort="na")
    private String cameraType;
    @Column(name="t.MODEL_TYPE")
    @GridColumn(label="ivs_deviceType", width="120", sort="na")
    private String devModelType;
    @Column(name="t.PROTOCOL_TYPE")
    @GridColumn(label="ivs_ext_device_drive", width="100", show=false)
    private String protocolType;
    @Column(name="t.IP")
    @GridColumn(label="ivs_ext_device_deviceIP", width="120", sort="na")
    private String ip;
    @Column(name="t.VENDOR_TYPE")
    @GridColumn(label="ivs_ext_device_vendor_type", width="100", show=false)
    private String vendorType;
    @GridColumn(label="base_area_name", width="100", sort="na")
    private String areaName;
    @Column(name="t.USER_NAME")
    @GridColumn(label="ivs_ext_device_username", width="90", show=false)
    private String userName;
    @Column(name="t.COMM_PWD")
    @GridColumn(label="ivs_ext_device_commpwd", width="90", show=false)
    private String commPwd;
    @Column(name="t.Dev_Reg_PWD")
    @GridColumn(label="ivs_ext_device_devRegPWD", width="90", show=false)
    private String devRegPWD;
    @GridColumn(label="ivs_ext_device_situation", width="100", format="0=ivs_ext_device_abnormal,1=ivs_acc_ordinary", show=false)
    private String tag;
    @Column(name="pd.DOMAIN_CODE")
    private String domainCode;
    @Column(name="t.PORT")
    private Integer port;
    @Column(name="pd.TYPE")
    private String parentType;
    private String sequence;
    private String nvrCode;
    private String result;
    private String type;
    @Column(name="t.PARENT_ID")
    private String vidParentDeviceId;
    @Column(name="t.LOGIN_TYPE")
    private String loginType;
    @Column(name="t.CONNECT_CODE")
    private String connectCode;
    private String blanceSupport;
    private String ipType;
    @Column(name="t.SN")
    private String sn;
    @Column(name="t.REBOOT_TYPE")
    private String rebootType;
    private String imgType;
    @Column(name="t.RESERVE")
    private String reserve;
    private String rtspPort;
    private String rtspEnabel;
    @Condition(equalTag="in", value="t.ID")
    private String inId;
    private String switchMode;
    private String channelCode;
    private String sessionId;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String inAreaId;
    private String isFrom;
    @Column(name="t.COMPANY_ID", equalTag="=")
    private String enterpriseId;
    private String alias;
    private String deviceType;
    private String host;
    private Short brand;
    private Boolean enabled;
    private Short protocol;
    private String fwVersion;
    @Column(name="t.PARENT_ID", equalTag="in")
    private String vidParentDeviceIdIn;
    @Condition(value="t.ID", equalTag="in")
    private String deviceIds;
    private String domainAux;
    private String subStatus;
    @Condition(value="t.AREA_NAME IN (select aa.name from auth_area aa where aa.id in(select aua.auth_area_id from auth_user_area aua where aua.auth_user_id = ''{0}''))")
    private String areaNameByUserId;
    private List<IvsChannelItem> ivsChannelItems;

    public IvsDeviceItem() {
    }

    public IvsDeviceItem(String id) {
        this.id = id;
    }

    public boolean showUpdatePassword() {
        if ("10".equals(this.parentType) || "14".equals(this.parentType)) {
            return false;
        }
        return this.status != null && "0".equals(this.status);
    }

    public IvsDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsDeviceItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public IvsDeviceItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public IvsDeviceItem setCode(String code) {
        this.code = code;
        return this;
    }

    public IvsDeviceItem setName(String name) {
        this.name = name;
        return this;
    }

    public IvsDeviceItem setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public IvsDeviceItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IvsDeviceItem setDevFormType(String devFormType) {
        this.devFormType = devFormType;
        return this;
    }

    public IvsDeviceItem setCameraType(String cameraType) {
        this.cameraType = cameraType;
        return this;
    }

    public IvsDeviceItem setDevModelType(String devModelType) {
        this.devModelType = devModelType;
        return this;
    }

    public IvsDeviceItem setProtocolType(String protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public IvsDeviceItem setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public IvsDeviceItem setVendorType(String vendorType) {
        this.vendorType = vendorType;
        return this;
    }

    public IvsDeviceItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public IvsDeviceItem setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public IvsDeviceItem setCommPwd(String commPwd) {
        this.commPwd = commPwd;
        return this;
    }

    public IvsDeviceItem setDevRegPWD(String devRegPWD) {
        this.devRegPWD = devRegPWD;
        return this;
    }

    public IvsDeviceItem setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public IvsDeviceItem setDomainCode(String domainCode) {
        this.domainCode = domainCode;
        return this;
    }

    public IvsDeviceItem setPort(Integer port) {
        this.port = port;
        return this;
    }

    public IvsDeviceItem setParentType(String parentType) {
        this.parentType = parentType;
        return this;
    }

    public IvsDeviceItem setSequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public IvsDeviceItem setNvrCode(String nvrCode) {
        this.nvrCode = nvrCode;
        return this;
    }

    public IvsDeviceItem setResult(String result) {
        this.result = result;
        return this;
    }

    public IvsDeviceItem setType(String type) {
        this.type = type;
        return this;
    }

    public IvsDeviceItem setVidParentDeviceId(String vidParentDeviceId) {
        this.vidParentDeviceId = vidParentDeviceId;
        return this;
    }

    public IvsDeviceItem setLoginType(String loginType) {
        this.loginType = loginType;
        return this;
    }

    public IvsDeviceItem setConnectCode(String connectCode) {
        this.connectCode = connectCode;
        return this;
    }

    public IvsDeviceItem setBlanceSupport(String blanceSupport) {
        this.blanceSupport = blanceSupport;
        return this;
    }

    public IvsDeviceItem setIpType(String ipType) {
        this.ipType = ipType;
        return this;
    }

    public IvsDeviceItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public IvsDeviceItem setRebootType(String rebootType) {
        this.rebootType = rebootType;
        return this;
    }

    public IvsDeviceItem setImgType(String imgType) {
        this.imgType = imgType;
        return this;
    }

    public IvsDeviceItem setReserve(String reserve) {
        this.reserve = reserve;
        return this;
    }

    public IvsDeviceItem setRtspPort(String rtspPort) {
        this.rtspPort = rtspPort;
        return this;
    }

    public IvsDeviceItem setRtspEnabel(String rtspEnabel) {
        this.rtspEnabel = rtspEnabel;
        return this;
    }

    public IvsDeviceItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public IvsDeviceItem setSwitchMode(String switchMode) {
        this.switchMode = switchMode;
        return this;
    }

    public IvsDeviceItem setChannelCode(String channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    public IvsDeviceItem setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public IvsDeviceItem setInAreaId(String inAreaId) {
        this.inAreaId = inAreaId;
        return this;
    }

    public IvsDeviceItem setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public IvsDeviceItem setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
        return this;
    }

    public IvsDeviceItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public IvsDeviceItem setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public IvsDeviceItem setHost(String host) {
        this.host = host;
        return this;
    }

    public IvsDeviceItem setBrand(Short brand) {
        this.brand = brand;
        return this;
    }

    public IvsDeviceItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public IvsDeviceItem setProtocol(Short protocol) {
        this.protocol = protocol;
        return this;
    }

    public IvsDeviceItem setFwVersion(String fwVersion) {
        this.fwVersion = fwVersion;
        return this;
    }

    public IvsDeviceItem setVidParentDeviceIdIn(String vidParentDeviceIdIn) {
        this.vidParentDeviceIdIn = vidParentDeviceIdIn;
        return this;
    }

    public IvsDeviceItem setDeviceIds(String deviceIds) {
        this.deviceIds = deviceIds;
        return this;
    }

    public IvsDeviceItem setDomainAux(String domainAux) {
        this.domainAux = domainAux;
        return this;
    }

    public IvsDeviceItem setSubStatus(String subStatus) {
        this.subStatus = subStatus;
        return this;
    }

    public IvsDeviceItem setAreaNameByUserId(String areaNameByUserId) {
        this.areaNameByUserId = areaNameByUserId;
        return this;
    }

    public IvsDeviceItem setIvsChannelItems(List<IvsChannelItem> ivsChannelItems) {
        this.ivsChannelItems = ivsChannelItems;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDevFormType() {
        return this.devFormType;
    }

    public String getCameraType() {
        return this.cameraType;
    }

    public String getDevModelType() {
        return this.devModelType;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public String getIp() {
        return this.ip;
    }

    public String getVendorType() {
        return this.vendorType;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getCommPwd() {
        return this.commPwd;
    }

    public String getDevRegPWD() {
        return this.devRegPWD;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getParentType() {
        return this.parentType;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getNvrCode() {
        return this.nvrCode;
    }

    public String getResult() {
        return this.result;
    }

    public String getType() {
        return this.type;
    }

    public String getVidParentDeviceId() {
        return this.vidParentDeviceId;
    }

    public String getLoginType() {
        return this.loginType;
    }

    public String getConnectCode() {
        return this.connectCode;
    }

    public String getBlanceSupport() {
        return this.blanceSupport;
    }

    public String getIpType() {
        return this.ipType;
    }

    public String getSn() {
        return this.sn;
    }

    public String getRebootType() {
        return this.rebootType;
    }

    public String getImgType() {
        return this.imgType;
    }

    public String getReserve() {
        return this.reserve;
    }

    public String getRtspPort() {
        return this.rtspPort;
    }

    public String getRtspEnabel() {
        return this.rtspEnabel;
    }

    public String getInId() {
        return this.inId;
    }

    public String getSwitchMode() {
        return this.switchMode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getInAreaId() {
        return this.inAreaId;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getHost() {
        return this.host;
    }

    public Short getBrand() {
        return this.brand;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Short getProtocol() {
        return this.protocol;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public String getVidParentDeviceIdIn() {
        return this.vidParentDeviceIdIn;
    }

    public String getDeviceIds() {
        return this.deviceIds;
    }

    public String getDomainAux() {
        return this.domainAux;
    }

    public String getSubStatus() {
        return this.subStatus;
    }

    public String getAreaNameByUserId() {
        return this.areaNameByUserId;
    }

    public List<IvsChannelItem> getIvsChannelItems() {
        return this.ivsChannelItems;
    }
}

