/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="IVS_CHANNEL t JOIN IVS_DEVICE p ON p.ID = t.DEVICE_ID LEFT JOIN IVS_EDGE_DEVICE pd ON pd.ID = t.PARENT_ID ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id")
public class IvsChannelSelectItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.name")
    @GridColumn(label="common_dev_channelName", width="120")
    private String name;
    @Column(name="pd.NAME")
    @GridColumn(label="common_ownedDev", width="120")
    private String alias;
    @Column(name="t.code")
    private String channelCode;
    @Column(name="p.IP")
    @GridColumn(label="ivs_ext_device_deviceIP", width="100")
    private String ip;
    private String formType;
    @Column(name="t.DEVICE_ID")
    private String devId;
    @Column(name="p.SN")
    private String deviceSn;
    @Column(name="t.STATUS")
    @GridColumn(label="ivs_ext_device_status", width="60", convert="ivsConvertToString", columnType="custom")
    private String status;
    @Column(name="pd.TYPE")
    private String deviceType;
    @Column(name="pd.DOMAIN_CODE")
    private String domainCode;
    @Column(name="pd.ID")
    private String parentId;
    private String groupIds;
    private String filterId;
    private String authAreaIdIn;
    private String selectId;
    private String type;
    private String linkId;
    @Condition(equalTag="in", value="t.ID")
    private String inId;
    @Condition(equalTag="not in", value="t.ID")
    private String notInId;
    @Condition(equalTag="in", value="t.DEVICE_ID")
    private String devIdIn;
    @Condition(value="(t.IS_FROM NOT IN (''{0}'') OR t.IS_FROM IS NULL)")
    private String isFromNotIn;
    @Condition(equalTag="not in", value="pd.TYPE")
    private String deviceTypeNotIn;
    @Condition(value="p.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @Condition(value="p.PARENT_ID IN (%s)", formatType="quote")
    private String parentDeviceIdIn;

    public IvsChannelSelectItem() {
    }

    public IvsChannelSelectItem(String id) {
        this.id = id;
    }

    public IvsChannelSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public IvsChannelSelectItem setName(String name) {
        this.name = name;
        return this;
    }

    public IvsChannelSelectItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public IvsChannelSelectItem setChannelCode(String channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    public IvsChannelSelectItem setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public IvsChannelSelectItem setFormType(String formType) {
        this.formType = formType;
        return this;
    }

    public IvsChannelSelectItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public IvsChannelSelectItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public IvsChannelSelectItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public IvsChannelSelectItem setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public IvsChannelSelectItem setDomainCode(String domainCode) {
        this.domainCode = domainCode;
        return this;
    }

    public IvsChannelSelectItem setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public IvsChannelSelectItem setGroupIds(String groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public IvsChannelSelectItem setFilterId(String filterId) {
        this.filterId = filterId;
        return this;
    }

    public IvsChannelSelectItem setAuthAreaIdIn(String authAreaIdIn) {
        this.authAreaIdIn = authAreaIdIn;
        return this;
    }

    public IvsChannelSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public IvsChannelSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public IvsChannelSelectItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    public IvsChannelSelectItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public IvsChannelSelectItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public IvsChannelSelectItem setDevIdIn(String devIdIn) {
        this.devIdIn = devIdIn;
        return this;
    }

    public IvsChannelSelectItem setIsFromNotIn(String isFromNotIn) {
        this.isFromNotIn = isFromNotIn;
        return this;
    }

    public IvsChannelSelectItem setDeviceTypeNotIn(String deviceTypeNotIn) {
        this.deviceTypeNotIn = deviceTypeNotIn;
        return this;
    }

    public IvsChannelSelectItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public IvsChannelSelectItem setParentDeviceIdIn(String parentDeviceIdIn) {
        this.parentDeviceIdIn = parentDeviceIdIn;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String getIp() {
        return this.ip;
    }

    public String getFormType() {
        return this.formType;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getGroupIds() {
        return this.groupIds;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public String getAuthAreaIdIn() {
        return this.authAreaIdIn;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getType() {
        return this.type;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getDevIdIn() {
        return this.devIdIn;
    }

    public String getIsFromNotIn() {
        return this.isFromNotIn;
    }

    public String getDeviceTypeNotIn() {
        return this.deviceTypeNotIn;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getParentDeviceIdIn() {
        return this.parentDeviceIdIn;
    }
}

